/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.forge.registry;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarLog;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ForgeRegistry.class}, remap=false)
public class MixinForgeRegistry {
    @Unique
    private static final Set<ResourceLocation> stellar_core$BLACK_LIST = new ObjectOpenHashSet();
    @Unique
    private static boolean stellar_core$blackListInitialized = false;

    @Inject(method={"register"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectRegister(IForgeRegistryEntry<?> value, CallbackInfo ci) {
        if (MixinForgeRegistry.stellar_core$isInBlackList(value.getRegistryName())) {
            StellarLog.LOG.warn("[StellarCore] Removed forge registry object {}.", (Object)value.getRegistryName());
            ci.cancel();
        }
    }

    @Unique
    private static boolean stellar_core$isInBlackList(ResourceLocation key) {
        if (!stellar_core$blackListInitialized) {
            String[] removeList;
            for (String s : removeList = StellarCoreConfig.FEATURES.vanilla.forgeRegistryRemoveList) {
                stellar_core$BLACK_LIST.add(new ResourceLocation(s));
            }
            stellar_core$blackListInitialized = true;
        }
        return !stellar_core$BLACK_LIST.isEmpty() && stellar_core$BLACK_LIST.contains(key);
    }
}

