/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.itemstack;

import github.kasuminova.stellarcore.common.itemstack.ItemStackCapInitTask;
import github.kasuminova.stellarcore.common.itemstack.ItemStackCapInitializer;
import github.kasuminova.stellarcore.common.itemstack.SharedEmptyTag;
import github.kasuminova.stellarcore.mixin.util.StellarItemStack;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IRegistryDelegate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class MixinItemStack
implements StellarItemStack {
    @Shadow(remap=false)
    private IRegistryDelegate<Item> delegate;
    @Shadow(remap=false)
    private CapabilityDispatcher capabilities;
    @Shadow(remap=false)
    private NBTTagCompound capNBT;
    @Final
    @Shadow
    private Item field_151002_e;
    @Shadow
    private int field_77994_a;
    @Shadow
    int field_77991_e;
    @Shadow
    private NBTTagCompound field_77990_d;
    @Shadow
    private boolean field_190928_g;
    @Unique
    private volatile ItemStackCapInitTask stellar_core$capInitTask = null;
    @Unique
    private volatile CapabilityDispatcher stellar_core$capabilities = null;

    @Nullable
    @Shadow(remap=false)
    protected abstract Item getItemRaw();

    @Shadow
    public abstract int func_190921_D();

    @Shadow
    public abstract Item func_77973_b();

    @Overwrite(remap=false)
    private void forgeInit() {
        Item item = this.getItemRaw();
        if (item != null) {
            this.delegate = item.delegate;
            this.stellar_core$capInitTask = new ItemStackCapInitTask((ItemStack)this);
            ItemStackCapInitializer.INSTANCE.addTask(this.stellar_core$capInitTask);
        }
    }

    @Override
    public void stellar_core$initCap() {
        if (this.stellar_core$capabilities != null) {
            return;
        }
        Item item = this.func_77973_b();
        if (item != Items.field_190931_a) {
            ICapabilityProvider provider = item.initCapabilities((ItemStack)this, this.capNBT);
            this.stellar_core$capabilities = ForgeEventFactory.gatherCapabilities((ItemStack)((ItemStack)this), (ICapabilityProvider)provider);
        }
    }

    @Override
    public void stellar_core$joinCapInit() {
        if (this.capabilities != null || this.stellar_core$capabilities == null) {
            return;
        }
        this.capabilities = this.stellar_core$capabilities;
        this.stellar_core$capabilities = null;
        if (this.capNBT != null && this.capabilities != null) {
            this.capabilities.deserializeNBT(this.capNBT);
        }
    }

    @Inject(method={"writeToNBT"}, at={@At(value="HEAD")})
    private void injectWriteToNBT(NBTTagCompound nbt, CallbackInfoReturnable<NBTTagCompound> cir) {
        this.stellar_core$ensureCapInitialized();
    }

    @Overwrite
    public ItemStack func_77946_l() {
        this.stellar_core$ensureCapNBTInitialized();
        ItemStack stack = new ItemStack(this.field_151002_e, this.field_77994_a, this.field_77991_e, this.capNBT);
        stack.func_190915_d(this.func_190921_D());
        if (this.field_77990_d != null) {
            stack.func_77982_d(this.field_77990_d.func_74737_b());
        }
        return stack;
    }

    @Inject(method={"hasCapability"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void injectHasCapability(Capability<?> capability, EnumFacing facing, CallbackInfoReturnable<Boolean> cir) {
        if (this.field_190928_g) {
            cir.setReturnValue((Object)false);
        }
        this.stellar_core$ensureCapInitialized();
    }

    @Inject(method={"getCapability"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void injectGetCapability(Capability<?> capability, EnumFacing facing, CallbackInfoReturnable<Object> cir) {
        if (this.field_190928_g) {
            cir.setReturnValue(null);
        }
        this.stellar_core$ensureCapInitialized();
        Object cap = this.capabilities == null ? null : this.capabilities.getCapability(capability, facing);
        cir.setReturnValue(cap);
    }

    @Inject(method={"areCapsCompatible"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void injectAreCapsCompatible(ItemStack other, CallbackInfoReturnable<Boolean> cir) {
        this.stellar_core$ensureCapInitialized();
        StellarItemStack otherAccessor = (StellarItemStack)other;
        otherAccessor.stellar_core$ensureCapInitialized();
        NBTTagCompound capNBT = this.stellar_core$getCapNBT();
        NBTTagCompound otherCapNBT = otherAccessor.stellar_core$getCapNBT();
        cir.setReturnValue((Object)(capNBT == otherCapNBT || capNBT.equals((Object)otherCapNBT) ? 1 : 0));
    }

    @Override
    @Unique
    public void stellar_core$ensureCapInitialized() {
        if (this.capabilities != null) {
            return;
        }
        if (this.stellar_core$capInitTask != null) {
            if (this.stellar_core$capInitTask == null) {
                return;
            }
            try {
                if (this.stellar_core$capInitTask.join()) {
                    this.stellar_core$capInitTask = null;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    @Unique
    public void stellar_core$ensureCapNBTInitialized() {
        if (this.capabilities != null) {
            this.capNBT = this.capabilities.serializeNBT();
        }
    }

    @Override
    public NBTTagCompound stellar_core$getCapNBT() {
        this.stellar_core$ensureCapNBTInitialized();
        return this.capNBT == null || this.capNBT.func_82582_d() ? SharedEmptyTag.EMPTY_TAG : this.capNBT;
    }

    @Override
    public CapabilityDispatcher stellar_core$getCap() {
        return this.capabilities;
    }
}

