/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.nbtmaplist;

import github.kasuminova.stellarcore.common.util.NBTTagBackingMap;
import github.kasuminova.stellarcore.mixin.util.StellarNBTTagCompound;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.DataInput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ReportedException;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NBTTagCompound.class})
public abstract class MixinNBTTagCompound
extends NBTBase
implements StellarNBTTagCompound {
    @Unique
    private static final AtomicLong stellar_core$UID = new AtomicLong();
    @Mutable
    @Shadow
    @Final
    private Map<String, NBTBase> field_74784_a;
    @Unique
    private long stellar_core$uid;
    @Unique
    private boolean stellar_core$unique = true;
    @Unique
    private boolean stellar_core$hashCached = false;
    @Unique
    private int stellar_core$hash = 0;

    @Shadow
    public abstract byte func_150299_b(String var1);

    @Shadow
    protected abstract CrashReport func_82581_a(String var1, int var2, ClassCastException var3);

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Maps;newHashMap()Ljava/util/HashMap;", remap=false))
    private HashMap<String, NBTBase> injectInitNewHashMap() {
        return null;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void injectInit(CallbackInfo ci) {
        this.stellar_core$setTagMap(new NBTTagBackingMap());
        this.stellar_core$uid = stellar_core$UID.incrementAndGet();
    }

    @Inject(method={"read"}, at={@At(value="HEAD")})
    private void injectRead(DataInput input, int depth, NBTSizeTracker sizeTracker, CallbackInfo ci) {
        this.stellar_core$onModified();
    }

    @Overwrite
    public NBTBase func_74781_a(String key) {
        NBTBase ret = this.field_74784_a.get(key);
        if (ret == null) {
            return null;
        }
        byte id = ret.func_74732_a();
        if (id == 7 || id >= 9 && id <= 12) {
            this.stellar_core$onModified();
        }
        return ret;
    }

    @Overwrite
    public void func_82580_o(String key) {
        if (this.field_74784_a.remove(key) != null) {
            this.stellar_core$onModified();
        }
    }

    @Inject(method={"merge"}, at={@At(value="HEAD")})
    private void injectMerge(NBTTagCompound other, CallbackInfo ci) {
        this.stellar_core$onModified();
    }

    @Nonnull
    @Overwrite
    public NBTTagCompound func_74737_b() {
        NBTTagCompound copied = new NBTTagCompound();
        StellarNBTTagCompound accessor = (StellarNBTTagCompound)copied;
        accessor.stellar_core$setUID(this.stellar_core$uid);
        accessor.stellar_core$setUnique(false);
        this.stellar_core$setUnique(false);
        NBTTagBackingMap cloned = ((NBTTagBackingMap)((Object)this.field_74784_a)).clone();
        accessor.stellar_core$setTagMap(cloned);
        if (this.stellar_core$hashCached) {
            accessor.stellar_core$setHashCodeCache(this.stellar_core$hash);
        }
        for (Object2ObjectMap.Entry entry : cloned.object2ObjectEntrySet()) {
            entry.setValue((Object)((NBTBase)entry.getValue()).func_74737_b());
        }
        return copied;
    }

    @Inject(method={"equals"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectEquals(Object obj, CallbackInfoReturnable<Boolean> cir) {
        if (!(obj instanceof NBTTagCompound)) {
            cir.setReturnValue((Object)Boolean.FALSE);
            return;
        }
        NBTTagCompound tag = (NBTTagCompound)obj;
        StellarNBTTagCompound accessor = (StellarNBTTagCompound)tag;
        if (!accessor.stellar_core$isUnique().booleanValue() && this.stellar_core$uid == accessor.stellar_core$getUID()) {
            cir.setReturnValue((Object)Boolean.TRUE);
            return;
        }
        boolean equals = this.field_74784_a.equals((Object)accessor.stellar_core$getTagMap());
        if (equals && !this.stellar_core$unique && !accessor.stellar_core$isUnique().booleanValue()) {
            accessor.stellar_core$setUID(this.stellar_core$uid);
        }
        cir.setReturnValue((Object)equals);
    }

    @Overwrite
    public int hashCode() {
        if (this.stellar_core$hashCached) {
            return this.stellar_core$hash;
        }
        this.stellar_core$hashCached = true;
        this.stellar_core$hash = super.hashCode() ^ this.field_74784_a.hashCode();
        return this.stellar_core$hash;
    }

    @Overwrite
    public boolean func_150297_b(String key, int requiredType) {
        byte id = this.func_150299_b(key);
        return id == requiredType || requiredType == 99 && id >= 1 && id <= 6;
    }

    @Overwrite
    public byte func_74771_c(String key) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return 0;
            }
            byte id = tag.func_74732_a();
            if (id >= 1 && id <= 6) {
                return ((NBTPrimitive)tag).func_150290_f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    @Overwrite
    public short func_74765_d(String key) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return 0;
            }
            byte id = tag.func_74732_a();
            if (id >= 1 && id <= 6) {
                return ((NBTPrimitive)tag).func_150289_e();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    @Overwrite
    public int func_74762_e(String key) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return 0;
            }
            byte id = tag.func_74732_a();
            if (id >= 1 && id <= 6) {
                return ((NBTPrimitive)tag).func_150287_d();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    @Overwrite
    public long func_74763_f(String key) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return 0L;
            }
            byte id = tag.func_74732_a();
            if (id >= 1 && id <= 6) {
                return ((NBTPrimitive)tag).func_150291_c();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    @Overwrite
    public float func_74760_g(String key) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return 0.0f;
            }
            byte id = tag.func_74732_a();
            if (id >= 1 && id <= 6) {
                return ((NBTPrimitive)tag).func_150288_h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    @Overwrite
    public double func_74769_h(String key) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return 0.0;
            }
            byte id = tag.func_74732_a();
            if (id >= 1 && id <= 6) {
                return ((NBTPrimitive)tag).func_150286_g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    @Overwrite
    public String func_74779_i(String key) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return "";
            }
            if (tag.func_74732_a() == 8) {
                return ((NBTTagString)tag).func_150285_a_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    @Overwrite
    public byte[] func_74770_j(String key) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return new byte[0];
            }
            if (tag.func_74732_a() == 7) {
                this.stellar_core$onModified();
                return ((NBTTagByteArray)tag).func_150292_c();
            }
        }
        catch (ClassCastException ex) {
            throw new ReportedException(this.func_82581_a(key, 7, ex));
        }
        return new byte[0];
    }

    @Overwrite
    public int[] func_74759_k(String key) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return new int[0];
            }
            if (tag.func_74732_a() == 11) {
                this.stellar_core$onModified();
                return ((NBTTagIntArray)tag).func_150302_c();
            }
        }
        catch (ClassCastException ex) {
            throw new ReportedException(this.func_82581_a(key, 11, ex));
        }
        return new int[0];
    }

    @Overwrite
    public NBTTagCompound func_74775_l(String key) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return new NBTTagCompound();
            }
            if (tag.func_74732_a() == 10) {
                this.stellar_core$onModified();
                return (NBTTagCompound)tag;
            }
        }
        catch (ClassCastException ex) {
            throw new ReportedException(this.func_82581_a(key, 10, ex));
        }
        return new NBTTagCompound();
    }

    @Overwrite
    public NBTTagList func_150295_c(String key, int type) {
        try {
            NBTBase tag = this.func_74781_a(key);
            if (tag == null) {
                return new NBTTagList();
            }
            if (tag.func_74732_a() == 9) {
                NBTTagList list = (NBTTagList)tag;
                if (!list.func_82582_d() && list.func_150303_d() != type) {
                    return new NBTTagList();
                }
                this.stellar_core$onModified();
                return list;
            }
        }
        catch (ClassCastException ex) {
            throw new ReportedException(this.func_82581_a(key, 9, ex));
        }
        return new NBTTagList();
    }

    @Override
    @Unique
    public void stellar_core$onModified() {
        if (!this.stellar_core$unique) {
            this.stellar_core$unique = true;
            this.stellar_core$uid = stellar_core$UID.incrementAndGet();
        }
        if (this.stellar_core$hashCached) {
            this.stellar_core$hashCached = false;
        }
    }

    @Override
    @Unique
    public NBTTagBackingMap stellar_core$getTagMap() {
        return (NBTTagBackingMap)((Object)this.field_74784_a);
    }

    @Override
    @Unique
    public void stellar_core$setTagMap(NBTTagBackingMap tagMap) {
        tagMap.setChangeHandler(this);
        this.field_74784_a = tagMap;
    }

    @Override
    @Unique
    public void stellar_core$setUID(long uid) {
        this.stellar_core$uid = uid;
        this.stellar_core$unique = false;
    }

    @Override
    @Unique
    public long stellar_core$getUID() {
        return this.stellar_core$uid;
    }

    @Override
    @Unique
    public void stellar_core$setUnique(boolean unique) {
        this.stellar_core$unique = unique;
    }

    @Override
    @Unique
    public Boolean stellar_core$isUnique() {
        return this.stellar_core$unique;
    }

    @Override
    public void stellar_core$setHashCodeCache(int hashCode) {
        this.stellar_core$hashCached = true;
        this.stellar_core$hash = hashCode;
    }
}

