/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.nbtmaplist;

import github.kasuminova.stellarcore.common.util.NBTTagBackingList;
import github.kasuminova.stellarcore.mixin.util.StellarNBTTagList;
import java.io.DataInput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NBTTagList.class})
public class MixinNBTTagList
implements StellarNBTTagList {
    @Unique
    private static final AtomicLong stellar_core$UID = new AtomicLong();
    @Unique
    private static final ThreadLocal<Boolean> stellar_core$CREATE_TAG_LIST = ThreadLocal.withInitial(() -> Boolean.TRUE);
    @Shadow
    private List<NBTBase> field_74747_a;
    @Shadow
    private byte field_74746_b;
    @Unique
    private long stellar_core$uid;
    @Unique
    private boolean stellar_core$unique = true;
    @Unique
    private boolean stellar_core$hashCached = false;
    @Unique
    private int stellar_core$hash = 0;

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayList()Ljava/util/ArrayList;", remap=false))
    private ArrayList<Object> injectInitNewArrayList() {
        return null;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void injectInit(CallbackInfo ci) {
        if (stellar_core$CREATE_TAG_LIST.get() == Boolean.TRUE) {
            this.stellar_core$setTagList(new NBTTagBackingList(4));
            this.stellar_core$uid = stellar_core$UID.incrementAndGet();
        }
    }

    @Inject(method={"read"}, at={@At(value="HEAD")})
    private void injectRead(DataInput input, int depth, NBTSizeTracker sizeTracker, CallbackInfo ci) {
        this.stellar_core$onModified();
    }

    @Redirect(method={"read"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Lists;newArrayListWithCapacity(I)Ljava/util/ArrayList;", remap=false))
    private ArrayList<NBTBase> redirectNewArrayList(int initialArraySize) {
        NBTTagBackingList list = new NBTTagBackingList(initialArraySize);
        list.setChangeHandler(this);
        return list;
    }

    @Redirect(method={"get", "getCompoundTagAt", "getIntArrayAt"}, at=@At(value="INVOKE", target="Ljava/util/List;get(I)Ljava/lang/Object;"))
    private Object injectGet(List<NBTBase> instance, int i) {
        NBTBase tag = instance.get(i);
        byte id = tag.func_74732_a();
        if (id == 7 || id >= 9 && id <= 12) {
            this.stellar_core$onModified();
        }
        return tag;
    }

    @Nonnull
    @Overwrite
    public NBTTagList func_74737_b() {
        stellar_core$CREATE_TAG_LIST.set(Boolean.FALSE);
        NBTTagList copied = new NBTTagList();
        stellar_core$CREATE_TAG_LIST.set(Boolean.TRUE);
        StellarNBTTagList accessor = (StellarNBTTagList)copied;
        accessor.stellar_core$setTagType(this.field_74746_b);
        accessor.stellar_core$setUID(this.stellar_core$uid);
        accessor.stellar_core$setUnique(false);
        NBTTagBackingList copiedTagList = new NBTTagBackingList(this.field_74747_a.size() + 1);
        ((NBTTagBackingList)this.field_74747_a).unwrappedIterator().forEachRemaining(tag -> copiedTagList.add(tag.func_74737_b()));
        accessor.stellar_core$setTagList(copiedTagList);
        if (this.stellar_core$hashCached) {
            accessor.stellar_core$setHashCodeCache(this.stellar_core$hash);
        }
        return copied;
    }

    @Inject(method={"equals"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectEquals(Object obj, CallbackInfoReturnable<Boolean> cir) {
        if (!(obj instanceof NBTTagList)) {
            cir.setReturnValue((Object)Boolean.FALSE);
            return;
        }
        NBTTagList tag = (NBTTagList)obj;
        StellarNBTTagList accessor = (StellarNBTTagList)tag;
        if (this.field_74746_b != accessor.stellar_core$getTagType()) {
            cir.setReturnValue((Object)Boolean.FALSE);
            return;
        }
        if (!accessor.stellar_core$isUnique().booleanValue() && this.stellar_core$uid == accessor.stellar_core$getUID()) {
            cir.setReturnValue((Object)Boolean.TRUE);
            return;
        }
        boolean equals = this.field_74747_a.equals(accessor.stellar_core$getTagList());
        if (equals && !this.stellar_core$unique && !accessor.stellar_core$isUnique().booleanValue()) {
            accessor.stellar_core$setUID(this.stellar_core$uid);
        }
        cir.setReturnValue((Object)this.field_74747_a.equals(accessor.stellar_core$getTagList()));
    }

    @Overwrite
    public int hashCode() {
        if (this.stellar_core$hashCached) {
            return this.stellar_core$hash;
        }
        this.stellar_core$hashCached = true;
        this.stellar_core$hash = super.hashCode() ^ this.field_74747_a.hashCode();
        return this.stellar_core$hash;
    }

    @Override
    public NBTTagBackingList stellar_core$getTagList() {
        return (NBTTagBackingList)this.field_74747_a;
    }

    @Override
    public void stellar_core$setTagList(NBTTagBackingList tagList) {
        tagList.setChangeHandler(this);
        this.field_74747_a = tagList;
    }

    @Override
    public byte stellar_core$getTagType() {
        return this.field_74746_b;
    }

    @Override
    public void stellar_core$setTagType(byte tagType) {
        this.field_74746_b = tagType;
    }

    @Override
    public void stellar_core$onModified() {
        if (!this.stellar_core$unique) {
            this.stellar_core$unique = true;
            this.stellar_core$uid = stellar_core$UID.incrementAndGet();
        }
        if (this.stellar_core$hashCached) {
            this.stellar_core$hashCached = false;
        }
    }

    @Override
    @Unique
    public void stellar_core$setUID(long uid) {
        this.stellar_core$uid = uid;
        this.stellar_core$unique = false;
    }

    @Override
    @Unique
    public long stellar_core$getUID() {
        return this.stellar_core$uid;
    }

    @Override
    @Unique
    public void stellar_core$setUnique(boolean unique) {
        this.stellar_core$unique = unique;
    }

    @Override
    @Unique
    public Boolean stellar_core$isUnique() {
        return this.stellar_core$unique;
    }

    @Override
    public void stellar_core$setHashCodeCache(int hashCode) {
        this.stellar_core$hashCached = true;
        this.stellar_core$hash = hashCode;
    }
}

