/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.tconstruct;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.HashedItemStack;
import github.kasuminova.stellarcore.common.util.HashedStackFluidPair;
import github.kasuminova.stellarcore.mixin.util.TinkerRegistryUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

@Mixin(value={TinkerRegistry.class})
public class MixinTinkerRegistry {
    @Unique
    private static final Map<HashedItemStack, Optional<MeltingRecipe>> MELTING_RECIPE_CACHE = new WeakHashMap<HashedItemStack, Optional<MeltingRecipe>>();
    @Unique
    private static final Map<HashedStackFluidPair, Optional<ICastingRecipe>> TABLE_CASTING_RECIPE_CACHE = new WeakHashMap<HashedStackFluidPair, Optional<ICastingRecipe>>();
    @Unique
    private static final Map<HashedStackFluidPair, Optional<ICastingRecipe>> BASIN_CASTING_RECIPE_CACHE = new WeakHashMap<HashedStackFluidPair, Optional<ICastingRecipe>>();
    @Shadow(remap=false)
    private static List<MeltingRecipe> meltingRegistry;
    @Shadow(remap=false)
    private static List<ICastingRecipe> tableCastRegistry;
    @Shadow(remap=false)
    private static List<ICastingRecipe> basinCastRegistry;

    @Inject(method={"getMelting"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectGetMelting(ItemStack stack, CallbackInfoReturnable<MeltingRecipe> cir) {
        if (!StellarCoreConfig.PERFORMANCE.tConstruct.meltingRecipeSearch) {
            return;
        }
        HashedItemStack hashed = HashedItemStack.ofTagUnsafe(stack);
        Optional<MeltingRecipe> result = MELTING_RECIPE_CACHE.get(hashed);
        if (result != null) {
            cir.setReturnValue((Object)result.orElse(null));
            return;
        }
        for (MeltingRecipe recipe : meltingRegistry) {
            if (!recipe.matches(stack)) continue;
            MELTING_RECIPE_CACHE.put(hashed.copy(), Optional.of(recipe));
            cir.setReturnValue((Object)recipe);
            return;
        }
        MELTING_RECIPE_CACHE.put(hashed.copy(), Optional.empty());
        cir.setReturnValue(null);
    }

    @Inject(method={"getTableCasting"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectGetTableCasting(ItemStack cast, Fluid fluid, CallbackInfoReturnable<ICastingRecipe> cir) {
        if (!StellarCoreConfig.PERFORMANCE.tConstruct.tableCastingSearch) {
            return;
        }
        HashedStackFluidPair hashed = new HashedStackFluidPair(HashedItemStack.ofTagUnsafe(cast), fluid);
        Optional<ICastingRecipe> result = TABLE_CASTING_RECIPE_CACHE.get(hashed);
        if (result != null) {
            cir.setReturnValue((Object)result.orElse(null));
            return;
        }
        for (ICastingRecipe recipe : tableCastRegistry) {
            if (!recipe.matches(cast, fluid)) continue;
            TABLE_CASTING_RECIPE_CACHE.put(hashed.copy(), Optional.of(recipe));
            cir.setReturnValue((Object)recipe);
            return;
        }
        TABLE_CASTING_RECIPE_CACHE.put(hashed.copy(), Optional.empty());
        cir.setReturnValue(null);
    }

    @Inject(method={"getBasinCasting"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void injectGetBasinCasting(ItemStack cast, Fluid fluid, CallbackInfoReturnable<ICastingRecipe> cir) {
        if (!StellarCoreConfig.PERFORMANCE.tConstruct.basinCastingSearch) {
            return;
        }
        HashedStackFluidPair hashed = new HashedStackFluidPair(HashedItemStack.ofTagUnsafe(cast), fluid);
        Optional<ICastingRecipe> result = BASIN_CASTING_RECIPE_CACHE.get(hashed);
        if (result != null) {
            cir.setReturnValue((Object)result.orElse(null));
            return;
        }
        for (ICastingRecipe recipe : basinCastRegistry) {
            if (!recipe.matches(cast, fluid)) continue;
            BASIN_CASTING_RECIPE_CACHE.put(hashed.copy(), Optional.of(recipe));
            cir.setReturnValue((Object)recipe);
            return;
        }
        BASIN_CASTING_RECIPE_CACHE.put(hashed.copy(), Optional.empty());
        cir.setReturnValue(null);
    }

    @Inject(method={"registerAlloy(Lslimeknights/tconstruct/library/smeltery/AlloyRecipe;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)}, remap=false)
    private static void injectRegistryAlloy(AlloyRecipe recipe, CallbackInfo ci) {
        TinkerRegistryUtils.stellar_core$alloyRecipeDirty = true;
    }
}

