/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.unpadded;

import github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.unpadded.MpscChunkedAtomicUnpaddedArrayQueue;
import github.kasuminova.stellarcore.shaded.org.jctools.util.Pow2;
import github.kasuminova.stellarcore.shaded.org.jctools.util.RangeUtil;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MpscGrowableAtomicUnpaddedArrayQueue<E>
extends MpscChunkedAtomicUnpaddedArrayQueue<E> {
    public MpscGrowableAtomicUnpaddedArrayQueue(int maxCapacity) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(maxCapacity / 8)), maxCapacity);
    }

    public MpscGrowableAtomicUnpaddedArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected int getNextBufferSize(AtomicReferenceArray<E> buffer) {
        long maxSize = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(AtomicQueueUtil.length(buffer), maxSize, "buffer.length");
        int newSize = 2 * (AtomicQueueUtil.length(buffer) - 1);
        return newSize + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : mask;
    }
}

