/*
 * Decompiled with CFR 0.152.
 */
package me.samboycoding.thermaltinkering;

import cofh.api.util.ThermalExpansionHelper;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.Cast;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

@Mod(modid="thermaltinkering", name="Thermal Tinkering", version="1.0", dependencies="required-after:mantle;required-after:tconstruct;required-after:thermalexpansion;required-after:thermalfoundation;required-after:cofhcore@[4.6.2,);", acceptedMinecraftVersions="[1.12.2]")
public class ThermalTinkering {
    static final String MODID = "thermaltinkering";
    static final String VERSION = "1.0";
    static final String NAME = "Thermal Tinkering";
    static final String DEPENDENCY_STRING = "required-after:mantle;required-after:tconstruct;required-after:thermalexpansion;required-after:thermalfoundation;required-after:cofhcore@[4.6.2,);";
    private Logger log;
    private List<String> exceptionFluidIDs;
    private File fluidDumpFile;
    private File moltenDumpFile;
    private Configuration cfg;
    private int partMeltingMultiplier;
    private int partCastingMultiplier;
    private int castCreationCost;
    private int ingotMeltingMultiplier;
    private int ingotCastingMultiplier;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent e) throws Exception {
        File configFile;
        this.log = e.getModLog();
        File configDirectory = new File(e.getModConfigurationDirectory(), "/ThermalTinkering/");
        if (!configDirectory.exists()) {
            configDirectory.mkdirs();
        }
        if (!(configFile = new File(configDirectory, "config.cfg")).exists()) {
            configFile.createNewFile();
        }
        this.fluidDumpFile = new File(configDirectory, "fluids.txt");
        if (this.fluidDumpFile.exists()) {
            this.fluidDumpFile.delete();
        }
        this.fluidDumpFile.createNewFile();
        this.moltenDumpFile = new File(configDirectory, "moltenFluids.txt");
        if (this.moltenDumpFile.exists()) {
            this.moltenDumpFile.delete();
        }
        this.moltenDumpFile.createNewFile();
        this.cfg = new Configuration(configFile);
        this.cfg.load();
        this.exceptionFluidIDs = new ArrayList<String>(Arrays.asList(this.cfg.getStringList("blacklist", "main", new String[]{"obsidian"}, "List of fluids to NOT add recipes for.")));
        this.castCreationCost = this.cfg.getInt("castCreationCost", "main", 8000, 1000, 50000, "The amount of energy, in RF, required to make a cast");
        this.partMeltingMultiplier = this.cfg.getInt("partMeltingMultiplier", "main", 50, 1, 500, "To calculate the amount of RF needed to melt a tool part, we take its smeltery melting temperature and multiply it by this value.");
        this.partCastingMultiplier = this.cfg.getInt("partCastingMultiplier", "main", 15, 1, 500, "To calculate the amount of RF needed to cast a tool part, we take its smeltery melting temperature and multiply it by this value.");
        this.ingotMeltingMultiplier = this.cfg.getInt("ingotMeltingMultiplier", "main", 8, 1, 500, "Energy required, in RF, to melt an ingot is equal to this multiplied by the ingot's melting temperature in the smeltery.");
        this.ingotCastingMultiplier = this.cfg.getInt("ingotCastingMultiplier", "main", 2, 1, 500, "Energy required, in RF, to cast an ingot is equal to this multiplied by the ingot's melting temperature in the smeltery.");
        this.cfg.save();
        this.log.info("Pre Init Complete");
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent event) {
        try {
            List blacklist = this.exceptionFluidIDs.stream().filter(id -> FluidRegistry.getFluid((String)id) != null).map(FluidRegistry::getFluid).collect(Collectors.toList());
            this.exceptionFluidIDs = blacklist.stream().map(Fluid::getName).collect(Collectors.toList());
            if (this.exceptionFluidIDs.size() > 0) {
                this.log.info("Blacklisted " + blacklist.size() + " fluids from config.");
            }
            this.cfg.get("main", "blacklist", new String[0]).set(this.exceptionFluidIDs.toArray(new String[0]));
            this.cfg.save();
            this.log.debug("All loaded liquids: " + FluidRegistry.getRegisteredFluids().entrySet());
            List<Fluid> allMoltenFluids = TinkerRegistry.getAllMaterials().stream().filter(mat -> mat.isCastable() && mat.getFluid() != null).map(Material::getFluid).collect(Collectors.toList());
            StringBuilder allLiquidsDump = new StringBuilder("#This is a simple dump of all loaded liquids, in raw form, with their block names (in brackets) and their localized names, in the format of:\n\n#FLUIDID \t\t\t\t\t\t\t\t\t\t  (FLUIDBLOCK)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   = FLUIDLOCALIZEDNAME\n\n");
            allLiquidsDump.append("#ANY AND ALL CHANGES TO THIS FILE WILL BE REPLACED WHEN THIS FILE IS REGENERATED NEXT TIME THE GAME IS RUN. THIS IS FOR INFORMATIONAL PURPOSES ONLY AND IS NOT A CONFIG FILE!\n\n");
            StringBuilder allMoltenDump = new StringBuilder("#This is a simple dump of all molten liquids, in raw form, with their block names (in brackets) and their localized names, in the format of:\n\n#FLUIDID \t\t\t\t\t\t\t\t\t\t  (FLUIDBLOCK)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   = FLUIDLOCALIZEDNAME\n\n");
            allMoltenDump.append("#ANY AND ALL CHANGES TO THIS FILE WILL BE REPLACED WHEN THIS FILE IS REGENERATED NEXT TIME THE GAME IS RUN. THIS IS FOR INFORMATIONAL PURPOSES ONLY AND IS NOT A CONFIG FILE!\n\n");
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                String id2 = fluid.getName();
                String blockName = fluid.getBlock() != null ? fluid.getBlock().getRegistryName().toString() : "[no block]";
                String spaces = StringUtils.repeat((char)' ', (int)(130 - blockName.length() - id2.length() - 2 - (50 - id2.length())));
                String spaces2 = StringUtils.repeat((char)' ', (int)(50 - id2.length()));
                allLiquidsDump.append(id2).append(spaces2).append("(").append(blockName).append(")").append(spaces).append(" = ").append(fluid.getLocalizedName(new FluidStack(fluid, 1))).append("\n");
            }
            allMoltenFluids.forEach(fl -> {
                String id = fl.getName();
                String blockName = fl.getBlock() != null ? fl.getBlock().getRegistryName().toString() : "[no block]";
                String spaces = StringUtils.repeat((char)' ', (int)(130 - blockName.length() - id.length() - 2 - (50 - id.length())));
                String spaces2 = StringUtils.repeat((char)' ', (int)(50 - id.length()));
                allMoltenDump.append(id).append(spaces2).append("(").append(blockName).append(")").append(spaces).append(" = ").append(fl.getLocalizedName(new FluidStack(fl, 1))).append("\n");
            });
            PrintWriter writer = new PrintWriter(this.fluidDumpFile);
            writer.print(allLiquidsDump);
            writer.close();
            this.log.info("Successfully written loaded fluid dump to " + this.fluidDumpFile.getAbsolutePath());
            writer = new PrintWriter(this.moltenDumpFile);
            writer.print(allMoltenDump);
            writer.close();
            this.log.info("Successfully written molten fluid dump to " + this.moltenDumpFile.getAbsolutePath());
            ItemStack ingotCast = TinkerSmeltery.castIngot;
            for (Material mat2 : TinkerRegistry.getAllMaterials()) {
                Fluid fluid;
                if (!mat2.isCastable() || mat2.getFluid() == null || blacklist.contains(fluid = mat2.getFluid())) continue;
                String fluidId = fluid.getName();
                String oreDictName = StringUtils.capitalize((String)fluidId.replace(".molten", ""));
                NonNullList ingots = OreDictionary.getOres((String)("ingot" + oreDictName));
                if (ingots.isEmpty()) {
                    this.log.error("Fluid " + fluidId + " should have at least one ingot \"ingot" + oreDictName + "\" but doesn't.");
                }
                for (ItemStack ingotStack : ingots) {
                    if (ingotStack.func_82833_r().isEmpty()) {
                        this.log.error(ingotStack + " does not have a display name?");
                        continue;
                    }
                    if (fluid.getName() == null || fluid.getName().isEmpty()) {
                        this.log.error("Fluid \"" + fluid + "\" doesn't have a name?");
                        continue;
                    }
                    this.log.debug("Mapping " + ingotStack.func_82833_r() + " <=> " + fluid.getLocalizedName(new FluidStack(fluid, 1)));
                    ThermalExpansionHelper.addTransposerFill((int)this.castCreationCost, (ItemStack)ingotStack, (ItemStack)ingotCast, (FluidStack)new FluidStack((Fluid)TinkerFluids.alubrass, 144), (boolean)false);
                    ThermalExpansionHelper.addTransposerFill((int)this.castCreationCost, (ItemStack)ingotStack, (ItemStack)ingotCast, (FluidStack)new FluidStack((Fluid)TinkerFluids.gold, 288), (boolean)false);
                    int smelteryMeltingTemp = ThermalTinkering.calcTemperature(fluid.getTemperature(), 144);
                    ThermalExpansionHelper.addCrucibleRecipe((int)(smelteryMeltingTemp * this.ingotMeltingMultiplier), (ItemStack)new ItemStack(ingotStack.func_77973_b(), 1, ingotStack.func_77952_i()), (FluidStack)new FluidStack(fluid, 144));
                    ThermalExpansionHelper.addTransposerFill((int)(smelteryMeltingTemp * this.ingotCastingMultiplier), (ItemStack)ingotCast, (ItemStack)ingotStack, (FluidStack)new FluidStack(fluid, 144), (boolean)false);
                }
            }
            FluidStack oneIngotOfMoltenAluBrass = new FluidStack((Fluid)TinkerFluids.alubrass, 144);
            FluidStack twoIngotsOfMoltenGold = new FluidStack((Fluid)TinkerFluids.gold, 288);
            for (IToolPart iTp : TinkerRegistry.getToolParts()) {
                if (!iTp.canBeCasted() || !(iTp instanceof ToolPart)) continue;
                ToolPart toolPart = (ToolPart)iTp;
                this.log.info("Adding recipes for part " + toolPart.func_77653_i(new ItemStack((Item)toolPart, 1)) + " (cost " + toolPart.getCost() + "mB)");
                for (Material mat3 : TinkerRegistry.getAllMaterials()) {
                    if (!mat3.isCastable() || !toolPart.canUseMaterial(mat3)) continue;
                    Fluid fluid = mat3.getFluid();
                    if (blacklist.contains(fluid)) {
                        this.log.info("\t-Skipping material " + mat3.getIdentifier() + " as its fluid, " + fluid.getName() + ", is blacklisted.");
                        continue;
                    }
                    ItemStack part = toolPart.getItemstackWithMaterial(mat3);
                    ItemStack cast = new ItemStack((Item)TinkerSmeltery.cast);
                    Cast.setTagForPart((ItemStack)cast, (Item)part.func_77973_b());
                    ThermalExpansionHelper.addTransposerFill((int)this.castCreationCost, (ItemStack)part, (ItemStack)cast, (FluidStack)oneIngotOfMoltenAluBrass, (boolean)false);
                    ThermalExpansionHelper.addTransposerFill((int)this.castCreationCost, (ItemStack)part, (ItemStack)cast, (FluidStack)twoIngotsOfMoltenGold, (boolean)false);
                    int smelteryMeltingTemp = ThermalTinkering.calcTemperature(fluid.getTemperature(), toolPart.getCost());
                    ThermalExpansionHelper.addTransposerFill((int)(smelteryMeltingTemp * this.partCastingMultiplier), (ItemStack)cast, (ItemStack)part, (FluidStack)new FluidStack(fluid, toolPart.getCost()), (boolean)false);
                    ThermalExpansionHelper.addCrucibleRecipe((int)(smelteryMeltingTemp * this.partMeltingMultiplier), (ItemStack)part, (FluidStack)new FluidStack(fluid, toolPart.getCost()));
                }
            }
            this.log.info("Successfully added recipes for " + TinkerRegistry.getToolParts().size() + " parts.");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static int calcTemperature(int temp, int timeAmount) {
        int base = 1296;
        int max_tmp = Math.max(0, temp - 300);
        double f = (double)timeAmount / (double)base;
        f = Math.pow(f, 0.31546487678);
        return 300 + (int)(f * (double)max_tmp);
    }
}

