/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.Util;

@Mod.EventBusSubscriber(modid="tconstruct")
public abstract class Sounds {
    private static final List<SoundEvent> sounds = new ArrayList<SoundEvent>();
    public static final SoundEvent saw = Sounds.sound("little_saw");
    public static final SoundEvent frypan_boing = Sounds.sound("frypan_hit");
    public static final SoundEvent toy_squeak = Sounds.sound("toy_squeak");
    public static final SoundEvent slimesling = Sounds.sound("slimesling");
    public static final SoundEvent shocking_charged = Sounds.sound("charged");
    public static final SoundEvent shocking_discharge = Sounds.sound("discharge");
    public static final SoundEvent stone_hit = Sounds.sound("stone_hit");
    public static final SoundEvent wood_hit = Sounds.sound("wood_hit");
    public static final SoundEvent crossbow_reload = Sounds.sound("crossbow_reload");
    public static final SoundEvent faucet_pour_loop = Sounds.sound("faucet_pour_loop");
    public static final SoundEvent faucet_trigger = Sounds.sound("faucet_trigger");
    public static final SoundEvent smeltery_loop = Sounds.sound("smeltery_loop");
    public static final SoundEvent sizzle = Sounds.sound("sizzle");

    private Sounds() {
    }

    private static SoundEvent sound(String name) {
        ResourceLocation location = Util.getResource(name);
        SoundEvent event = new SoundEvent(location);
        event.setRegistryName(location);
        sounds.add(event);
        return event;
    }

    public static void playSoundForAll(Entity entity, SoundEvent sound, float volume, float pitch) {
        entity.func_130014_f_().func_184133_a(null, entity.func_180425_c(), sound, entity.func_184176_by(), volume, pitch);
    }

    public static void PlaySoundForPlayer(Entity entity, SoundEvent sound, float volume, float pitch) {
        if (entity instanceof EntityPlayerMP) {
            TinkerNetwork.sendPacket(entity, new SPacketSoundEffect(sound, entity.func_184176_by(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, volume, pitch));
        }
    }

    @SubscribeEvent
    public static void registerSoundEvent(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        sounds.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }
}

