/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;

public class BowMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_Drawspeed = "stat.bow.drawspeed.name";
    public static final String LOC_Range = "stat.bow.range.name";
    public static final String LOC_Damage = "stat.bow.damage.name";
    public static final String LOC_DrawspeedDesc = "stat.bow.drawspeed.desc";
    public static final String LOC_RangeDesc = "stat.bow.range.desc";
    public static final String LOC_DamageDesc = "stat.bow.damage.desc";
    public static final String COLOR_Drawspeed = CustomFontColor.encodeColor(128, 128, 128);
    public static final String COLOR_Range = CustomFontColor.encodeColor(140, 175, 175);
    public static final String COLOR_Damage = CustomFontColor.encodeColor(155, 80, 65);
    public final float drawspeed;
    public final float range;
    public final float bonusDamage;

    public BowMaterialStats(float drawspeed, float range, float bonusDamage) {
        super("bow");
        this.drawspeed = drawspeed;
        this.range = range;
        this.bonusDamage = bonusDamage;
    }

    public static String formatDrawspeed(float drawspeed) {
        return BowMaterialStats.formatNumber(LOC_Drawspeed, COLOR_Drawspeed, drawspeed);
    }

    public static String formatRange(float range) {
        return BowMaterialStats.formatNumber(LOC_Range, COLOR_Range, range);
    }

    public static String formatDamage(float damage) {
        return BowMaterialStats.formatNumber(LOC_Damage, COLOR_Damage, damage);
    }

    @Override
    public List<String> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        if (1.0f / this.drawspeed != 0.0f) {
            info.add(BowMaterialStats.formatDrawspeed(1.0f / this.drawspeed));
        }
        if (this.range != 0.0f) {
            info.add(BowMaterialStats.formatRange(this.range));
        }
        if (this.bonusDamage != 0.0f) {
            info.add(BowMaterialStats.formatDamage(this.bonusDamage));
        }
        return info;
    }

    @Override
    public List<String> getLocalizedDesc() {
        ArrayList info = Lists.newArrayList();
        if (1.0f / this.drawspeed != 0.0f) {
            info.add(Util.translate(LOC_DrawspeedDesc, new Object[0]));
        }
        if (this.range != 0.0f) {
            info.add(Util.translate(LOC_RangeDesc, new Object[0]));
        }
        if (this.bonusDamage != 0.0f) {
            info.add(Util.translate(LOC_DamageDesc, new Object[0]));
        }
        return info;
    }
}

