/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IModifierDisplay;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public abstract class ModifierAspect {
    public static final ModifierAspect freeModifier = new FreeModifierAspect(1);
    public static final ModifierAspect toolOnly = new CategoryAspect(Category.TOOL);
    public static final ModifierAspect harvestOnly = new CategoryAspect(Category.HARVEST);
    public static final ModifierAspect weaponOnly = new CategoryAspect(Category.WEAPON);
    public static final ModifierAspect aoeOnly = new CategoryAspect(Category.AOE);
    public static final ModifierAspect projectileOnly = new CategoryAspect(Category.PROJECTILE);
    protected final IModifier parent;

    protected ModifierAspect() {
        this.parent = null;
    }

    public ModifierAspect(IModifier parent) {
        this.parent = parent;
    }

    public abstract boolean canApply(ItemStack var1, ItemStack var2) throws TinkerGuiException;

    public abstract void updateNBT(NBTTagCompound var1, NBTTagCompound var2);

    public static class LevelAspect
    extends ModifierAspect {
        private final int maxLevel;

        public LevelAspect(IModifier parent, int maxLevel) {
            super(parent);
            this.maxLevel = maxLevel;
        }

        @Override
        public boolean canApply(ItemStack stack, ItemStack original) throws TinkerGuiException {
            int levelNew = ModifierNBT.readTag((NBTTagCompound)TinkerUtil.getModifierTag((ItemStack)stack, (String)this.parent.getIdentifier())).level;
            int levelOld = ModifierNBT.readTag((NBTTagCompound)TinkerUtil.getModifierTag((ItemStack)original, (String)this.parent.getIdentifier())).level;
            if (levelNew - levelOld > 0) {
                return false;
            }
            if (levelNew >= this.maxLevel) {
                throw new TinkerGuiException(I18n.func_74837_a((String)"gui.error.max_level_modifier", (Object[])new Object[]{this.parent.getLocalizedName()}));
            }
            return true;
        }

        @Override
        public void updateNBT(NBTTagCompound root, NBTTagCompound modifierTag) {
            ModifierNBT data = ModifierNBT.readTag(modifierTag);
            data.level = Math.min(data.level + 1, this.maxLevel);
            data.write(modifierTag);
        }
    }

    public static class SingleAspect
    extends ModifierAspect {
        public SingleAspect(IModifier parent) {
            super(parent);
        }

        @Override
        public boolean canApply(ItemStack stack, ItemStack original) throws TinkerGuiException {
            if (TinkerUtil.hasModifier(TagUtil.getTagSafe(stack), this.parent.getIdentifier())) {
                if (TinkerUtil.hasModifier(TagUtil.getTagSafe(original), this.parent.getIdentifier())) {
                    throw new TinkerGuiException(I18n.func_74837_a((String)"gui.error.single_modifier", (Object[])new Object[]{this.parent.getLocalizedName()}));
                }
                return false;
            }
            return true;
        }

        @Override
        public void updateNBT(NBTTagCompound root, NBTTagCompound modifierTag) {
        }
    }

    public static class CategoryAnyAspect
    extends CategoryAspect {
        public CategoryAnyAspect(Category ... category) {
            super(category);
        }

        @Override
        public boolean canApply(ItemStack stack, ItemStack original) {
            for (Category cat : this.category) {
                if (!ToolHelper.hasCategory(stack, cat)) continue;
                return true;
            }
            return false;
        }
    }

    public static class CategoryAspect
    extends ModifierAspect {
        protected final Category[] category;

        public CategoryAspect(Category ... category) {
            this.category = category;
        }

        @Override
        public boolean canApply(ItemStack stack, ItemStack original) {
            for (Category cat : this.category) {
                if (ToolHelper.hasCategory(stack, cat)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void updateNBT(NBTTagCompound root, NBTTagCompound modifierTag) {
        }
    }

    public static class MultiAspect
    extends ModifierAspect {
        protected final int countPerLevel;
        protected DataAspect dataAspect;
        protected LevelAspect levelAspect;
        protected FreeModifierAspect freeModifierAspect;

        public <T extends IModifier & IModifierDisplay> MultiAspect(T parent, int maxLevel, int countPerLevel, int modifiersNeeded) {
            this(parent, ((IModifierDisplay)parent).getColor(), maxLevel, countPerLevel, modifiersNeeded);
        }

        public MultiAspect(IModifier parent, int color, int maxLevel, int countPerLevel, int modifiersNeeded) {
            super(parent);
            this.countPerLevel = countPerLevel;
            this.dataAspect = new DataAspect(parent, color);
            this.freeModifierAspect = new FreeModifierAspect(modifiersNeeded);
            this.levelAspect = new LevelAspect(parent, maxLevel);
        }

        public MultiAspect(IModifier parent, int color, int count) {
            this(parent, color, 1, count, 1);
        }

        protected int getMaxForLevel(int level) {
            return this.countPerLevel * level;
        }

        @Override
        public boolean canApply(ItemStack stack, ItemStack original) throws TinkerGuiException {
            NBTTagCompound modifierTag = TinkerUtil.getModifierTag(stack, this.parent.getIdentifier());
            ModifierNBT.IntegerNBT data = this.getData(modifierTag);
            if (data.current >= this.getMaxForLevel(data.level)) {
                if (!this.levelAspect.canApply(stack, original)) {
                    return false;
                }
                if (!this.freeModifierAspect.canApply(stack, original)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void updateNBT(NBTTagCompound root, NBTTagCompound modifierTag) {
            this.dataAspect.updateNBT(root, modifierTag);
            ModifierNBT.IntegerNBT data = this.getData(modifierTag);
            if (data.current >= this.getMaxForLevel(data.level)) {
                this.freeModifierAspect.updateNBT(root, modifierTag);
                this.levelAspect.updateNBT(root, modifierTag);
                data = this.getData(modifierTag);
            }
            data.max = this.getMaxForLevel(data.level);
            ++data.current;
            data.write(modifierTag);
        }

        private ModifierNBT.IntegerNBT getData(NBTTagCompound tag) {
            ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(tag);
            if (data.max == 0) {
                data.max = this.getMaxForLevel(data.level);
            }
            return data;
        }
    }

    public static class DataAspect
    extends ModifierAspect {
        private final int color;

        public DataAspect(IModifier parent, TextFormatting color) {
            this(parent, Util.enumChatFormattingToColor(color));
        }

        public DataAspect(IModifier parent, int color) {
            super(parent);
            this.color = color;
        }

        public <T extends IModifier & IModifierDisplay> DataAspect(T parent) {
            super(parent);
            this.color = ((IModifierDisplay)parent).getColor();
        }

        @Override
        public boolean canApply(ItemStack stack, ItemStack original) {
            return true;
        }

        @Override
        public void updateNBT(NBTTagCompound root, NBTTagCompound modifierTag) {
            ModifierNBT data = ModifierNBT.readTag(modifierTag);
            data.identifier = this.parent.getIdentifier();
            data.color = this.color;
            data.write(modifierTag);
        }
    }

    public static class FreeFirstModifierAspect
    extends FreeModifierAspect {
        public FreeFirstModifierAspect(IModifier parent, int requiredModifiers) {
            super(parent, requiredModifiers);
        }

        @Override
        public boolean canApply(ItemStack stack, ItemStack original) throws TinkerGuiException {
            if (TinkerUtil.hasModifier(TagUtil.getTagSafe(stack), this.parent.getIdentifier())) {
                return true;
            }
            return super.canApply(stack, original);
        }

        @Override
        public void updateNBT(NBTTagCompound root, NBTTagCompound modifierTag) {
            if (modifierTag.func_74764_b("modifierUsed")) {
                return;
            }
            super.updateNBT(root, modifierTag);
            modifierTag.func_74757_a("modifierUsed", true);
        }
    }

    public static class FreeModifierAspect
    extends ModifierAspect {
        private final int requiredModifiers;

        public FreeModifierAspect(int requiredModifiers) {
            this.requiredModifiers = requiredModifiers;
        }

        protected FreeModifierAspect(IModifier parent, int requiredModifiers) {
            super(parent);
            this.requiredModifiers = requiredModifiers;
        }

        @Override
        public boolean canApply(ItemStack stack, ItemStack original) throws TinkerGuiException {
            NBTTagCompound toolTag = TagUtil.getToolTag(stack);
            if (ToolHelper.getFreeModifiers(stack) < this.requiredModifiers) {
                String error = I18n.func_74837_a((String)"gui.error.not_enough_modifiers", (Object[])new Object[]{this.requiredModifiers});
                throw new TinkerGuiException(error);
            }
            return true;
        }

        @Override
        public void updateNBT(NBTTagCompound root, NBTTagCompound modifierTag) {
            NBTTagCompound toolTag = TagUtil.getToolTag(root);
            int modifiers = toolTag.func_74762_e("FreeModifiers") - this.requiredModifiers;
            toolTag.func_74768_a("FreeModifiers", Math.max(0, modifiers));
            int usedModifiers = TagUtil.getBaseModifiersUsed(root);
            TagUtil.setBaseModifiersUsed(root, usedModifiers += this.requiredModifiers);
        }
    }
}

