/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.smeltery;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerAPIException;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.utils.ListUtil;

public class CastingRecipe
implements ICastingRecipe {
    public final RecipeMatch cast;
    protected final FluidStack fluid;
    protected final ItemStack output;
    protected final int time;
    protected final boolean consumesCast;
    protected final boolean switchOutputs;

    public CastingRecipe(ItemStack output, RecipeMatch cast, Fluid fluid, int amount) {
        this(output, cast, fluid, amount, CastingRecipe.calcCooldownTime(fluid, amount));
    }

    public CastingRecipe(ItemStack output, RecipeMatch cast, Fluid fluid, int amount, int time) {
        this(output, cast, new FluidStack(fluid, amount), time, false, false);
    }

    public CastingRecipe(ItemStack output, Fluid fluid, int amount, int time) {
        this(output, null, new FluidStack(fluid, amount), time, false, false);
    }

    public CastingRecipe(ItemStack output, RecipeMatch cast, Fluid fluid, int amount, boolean consumesCast, boolean switchOutputs) {
        this(output, cast, new FluidStack(fluid, amount), CastingRecipe.calcCooldownTime(fluid, amount), consumesCast, switchOutputs);
    }

    public CastingRecipe(ItemStack output, RecipeMatch cast, FluidStack fluid, boolean consumesCast, boolean switchOutputs) {
        this(output, cast, fluid, CastingRecipe.calcCooldownTime(fluid.getFluid(), fluid.amount), consumesCast, switchOutputs);
    }

    public CastingRecipe(ItemStack output, RecipeMatch cast, FluidStack fluid, int time, boolean consumesCast, boolean switchOutputs) {
        if (output == null || output.func_190926_b()) {
            throw new TinkerAPIException("Casting Recipe is missing an output!");
        }
        if (fluid == null) {
            throw new TinkerAPIException(String.format("Casting Recipe for %s has no fluid!", output.func_82833_r()));
        }
        this.output = output;
        this.cast = cast;
        this.fluid = fluid;
        this.time = time;
        this.consumesCast = consumesCast;
        this.switchOutputs = switchOutputs;
    }

    @Override
    public boolean matches(ItemStack cast, Fluid fluid) {
        if (cast.func_190926_b() && this.cast == null || this.cast != null && this.cast.matches(ListUtil.getListFrom(cast)).isPresent()) {
            return this.fluid.getFluid() == fluid;
        }
        return false;
    }

    @Override
    public ItemStack getResult(ItemStack cast, Fluid fluid) {
        return this.getResult().func_77946_l();
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public boolean consumesCast() {
        return this.consumesCast;
    }

    @Override
    public int getFluidAmount() {
        return this.fluid.amount;
    }

    @Override
    public boolean switchOutputs() {
        return this.switchOutputs;
    }

    @Override
    public FluidStack getFluid(ItemStack cast, Fluid fluid) {
        return this.fluid;
    }

    public ItemStack getResult() {
        return this.output;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public static int calcCooldownTime(Fluid fluid, int amount) {
        int time = 24;
        int temperature = fluid.getTemperature() - 300;
        return time + temperature * amount / 1600;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CastingRecipe that = (CastingRecipe)o;
        if (this.time != that.time) {
            return false;
        }
        if (this.consumesCast != that.consumesCast) {
            return false;
        }
        if (this.switchOutputs != that.switchOutputs) {
            return false;
        }
        if (this.cast != null ? !this.cast.equals(that.cast) : that.cast != null) {
            return false;
        }
        if (this.fluid != null ? !this.fluid.isFluidStackIdentical(that.fluid) : that.fluid != null) {
            return false;
        }
        return this.output != null ? this.output.func_77969_a(that.output) && ItemStack.func_77970_a((ItemStack)this.output, (ItemStack)that.output) : that.output == null;
    }

    public int hashCode() {
        int result = this.cast != null ? this.cast.hashCode() : 0;
        int fluidHash = 0;
        if (this.fluid != null) {
            fluidHash = this.fluid.getFluid().hashCode() + this.fluid.amount;
            if (this.fluid.tag != null) {
                fluidHash = 31 * fluidHash + this.fluid.tag.hashCode();
            }
        }
        result = 31 * result + fluidHash;
        result = 31 * result + (this.output != null ? this.output.func_77973_b().hashCode() + this.output.func_77960_j() + (this.output.func_77978_p() != null ? this.output.func_77978_p().hashCode() : 0) : 0);
        result = 31 * result + this.time;
        result = 31 * result + (this.consumesCast ? 1 : 0);
        result = 31 * result + (this.switchOutputs ? 1 : 0);
        return result;
    }
}

