/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.smeltery;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.utils.ListUtil;

public class MeltingRecipe {
    private static final double LOG9_2 = 0.31546487678;
    public final RecipeMatch input;
    public final FluidStack output;
    public final int temperature;

    public MeltingRecipe(RecipeMatch input, Fluid output) {
        this(input, new FluidStack(output, input.amountMatched));
    }

    public MeltingRecipe(RecipeMatch input, FluidStack output) {
        this(input, output, MeltingRecipe.calcTemperature(output.getFluid().getTemperature(output), input.amountMatched));
    }

    public MeltingRecipe(RecipeMatch input, Fluid output, int temperature) {
        this(input, new FluidStack(output, input.amountMatched), temperature);
    }

    public MeltingRecipe(RecipeMatch input, FluidStack output, int temperature) {
        this.input = input;
        this.output = new FluidStack(output, input.amountMatched);
        this.temperature = temperature;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getUsableTemperature() {
        return Math.max(1, this.temperature - 300);
    }

    public boolean matches(ItemStack stack) {
        return this.input.matches(ListUtil.getListFrom(stack)).isPresent();
    }

    public FluidStack getResult() {
        return this.output.copy();
    }

    public MeltingRecipe register() {
        TinkerRegistry.registerMelting(this);
        return this;
    }

    private static int calcTemperature(int temp, int timeAmount) {
        int base = 1296;
        int max_tmp = Math.max(0, temp - 300);
        double f = (double)timeAmount / (double)base;
        f = Math.pow(f, 0.31546487678);
        return 300 + (int)(f * (double)max_tmp);
    }

    public static MeltingRecipe registerFor(RecipeMatch recipeMatch, Fluid fluid) {
        return new MeltingRecipe(recipeMatch, fluid).register();
    }

    public static MeltingRecipe forAmount(RecipeMatch recipeMatch, FluidStack output, int timeAmount) {
        return new MeltingRecipe(recipeMatch, output, MeltingRecipe.calcTemperature(output.getFluid().getTemperature(), timeAmount));
    }

    public static MeltingRecipe forAmount(RecipeMatch recipeMatch, Fluid fluid, int timeAmount) {
        return MeltingRecipe.forAmount(recipeMatch, new FluidStack(fluid, recipeMatch.amountMatched), timeAmount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeltingRecipe that = (MeltingRecipe)o;
        if (this.temperature != that.temperature) {
            return false;
        }
        if (this.input != null ? !this.input.equals(that.input) : that.input != null) {
            return false;
        }
        return this.output != null ? this.output.isFluidStackIdentical(that.output) : that.output == null;
    }

    public int hashCode() {
        int result = this.input != null ? this.input.hashCode() : 0;
        int outputHash = 0;
        if (this.output != null) {
            outputHash = this.output.getFluid().hashCode() + this.output.amount;
            if (this.output.tag != null) {
                outputHash = 31 * outputHash + this.output.tag.hashCode();
            }
        }
        result = 31 * result + outputHash;
        result = 31 * result + this.temperature;
        return result;
    }
}

