/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import com.google.common.collect.ImmutableList;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IAoeTool;
import slimeknights.tconstruct.library.tools.TinkerToolCore;
import slimeknights.tconstruct.library.utils.ToolHelper;

public abstract class AoeToolCore
extends TinkerToolCore
implements IAoeTool {
    public AoeToolCore(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.AOE);
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 1, 1, 1);
    }

    @Override
    public boolean isAoeHarvestTool() {
        return true;
    }

    public EnumActionResult doMakePath(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block;
        ItemStack stack = player.func_184586_b(hand);
        if (ToolHelper.isBroken(stack)) {
            return EnumActionResult.FAIL;
        }
        EnumActionResult result = Items.field_151047_v.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        if (result == EnumActionResult.SUCCESS) {
            TinkerToolEvent.OnShovelMakePath.fireEvent(stack, player, world, pos);
        }
        if ((block = world.func_180495_p(pos).func_177230_c()) == Blocks.field_150349_c || block == Blocks.field_185774_da) {
            for (BlockPos aoePos : this.getAOEBlocks(stack, world, player, pos)) {
                if (ToolHelper.isBroken(stack)) break;
                EnumActionResult aoeResult = Items.field_151047_v.func_180614_a(player, world, aoePos, hand, facing, hitX, hitY, hitZ);
                if (result != EnumActionResult.SUCCESS) {
                    result = aoeResult;
                }
                if (aoeResult != EnumActionResult.SUCCESS) continue;
                TinkerToolEvent.OnShovelMakePath.fireEvent(stack, player, world, aoePos);
            }
        }
        return result;
    }

    public EnumActionResult doTill(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (ToolHelper.isBroken(stack)) {
            return EnumActionResult.FAIL;
        }
        EnumActionResult ret = this.useHoe(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
        for (BlockPos blockPos : this.getAOEBlocks(stack, world, player, pos)) {
            if (ToolHelper.isBroken(stack)) break;
            EnumActionResult ret2 = this.useHoe(stack, player, world, blockPos, hand, facing, hitX, hitY, hitZ);
            if (ret == EnumActionResult.SUCCESS) continue;
            ret = ret2;
        }
        if (ret == EnumActionResult.SUCCESS) {
            TinkerToolEvent.OnMattockHoe.fireEvent(stack, player, world, pos);
        }
        return ret;
    }

    private EnumActionResult useHoe(ItemStack stack, EntityPlayer player, World world, BlockPos blockPos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int damage = stack.func_77952_i();
        EnumActionResult ret = Items.field_151012_L.func_180614_a(player, world, blockPos, hand, facing, hitX, hitY, hitZ);
        stack.func_77964_b(damage);
        if (!world.field_72995_K && ret == EnumActionResult.SUCCESS) {
            ToolHelper.damageTool(stack, 1, (EntityLivingBase)player);
        }
        return ret;
    }
}

