/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ranged.IProjectile;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.common.network.ToolBreakAnimationPacket;

public final class ToolHelper {
    private ToolHelper() {
    }

    public static boolean hasCategory(ItemStack stack, Category category) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof TinkersItem)) {
            return false;
        }
        return ((TinkersItem)stack.func_77973_b()).hasCategory(category);
    }

    public static int getDurabilityStat(ItemStack stack) {
        return ToolHelper.getIntTag(stack, "Durability");
    }

    public static int getHarvestLevelStat(ItemStack stack) {
        return ToolHelper.getIntTag(stack, "HarvestLevel");
    }

    public static float getMiningSpeedStat(ItemStack stack) {
        return ToolHelper.getfloatTag(stack, "MiningSpeed");
    }

    public static float getAttackStat(ItemStack stack) {
        return ToolHelper.getfloatTag(stack, "Attack");
    }

    public static float getActualAttack(ItemStack stack) {
        float damage = ToolHelper.getAttackStat(stack);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ToolCore) {
            damage *= ((ToolCore)stack.func_77973_b()).damagePotential();
        }
        return damage;
    }

    public static float getAttackSpeedStat(ItemStack stack) {
        return ToolHelper.getfloatTag(stack, "AttackSpeedMultiplier");
    }

    public static float getActualAttackSpeed(ItemStack stack) {
        float speed = ToolHelper.getAttackSpeedStat(stack);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ToolCore) {
            speed = (float)((double)speed * ((ToolCore)stack.func_77973_b()).attackSpeed());
        }
        return speed;
    }

    public static float getActualMiningSpeed(ItemStack stack) {
        float speed = ToolHelper.getMiningSpeedStat(stack);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ToolCore) {
            speed *= ((ToolCore)stack.func_77973_b()).miningSpeedModifier();
        }
        return speed;
    }

    public static int getFreeModifiers(ItemStack stack) {
        return ToolHelper.getIntTag(stack, "FreeModifiers");
    }

    public static int getFortuneLevel(ItemStack stack) {
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        int luck = TinkerModifiers.modLuck.getLuckLevel(stack);
        return Math.max(fortune, luck);
    }

    public static List<ITrait> getTraits(ItemStack stack) {
        LinkedList traits = Lists.newLinkedList();
        NBTTagList traitsTagList = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < traitsTagList.func_74745_c(); ++i) {
            ITrait trait = TinkerRegistry.getTrait(traitsTagList.func_150307_f(i));
            if (trait == null) continue;
            traits.add(trait);
        }
        return traits;
    }

    public static float calcDigSpeed(ItemStack stack, IBlockState blockState) {
        if (blockState == null) {
            return 0.0f;
        }
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        if (ToolHelper.isBroken(stack)) {
            return 0.3f;
        }
        if (!ToolHelper.canHarvest(stack, blockState)) {
            return 1.0f;
        }
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        float speed = tag.func_74760_g("MiningSpeed");
        if (stack.func_77973_b() instanceof ToolCore) {
            speed *= ((ToolCore)stack.func_77973_b()).miningSpeedModifier();
        }
        return speed;
    }

    public static boolean isToolEffective(ItemStack stack, IBlockState state) {
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolEffective2(ItemStack stack, IBlockState state) {
        if (ToolHelper.isToolEffective(stack, state)) {
            return true;
        }
        if (TinkerUtil.hasModifier(TagUtil.getTagSafe(stack), TinkerModifiers.modBlasting.getIdentifier()) && state.func_185904_a().func_76229_l()) {
            return !state.func_185904_a().func_76224_d();
        }
        return stack.func_77973_b() instanceof ToolCore && ((ToolCore)stack.func_77973_b()).isEffective(state);
    }

    public static boolean canHarvest(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        String type = block.getHarvestTool(state);
        int level = block.getHarvestLevel(state);
        return stack.func_77973_b().getHarvestLevel(stack, type, null, state) >= level;
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth) {
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, width, height, depth, -1);
    }

    public static ImmutableList<BlockPos> calcAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin, int width, int height, int depth, int distance) {
        int z;
        int y;
        int x;
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ToolCore)) {
            return ImmutableList.of();
        }
        IBlockState state = world.func_180495_p(origin);
        if (!ToolHelper.isToolEffective2(stack, state)) {
            return ImmutableList.of();
        }
        if (state.func_185904_a() == Material.field_151579_a) {
            return ImmutableList.of();
        }
        RayTraceResult mop = ((ToolCore)stack.func_77973_b()).func_77621_a(world, player, true);
        if (!(mop != null && origin.equals((Object)mop.func_178782_a()) || (mop = ((ToolCore)stack.func_77973_b()).func_77621_a(world, player, false)) != null && origin.equals((Object)mop.func_178782_a()))) {
            return ImmutableList.of();
        }
        TinkerToolEvent.ExtraBlockBreak event = TinkerToolEvent.ExtraBlockBreak.fireEvent(stack, player, state, width, height, depth, distance);
        if (event.isCanceled()) {
            return ImmutableList.of();
        }
        width = event.width;
        height = event.height;
        depth = event.depth;
        distance = event.distance;
        BlockPos start = origin;
        switch (mop.field_178784_b) {
            case DOWN: 
            case UP: {
                Vec3i vec = player.func_174811_aO().func_176730_m();
                x = vec.func_177958_n() * height + vec.func_177952_p() * width;
                y = mop.field_178784_b.func_176743_c().func_179524_a() * -depth;
                z = vec.func_177958_n() * width + vec.func_177952_p() * height;
                start = start.func_177982_a(-x / 2, 0, -z / 2);
                if (x % 2 == 0) {
                    if (x > 0 && mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n() > 0.5) {
                        start = start.func_177982_a(1, 0, 0);
                    } else if (x < 0 && mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n() < 0.5) {
                        start = start.func_177982_a(-1, 0, 0);
                    }
                }
                if (z % 2 != 0) break;
                if (z > 0 && mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p() > 0.5) {
                    start = start.func_177982_a(0, 0, 1);
                    break;
                }
                if (z >= 0 || !(mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p() < 0.5)) break;
                start = start.func_177982_a(0, 0, -1);
                break;
            }
            case NORTH: 
            case SOUTH: {
                x = width;
                y = height;
                z = mop.field_178784_b.func_176743_c().func_179524_a() * -depth;
                start = start.func_177982_a(-x / 2, -y / 2, 0);
                if (x % 2 == 0 && mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n() > 0.5) {
                    start = start.func_177982_a(1, 0, 0);
                }
                if (y % 2 != 0 || !(mop.field_72307_f.field_72448_b - (double)mop.func_178782_a().func_177956_o() > 0.5)) break;
                start = start.func_177982_a(0, 1, 0);
                break;
            }
            case WEST: 
            case EAST: {
                x = mop.field_178784_b.func_176743_c().func_179524_a() * -depth;
                y = height;
                z = width;
                start = start.func_177982_a(0, -y / 2, -z / 2);
                if (y % 2 == 0 && mop.field_72307_f.field_72448_b - (double)mop.func_178782_a().func_177956_o() > 0.5) {
                    start = start.func_177982_a(0, 1, 0);
                }
                if (z % 2 != 0 || !(mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p() > 0.5)) break;
                start = start.func_177982_a(0, 0, 1);
                break;
            }
            default: {
                z = 0;
                y = 0;
                x = 0;
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int xp = start.func_177958_n(); xp != start.func_177958_n() + x; xp += x / MathHelper.func_76130_a((int)x)) {
            for (int yp = start.func_177956_o(); yp != start.func_177956_o() + y; yp += y / MathHelper.func_76130_a((int)y)) {
                for (int zp = start.func_177952_p(); zp != start.func_177952_p() + z; zp += z / MathHelper.func_76130_a((int)z)) {
                    BlockPos pos;
                    if (xp == origin.func_177958_n() && yp == origin.func_177956_o() && zp == origin.func_177952_p() || distance > 0 && MathHelper.func_76130_a((int)(xp - origin.func_177958_n())) + MathHelper.func_76130_a((int)(yp - origin.func_177956_o())) + MathHelper.func_76130_a((int)(zp - origin.func_177952_p())) > distance || !ToolHelper.isToolEffective2(stack, world.func_180495_p(pos = new BlockPos(xp, yp, zp)))) continue;
                    builder.add((Object)pos);
                }
            }
        }
        return builder.build();
    }

    private static boolean canBreakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!ToolHelper.isToolEffective2(stack, state)) {
            return false;
        }
        IBlockState refState = world.func_180495_p(refPos);
        float refStrength = ForgeHooks.blockStrength((IBlockState)refState, (EntityPlayer)player, (World)world, (BlockPos)refPos);
        float strength = ForgeHooks.blockStrength((IBlockState)state, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos) || refStrength / strength > 10.0f) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                TinkerNetwork.sendPacket((Entity)player, new SPacketBlockChange(world, pos));
            }
            return false;
        }
        return true;
    }

    public static void breakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (!ToolHelper.canBreakExtraBlock(stack, world, player, pos, refPos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (xp == -1) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
                block.func_180637_b(world, pos, xp);
            }
            TinkerNetwork.sendPacket((Entity)player, new SPacketBlockChange(world, pos));
        } else {
            world.func_175669_a(2001, pos, Block.func_176210_f((IBlockState)state));
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            stack.func_179548_a(world, state, pos, player);
            if (stack.func_190916_E() == 0 && stack == player.func_184614_ca()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)EnumHand.MAIN_HAND);
                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
            NetHandlerPlayClient netHandlerPlayClient = Minecraft.func_71410_x().func_147114_u();
            assert (netHandlerPlayClient != null);
            netHandlerPlayClient.func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
    }

    public static void shearExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        if (!ToolHelper.canBreakExtraBlock(stack, world, player, pos, refPos)) {
            return;
        }
        if (!ToolHelper.shearBlock(stack, world, player, pos)) {
            ToolHelper.breakExtraBlock(stack, world, player, pos, refPos);
        }
    }

    public static boolean shearBlock(ItemStack itemstack, World world, EntityPlayer player, BlockPos pos) {
        IShearable target;
        if (world.field_72995_K) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)world, pos)) {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemstack);
            List drops = target.onSheared(itemstack, (IBlockAccess)world, pos, fortune);
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(TConstruct.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.func_130014_f_(), (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                world.func_72838_d((Entity)entityitem);
            }
            itemstack.func_179548_a(world, state, pos, player);
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public static int getCurrentDurability(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i();
    }

    public static int getMaxDurability(ItemStack stack) {
        return stack.func_77958_k();
    }

    public static void damageTool(ItemStack stack, int amount, EntityLivingBase entity) {
        if (amount == 0 || ToolHelper.isBroken(stack)) {
            return;
        }
        int actualAmount = amount;
        for (ITrait trait : TinkerUtil.getTraitsOrdered(stack)) {
            if (amount > 0) {
                actualAmount = trait.onToolDamage(stack, amount, actualAmount, entity);
                continue;
            }
            actualAmount = trait.onToolHeal(stack, amount, actualAmount, entity);
        }
        if (actualAmount > 0 && TagUtil.getTagSafe(stack).func_74767_n("Unbreakable")) {
            actualAmount = 0;
        }
        actualAmount = Math.min(actualAmount, ToolHelper.getCurrentDurability(stack));
        stack.func_77964_b(stack.func_77952_i() + actualAmount);
        if (ToolHelper.getCurrentDurability(stack) == 0) {
            ToolHelper.breakTool(stack, entity);
        }
    }

    public static void healTool(ItemStack stack, int amount, EntityLivingBase entity) {
        ToolHelper.damageTool(stack, -amount, entity);
    }

    public static boolean isBroken(ItemStack stack) {
        return TagUtil.getToolTag(stack).func_74767_n("Broken");
    }

    public static void breakTool(ItemStack stack, EntityLivingBase entity) {
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        tag.func_74757_a("Broken", true);
        TagUtil.setToolTag(stack, tag);
        if (entity instanceof EntityPlayerMP) {
            entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187635_cQ, entity.func_184176_by(), 0.8f, 0.8f + entity.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            if (entity.func_184587_cr() && entity.func_184607_cu().equals(stack)) {
                entity.func_184602_cy();
            }
            TinkerNetwork.sendTo((AbstractPacket)new ToolBreakAnimationPacket(stack), (EntityPlayerMP)entity);
            if (Config.vanillaToolBreaking) {
                stack.func_190918_g(1);
            }
        }
    }

    public static void unbreakTool(ItemStack stack) {
        if (ToolHelper.isBroken(stack)) {
            stack.func_77964_b(stack.func_77958_k());
            NBTTagCompound tag = TagUtil.getToolTag(stack);
            tag.func_74757_a("Broken", false);
            TagUtil.setToolTag(stack, tag);
        }
    }

    public static void repairTool(ItemStack stack, int amount) {
        ToolHelper.repairTool(stack, amount, null);
    }

    public static void repairTool(ItemStack stack, int amount, EntityLivingBase entity) {
        ToolHelper.unbreakTool(stack);
        TinkerToolEvent.OnRepair.fireEvent(stack, amount);
        ToolHelper.healTool(stack, amount, entity);
    }

    public static boolean attackEntity(ItemStack stack, ToolCore tool, EntityLivingBase attacker, Entity targetEntity) {
        return ToolHelper.attackEntity(stack, tool, attacker, targetEntity, null, true);
    }

    public static boolean attackEntity(ItemStack stack, ToolCore tool, EntityLivingBase attacker, Entity targetEntity, Entity projectileEntity) {
        return ToolHelper.attackEntity(stack, tool, attacker, targetEntity, projectileEntity, false);
    }

    public static boolean attackEntity(ItemStack stack, ToolCore tool, EntityLivingBase attacker, Entity targetEntity, Entity projectileEntity, boolean applyCooldown) {
        if (targetEntity == null || !targetEntity.func_70075_an() || targetEntity.func_85031_j((Entity)attacker) || !stack.func_77942_o()) {
            return false;
        }
        if (ToolHelper.isBroken(stack)) {
            return false;
        }
        if (attacker == null) {
            return false;
        }
        boolean isProjectile = projectileEntity != null;
        EntityLivingBase target = null;
        EntityPlayer player = null;
        if (targetEntity instanceof EntityLivingBase) {
            target = (EntityLivingBase)targetEntity;
        }
        if (attacker instanceof EntityPlayer) {
            player = (EntityPlayer)attacker;
            if (target instanceof EntityPlayer && !player.func_96122_a((EntityPlayer)target)) {
                return false;
            }
        }
        List<ITrait> traits = TinkerUtil.getTraitsOrdered(stack);
        float baseDamage = (float)attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float baseKnockback = attacker.func_70051_ag() ? 1.0f : 0.0f;
        boolean isCritical = attacker.field_70143_R > 0.0f && !attacker.field_70122_E && !attacker.func_70617_f_() && !attacker.func_70090_H() && !attacker.func_70644_a(MobEffects.field_76440_q) && !attacker.func_184218_aH();
        for (ITrait iTrait : traits) {
            if (!iTrait.isCriticalHit(stack, attacker, target)) continue;
            isCritical = true;
        }
        float damage = baseDamage;
        if (target != null) {
            for (ITrait iTrait : traits) {
                damage = iTrait.damage(stack, attacker, target, baseDamage, damage, isCritical);
            }
        }
        if (isCritical) {
            damage *= 1.5f;
        }
        damage = ToolHelper.calcCutoffDamage(damage, tool.damageCutoff());
        float f = baseKnockback;
        if (target != null) {
            for (ITrait trait : traits) {
                f = trait.knockBack(stack, attacker, target, damage, baseKnockback, f, isCritical);
            }
        }
        float f2 = 0.0f;
        double oldVelX = targetEntity.field_70159_w;
        double oldVelY = targetEntity.field_70181_x;
        double oldVelZ = targetEntity.field_70179_y;
        if (target != null) {
            f2 = target.func_110143_aJ();
        }
        SoundEvent sound = null;
        if (player != null) {
            float cooldown = ((EntityPlayer)attacker).func_184825_o(0.5f);
            sound = cooldown > 0.9f ? SoundEvents.field_187727_dV : SoundEvents.field_187733_dX;
            damage *= 0.2f + cooldown * cooldown * 0.8f;
        }
        if (target != null) {
            int hurtResistantTime = target.field_70172_ad;
            for (ITrait trait : traits) {
                trait.onHit(stack, attacker, target, damage, isCritical);
                target.field_70172_ad = hurtResistantTime;
            }
        }
        boolean hit = false;
        hit = isProjectile && tool instanceof IProjectile ? ((IProjectile)((Object)tool)).dealDamageRanged(stack, projectileEntity, attacker, targetEntity, damage) : tool.dealDamage(stack, attacker, targetEntity, damage);
        if (hit && target != null) {
            float damageDealt = f2 - target.func_110143_aJ();
            oldVelX = target.field_70159_w = oldVelX + (target.field_70159_w - oldVelX) * (double)tool.knockback();
            oldVelY = target.field_70181_x = oldVelY + (target.field_70181_x - oldVelY) * (double)tool.knockback() / 3.0;
            oldVelZ = target.field_70179_y = oldVelZ + (target.field_70179_y - oldVelZ) * (double)tool.knockback();
            if (f > 0.0f) {
                double velX = -MathHelper.func_76126_a((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)) * f * 0.5f;
                double velZ = MathHelper.func_76134_b((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)) * f * 0.5f;
                targetEntity.func_70024_g(velX, 0.1, velZ);
                attacker.field_70159_w *= (double)0.6f;
                attacker.field_70179_y *= (double)0.6f;
                attacker.func_70031_b(false);
            }
            if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                TinkerNetwork.sendPacket(targetEntity, new SPacketEntityVelocity(targetEntity));
                targetEntity.field_70133_I = false;
                targetEntity.field_70159_w = oldVelX;
                targetEntity.field_70181_x = oldVelY;
                targetEntity.field_70179_y = oldVelZ;
            }
            if (player != null) {
                if (isCritical) {
                    player.func_71009_b((Entity)target);
                    sound = SoundEvents.field_187718_dS;
                }
                if (damage > baseDamage) {
                    player.func_71047_c(targetEntity);
                }
            }
            attacker.func_130011_c((Entity)target);
            for (ITrait trait : traits) {
                trait.afterHit(stack, attacker, target, damageDealt, isCritical, true);
            }
            if (player != null) {
                stack.func_77961_a(target, player);
                if (!player.field_71075_bZ.field_75098_d && !isProjectile) {
                    tool.reduceDurabilityOnHit(stack, player, damage);
                }
                player.func_71064_a(StatList.field_188111_y, Math.round(damageDealt * 10.0f));
                player.func_71020_j(0.3f);
                if (player.func_130014_f_() instanceof WorldServer && damageDealt > 2.0f) {
                    int k = (int)((double)damageDealt * 0.5);
                    ((WorldServer)player.func_130014_f_()).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, targetEntity.field_70165_t, targetEntity.field_70163_u + (double)(targetEntity.field_70131_O * 0.5f), targetEntity.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                }
                if (!isProjectile && applyCooldown) {
                    player.func_184821_cY();
                }
            } else if (!isProjectile) {
                tool.reduceDurabilityOnHit(stack, null, damage);
            }
        } else {
            sound = SoundEvents.field_187724_dU;
        }
        if (player != null && sound != null) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, player.func_184176_by(), 1.0f, 1.0f);
        }
        return true;
    }

    public static float calcCutoffDamage(float damage, float cutoff) {
        float p = 1.0f;
        float d = damage;
        damage = 0.0f;
        while (d > cutoff) {
            damage += p * cutoff;
            if (p > 0.001f) {
                p *= 0.9f;
            } else {
                return damage += p * cutoff * (d / cutoff - 1.0f);
            }
            d -= cutoff;
        }
        return damage += p * d;
    }

    public static float getActualDamage(ItemStack stack, EntityLivingBase player) {
        float damage = (float)SharedMonsterAttributes.field_111264_e.func_111110_b();
        if (player != null) {
            damage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        }
        damage += ToolHelper.getActualAttack(stack);
        if (stack.func_77973_b() instanceof ToolCore) {
            damage = ToolHelper.calcCutoffDamage(damage, ((ToolCore)stack.func_77973_b()).damageCutoff());
        }
        return damage;
    }

    public static void swingItem(int speed, EntityLivingBase entity) {
        if (!entity.field_82175_bq || entity.field_110158_av >= 3 || entity.field_110158_av < 0) {
            entity.field_110158_av = Math.min(4, -1 + speed);
            entity.field_82175_bq = true;
            if (entity.func_130014_f_() instanceof WorldServer) {
                ((WorldServer)entity.func_130014_f_()).func_73039_n().func_151247_a((Entity)entity, (Packet)new SPacketAnimation((Entity)entity, 0));
            }
        }
    }

    public static ItemStack playerIsHoldingItemWith(EntityPlayer player, Predicate<ItemStack> predicate) {
        ItemStack tool = player.func_184614_ca();
        if (!predicate.test(tool) && !predicate.test(tool = player.func_184592_cb())) {
            return ItemStack.field_190927_a;
        }
        return tool;
    }

    static int getIntTag(ItemStack stack, String key) {
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        return tag.func_74762_e(key);
    }

    static float getfloatTag(ItemStack stack, String key) {
        NBTTagCompound tag = TagUtil.getToolTag(stack);
        return tag.func_74760_g(key);
    }
}

