/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.DryingRecipe;
import slimeknights.tconstruct.library.EntityMeltingRecipe;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.SeveringRecipe;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.fluid.FluidColored;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.plugin.jei.CraftingStationRecipeTransferInfo;
import slimeknights.tconstruct.plugin.jei.alloy.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.alloy.AlloyRecipeChecker;
import slimeknights.tconstruct.plugin.jei.alloy.AlloyRecipeHandler;
import slimeknights.tconstruct.plugin.jei.casting.CastingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.casting.CastingRecipeChecker;
import slimeknights.tconstruct.plugin.jei.casting.CastingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.casting.CastingRecipeWrapper;
import slimeknights.tconstruct.plugin.jei.drying.DryingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.drying.DryingRecipeChecker;
import slimeknights.tconstruct.plugin.jei.drying.DryingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.entitymelting.EntityMeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.entitymelting.EntityMeltingRecipeChecker;
import slimeknights.tconstruct.plugin.jei.entitymelting.EntityMeltingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.interpreter.PatternSubtypeInterpreter;
import slimeknights.tconstruct.plugin.jei.interpreter.TableSubtypeInterpreter;
import slimeknights.tconstruct.plugin.jei.interpreter.ToolPartSubtypeInterpreter;
import slimeknights.tconstruct.plugin.jei.interpreter.ToolSubtypeInterpreter;
import slimeknights.tconstruct.plugin.jei.material.HarvestCategory;
import slimeknights.tconstruct.plugin.jei.material.MaterialWrapper;
import slimeknights.tconstruct.plugin.jei.material.ProjectileCategory;
import slimeknights.tconstruct.plugin.jei.material.RangedCategory;
import slimeknights.tconstruct.plugin.jei.material.Reference;
import slimeknights.tconstruct.plugin.jei.severing.SeveringRecipeCategory;
import slimeknights.tconstruct.plugin.jei.severing.SeveringRecipeChecker;
import slimeknights.tconstruct.plugin.jei.severing.SeveringRecipeHandler;
import slimeknights.tconstruct.plugin.jei.smelting.SmeltingRecipeCategory;
import slimeknights.tconstruct.plugin.jei.smelting.SmeltingRecipeChecker;
import slimeknights.tconstruct.plugin.jei.smelting.SmeltingRecipeHandler;
import slimeknights.tconstruct.plugin.jei.table.TableRecipeHandler;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.smeltery.client.GuiSmeltery;
import slimeknights.tconstruct.smeltery.client.GuiTinkerTank;
import slimeknights.tconstruct.smeltery.client.IGuiLiquidTank;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.TableRecipeFactory;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;
import slimeknights.tconstruct.tools.melee.TinkerMeleeWeapons;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static ICraftingGridHelper craftingGridHelper;
    public static IRecipeRegistry recipeRegistry;
    public static CastingRecipeCategory castingCategory;

    public void registerItemSubtypes(ISubtypeRegistry registry) {
        TableSubtypeInterpreter tableInterpreter = new TableSubtypeInterpreter();
        PatternSubtypeInterpreter patternInterpreter = new PatternSubtypeInterpreter();
        if (TConstruct.pulseManager.isPulseLoaded("TinkerGadgets")) {
            registry.registerSubtypeInterpreter(Item.func_150898_a((Block)TinkerGadgets.rack), (ISubtypeRegistry.ISubtypeInterpreter)tableInterpreter);
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            registry.registerSubtypeInterpreter(Item.func_150898_a((Block)TinkerTools.toolTables), (ISubtypeRegistry.ISubtypeInterpreter)tableInterpreter);
            registry.registerSubtypeInterpreter(Item.func_150898_a((Block)TinkerTools.toolForge), (ISubtypeRegistry.ISubtypeInterpreter)tableInterpreter);
            ToolPartSubtypeInterpreter toolPartInterpreter = new ToolPartSubtypeInterpreter();
            for (IToolPart part : TinkerRegistry.getToolParts()) {
                if (!(part instanceof Item)) continue;
                registry.registerSubtypeInterpreter((Item)part, (ISubtypeRegistry.ISubtypeInterpreter)toolPartInterpreter);
            }
            ToolSubtypeInterpreter toolInterpreter = new ToolSubtypeInterpreter();
            for (ToolCore tool : TinkerRegistry.getTools()) {
                registry.registerSubtypeInterpreter((Item)tool, (ISubtypeRegistry.ISubtypeInterpreter)toolInterpreter);
            }
            registry.registerSubtypeInterpreter((Item)TinkerTools.pattern, (ISubtypeRegistry.ISubtypeInterpreter)patternInterpreter);
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            registry.registerSubtypeInterpreter((Item)TinkerSmeltery.cast, (ISubtypeRegistry.ISubtypeInterpreter)patternInterpreter);
            if (Config.claycasts) {
                registry.registerSubtypeInterpreter((Item)TinkerSmeltery.clayCast, (ISubtypeRegistry.ISubtypeInterpreter)patternInterpreter);
            }
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        if (TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            castingCategory = new CastingRecipeCategory(guiHelper);
            registry.addRecipeCategories(new IRecipeCategory[]{new SmeltingRecipeCategory(guiHelper), new AlloyRecipeCategory(guiHelper), castingCategory, new EntityMeltingRecipeCategory(guiHelper)});
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerGadgets")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new DryingRecipeCategory(guiHelper)});
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new SeveringRecipeCategory(guiHelper)});
            registry.addRecipeCategories(new IRecipeCategory[]{new HarvestCategory(guiHelper)});
            registry.addRecipeCategories(new IRecipeCategory[]{new RangedCategory(guiHelper)});
            registry.addRecipeCategories(new IRecipeCategory[]{new ProjectileCategory(guiHelper)});
        }
    }

    public void register(@Nonnull IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
        blacklist.addIngredientToBlacklist((Object)TinkerCommons.matSlimeBallPink);
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            registry.handleRecipes(TableRecipeFactory.TableRecipe.class, (IRecipeWrapperFactory)new TableRecipeHandler(), "minecraft.crafting");
            registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationRecipeTransferInfo());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerTools.toolTables, 1, BlockToolTable.TableTypes.CraftingStation.meta), new String[]{"minecraft.crafting"});
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            registry.handleRecipes(AlloyRecipe.class, (IRecipeWrapperFactory)new AlloyRecipeHandler(), AlloyRecipeCategory.CATEGORY);
            registry.handleRecipes(MeltingRecipe.class, (IRecipeWrapperFactory)new SmeltingRecipeHandler(), SmeltingRecipeCategory.CATEGORY);
            registry.handleRecipes(EntityMeltingRecipe.class, (IRecipeWrapperFactory)new EntityMeltingRecipeHandler(), EntityMeltingRecipeCategory.CATEGORY);
            registry.handleRecipes(CastingRecipeWrapper.class, (IRecipeWrapperFactory)new CastingRecipeHandler(), CastingRecipeCategory.CATEGORY);
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerSmeltery.smelteryController), new String[]{SmeltingRecipeCategory.CATEGORY, AlloyRecipeCategory.CATEGORY, EntityMeltingRecipeCategory.CATEGORY});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.TABLE.meta), new String[]{CastingRecipeCategory.CATEGORY});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.BASIN.meta), new String[]{CastingRecipeCategory.CATEGORY});
            registry.addRecipeCatalyst((Object)new ItemStack(TinkerSmeltery.searedFurnaceController), new String[]{"minecraft.smelting"});
            registry.addRecipes(SmeltingRecipeChecker.getSmeltingRecipesSet(), SmeltingRecipeCategory.CATEGORY);
            registry.addRecipes(EntityMeltingRecipeChecker.getEntityMeltingRecipes(), EntityMeltingRecipeCategory.CATEGORY);
            registry.addRecipes(AlloyRecipeChecker.getAlloyRecipes(), AlloyRecipeCategory.CATEGORY);
            registry.addRecipes(CastingRecipeChecker.getCastingRecipes(), CastingRecipeCategory.CATEGORY);
            registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TinkerGuiTankHandler<GuiTinkerTank>(GuiTinkerTank.class), new TinkerGuiTankHandler<GuiSmeltery>(GuiSmeltery.class)});
            for (MaterialIntegration materialIntegration : TinkerRegistry.getMaterialIntegrations()) {
                if (materialIntegration.isIntegrated() || !(materialIntegration.fluid instanceof FluidColored)) continue;
                FluidStack stack = new FluidStack(materialIntegration.fluid, 1000);
                blacklist.addIngredientToBlacklist((Object)stack);
                blacklist.addIngredientToBlacklist((Object)FluidUtil.getFilledBucket((FluidStack)stack));
            }
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerGadgets")) {
            registry.handleRecipes(DryingRecipe.class, (IRecipeWrapperFactory)new DryingRecipeHandler(), DryingRecipeCategory.CATEGORY);
            registry.addRecipes(DryingRecipeChecker.getDryingRecipes(), DryingRecipeCategory.CATEGORY);
            registry.addRecipeCatalyst((Object)BlockTable.createItemstack(TinkerGadgets.rack, 1, (Block)Blocks.field_150376_bx, 0), new String[]{DryingRecipeCategory.CATEGORY});
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            registry.handleRecipes(SeveringRecipe.class, (IRecipeWrapperFactory)new SeveringRecipeHandler(), SeveringRecipeCategory.CATEGORY);
            registry.addRecipes(SeveringRecipeChecker.getSeveringRecipes(), SeveringRecipeCategory.CATEGORY);
            int added = 0;
            for (Material head : TinkerRegistry.getAllMaterials()) {
                List<PartMaterialType> reqs = TinkerMeleeWeapons.cleaver.getRequiredComponents();
                ArrayList<Material> mats = new ArrayList<Material>(reqs.size());
                for (int i = 0; i < reqs.size(); ++i) {
                    mats.add(head);
                }
                ItemStack tool = TinkerMeleeWeapons.cleaver.buildItem(mats);
                if (!TinkerMeleeWeapons.cleaver.hasValidMaterials(tool)) continue;
                registry.addRecipeCatalyst((Object)tool, new String[]{SeveringRecipeCategory.CATEGORY});
                if (++added <= 10) continue;
                break;
            }
        }
        if (TConstruct.pulseManager.isPulseLoaded("TinkerTools")) {
            List materialWrappers = TinkerRegistry.getAllMaterials().stream().filter(material -> !material.isHidden() && material.hasItems() && !material.getAllStats().isEmpty()).map(MaterialWrapper::new).collect(Collectors.toList());
            HarvestCategory harvestCategory = new HarvestCategory(guiHelper);
            List harvestWrapper = materialWrappers.stream().filter(materialWrapper -> Reference.HARVEST_TYPES.stream().anyMatch(type -> materialWrapper.getMaterial().hasStats((String)type))).collect(Collectors.toList());
            registry.addRecipes(harvestWrapper, harvestCategory.getUid());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerTools.toolForge, 1), new String[]{harvestCategory.getUid()});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerTools.toolTables, 1, 3), new String[]{harvestCategory.getUid()});
            RangedCategory rangedCategory = new RangedCategory(guiHelper);
            List rangedWrapper = materialWrappers.stream().filter(materialWrapper -> Reference.RANGED_TYPES.stream().anyMatch(type -> materialWrapper.getMaterial().hasStats((String)type))).collect(Collectors.toList());
            registry.addRecipes(rangedWrapper, rangedCategory.getUid());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerTools.toolForge, 1), new String[]{rangedCategory.getUid()});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerTools.toolTables, 1, 3), new String[]{rangedCategory.getUid()});
            ProjectileCategory projectileCategory = new ProjectileCategory(guiHelper);
            List projectileWrapper = materialWrappers.stream().filter(materialWrapper -> Reference.PROJECTILE_TYPES.stream().anyMatch(type -> materialWrapper.getMaterial().hasStats((String)type))).collect(Collectors.toList());
            registry.addRecipes(projectileWrapper, projectileCategory.getUid());
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerTools.toolForge, 1), new String[]{projectileCategory.getUid()});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)TinkerTools.toolTables, 1, 3), new String[]{projectileCategory.getUid()});
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        recipeRegistry = jeiRuntime.getRecipeRegistry();
    }

    private static class TinkerGuiTankHandler<T extends GuiContainer>
    implements IAdvancedGuiHandler<T> {
        private Class<T> clazz;

        public TinkerGuiTankHandler(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Nonnull
        public Class<T> getGuiContainerClass() {
            return this.clazz;
        }

        @Nullable
        public Object getIngredientUnderMouse(T guiContainer, int mouseX, int mouseY) {
            return ((IGuiLiquidTank)guiContainer).getFluidStackAtPosition(mouseX, mouseY);
        }
    }
}

