/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.material;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.text.WordUtils;
import slimeknights.mantle.util.LocUtils;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.plugin.jei.material.GuideButton;
import slimeknights.tconstruct.plugin.jei.material.MaterialWrapper;
import slimeknights.tconstruct.shared.TinkerCommons;

public abstract class AbstractCategory
implements IRecipeCategory<MaterialWrapper> {
    protected ResourceLocation icon_location = new ResourceLocation("tconstruct", "textures/gui/jei/materials.png");
    protected static final int LINE_HEIGHT = 10;
    protected static final float LINE_SPACING = 0.5f;
    protected static final float HEADING_SPACING = 0.1f;
    protected static final int WIDTH = 178;
    protected static final int HEIGHT = 150;
    private static final int PARTS = 0;
    private static final int REPRES = 1;
    private static final int FLUID = 2;
    private static final int BUTTON_WIDTH = 18;
    private static final int BUTTON_HEIGHT = 18;
    protected String title;
    protected String uuid;
    protected int mouseX;
    protected int mouseY;
    protected int btn_id;
    protected IDrawable background;
    protected IDrawable icon;
    protected IDrawable slot;
    protected MaterialWrapper materialWrapper;
    protected final List<String> relatedParts;

    public AbstractCategory(IGuiHelper guiHelper, List<String> parts) {
        this.background = guiHelper.createBlankDrawable(178, 150);
        this.slot = guiHelper.getSlotDrawable();
        this.relatedParts = parts;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public String getUid() {
        return this.uuid;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public String getModName() {
        return "Tinkers' Antique";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull MaterialWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        this.materialWrapper = recipeWrapper;
        if (recipeWrapper.material.hasFluid()) {
            recipeLayout.getFluidStacks().init(2, true, this.slot.getWidth() + 1, 1);
            recipeLayout.getFluidStacks().set(2, new FluidStack(recipeWrapper.material.getFluid(), 1000));
        }
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        ItemStack item = recipeWrapper.material.getRepresentativeItem();
        if (item != null && !item.func_190926_b()) {
            stacks.init(1, true, 0, 0);
            stacks.set(1, item);
        }
        stacks.init(0, true, 142, 0);
        stacks.set(0, recipeWrapper.getParts(this.relatedParts));
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        ItemStack item = this.materialWrapper.getMaterial().getRepresentativeItem();
        if (item != null && !item.func_190926_b()) {
            this.slot.draw(minecraft, 142, 0);
        }
        this.slot.draw(minecraft, 0, 0);
        if (this.materialWrapper.getMaterial().hasFluid()) {
            this.slot.draw(minecraft, this.slot.getWidth(), 0);
        }
        float lineNumber = 0.0f;
        this.drawComponentShadowCentered(TextFormatting.UNDERLINE + this.materialWrapper.material.getLocalizedName() + TextFormatting.RESET, lineNumber, this.materialWrapper.material.materialTextColor);
        this.drawTraits(this.materialWrapper.getTraits(this.relatedParts), lineNumber += 3.0f);
        this.drawStats(this.materialWrapper.getStatInfos(this.relatedParts), lineNumber);
        this.getGuideButton().func_191745_a(minecraft, this.mouseX, this.mouseY, 0.0f);
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        ArrayList<String> tooltip = new ArrayList<String>();
        LinkedList<ITrait> traits = this.materialWrapper.getTraits(this.relatedParts);
        traits.forEach(iTrait -> {
            int index = traits.indexOf(iTrait);
            int width = ClientProxy.fontRenderer.func_78256_a(iTrait.getLocalizedName());
            if (this.isHovered(178 - width, 178, 3 + index, mouseX, mouseY)) {
                String[] desc = LocUtils.convertNewlines((String)iTrait.getLocalizedDesc()).split("\n");
                if (desc.length > 1) {
                    String title = TextFormatting.GOLD + desc[0] + TextFormatting.RESET;
                    tooltip.add(title);
                    tooltip.addAll(this.formatTooltip(desc[1]));
                } else {
                    tooltip.addAll(this.formatTooltip(desc[0]));
                }
            }
        });
        tooltip.addAll(this.additionalTooltips(this.materialWrapper.getStatInfos(this.relatedParts), this.materialWrapper.getStatDescriptions(this.relatedParts), mouseX, mouseY));
        if (this.getGuideButton().mousePressed(mouseX, mouseY)) {
            tooltip.add(this.getGuideButton().getTooltip());
        }
        return tooltip;
    }

    protected GuideButton getGuideButton() {
        if (this.materialWrapper.guideButton == null) {
            this.materialWrapper.guideButton = new GuideButton(this.btn_id++, 160, 0, 18, 18, this.uuid, this.materialWrapper.material.identifier, this.materialWrapper.getUseableParts(this.relatedParts), new ItemStack((Item)TinkerCommons.book));
        }
        return this.materialWrapper.guideButton;
    }

    protected abstract List<String> additionalTooltips(List<String> var1, List<String> var2, int var3, int var4);

    protected abstract void drawStats(LinkedList<String> var1, float var2);

    protected final void drawComponent(String component, float x, float lineNumber, int color, boolean shadow) {
        ClientProxy.fontRenderer.func_175065_a(component, x, lineNumber * 10.0f, color, shadow);
    }

    protected final void drawStatComponent(String component, float lineNumber) {
        int color = -986896;
        String category = component.split(": ")[0] + ": ";
        String value = component.split(": ")[1];
        int width = ClientProxy.fontRenderer.func_78256_a(category);
        this.drawComponent(category, 0.0f, lineNumber, color, true);
        this.drawComponent(value, width, lineNumber, Color.GREEN.getRGB(), true);
    }

    protected final void drawComponentShadowCentered(String component, float lineNumber, int color) {
        this.drawComponent(component, (float)(178 - ClientProxy.fontRenderer.func_78256_a(component)) / 2.0f, lineNumber, color, true);
    }

    protected final void drawTraits(List<ITrait> traits, float lineNumber) {
        for (ITrait trait : traits) {
            String component = trait.getLocalizedName();
            int width = ClientProxy.fontRenderer.func_78256_a(component);
            int color = this.materialWrapper.material.materialTextColor;
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.drawComponent(component, 178 - width, f, color, true);
        }
    }

    protected final String getHeading(String langKey) {
        return TextFormatting.UNDERLINE + I18n.func_135052_a((String)langKey, (Object[])new Object[0]) + TextFormatting.RESET;
    }

    protected boolean isHovered(int left, int right, float y, int mouseX, int mouseY) {
        return left <= mouseX && mouseX < right && y * 10.0f <= (float)mouseY && (float)mouseY < y * 10.0f + 10.0f;
    }

    protected List<String> formatTooltip(String tooltip) {
        return Arrays.asList(WordUtils.wrap((String)tooltip, (int)40).replace("\\n", " ").split("\\r\\n"));
    }
}

