/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.material;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.plugin.jei.material.GuideButton;

public class MaterialWrapper
implements IRecipeWrapper {
    final Material material;
    protected GuideButton guideButton;

    public MaterialWrapper(Material material) {
        this.material = material;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.getInputs());
        ingredients.setOutputs(VanillaTypes.ITEM, this.getOutputs());
        if (this.material.hasFluid()) {
            ingredients.setInputs(VanillaTypes.FLUID, this.getFluid());
        }
    }

    private List<ItemStack> getInputs() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        if (this.material.hasFluid()) {
            TinkerRegistry.getAllMeltingRecipies().stream().filter(meltingRecipe -> this.material.getFluid().equals(meltingRecipe.output.getFluid())).map(meltingRecipe -> meltingRecipe.input.getInputs()).forEach(inputs::addAll);
        }
        if (this.material.getRepresentativeItem() != null && !this.material.getRepresentativeItem().func_190926_b()) {
            inputs.add(this.material.getRepresentativeItem());
        }
        return inputs;
    }

    private List<ItemStack> getOutputs() {
        return TinkerRegistry.getToolParts().stream().filter(iToolPart -> iToolPart.canUseMaterial(this.material)).map(iToolPart -> iToolPart.getItemstackWithMaterial(this.material)).collect(Collectors.toList());
    }

    private List<FluidStack> getFluid() {
        return Collections.singletonList(new FluidStack(this.material.getFluid(), 1));
    }

    public LinkedList<ItemStack> getParts(List<String> parts) {
        LinkedList<ItemStack> partList = new LinkedList<ItemStack>();
        for (IToolPart part : TinkerRegistry.getToolParts()) {
            ItemStack stack;
            if (!parts.stream().anyMatch(part::hasUseForStat) || !part.canUseMaterial(this.material) || (stack = part.getItemstackWithMaterial(this.material)).equals(this.material.getShard())) continue;
            partList.add(part.getItemstackWithMaterial(this.material));
        }
        return partList;
    }

    public List<String> getUseableParts(List<String> parts) {
        ArrayList<String> useableParts = new ArrayList<String>();
        block0: for (String partType : parts) {
            for (IToolPart part : TinkerRegistry.getToolParts()) {
                if (!part.hasUseForStat(partType) || !part.canUseMaterial(this.material)) continue;
                useableParts.add(partType);
                continue block0;
            }
        }
        return useableParts;
    }

    public LinkedList<ITrait> getTraits(List<String> parts) {
        LinkedList<ITrait> traitList = new LinkedList<ITrait>();
        for (String part : parts) {
            for (ITrait trait : this.material.getAllTraitsForStats(part)) {
                if (traitList.contains(trait)) continue;
                traitList.add(trait);
            }
        }
        return traitList;
    }

    public LinkedList<String> getStatInfos(List<String> parts) {
        LinkedList<String> statList = new LinkedList<String>();
        this.getStats(parts).forEach(s -> statList.addAll(s.getLocalizedInfo()));
        return statList;
    }

    public LinkedList<String> getStatDescriptions(List<String> parts) {
        LinkedList<String> descList = new LinkedList<String>();
        this.getStats(parts).forEach(s -> descList.addAll(s.getLocalizedDesc()));
        return descList;
    }

    private List<? extends IMaterialStats> getStats(List<String> parts) {
        ArrayList stats = new ArrayList();
        LinkedList internal_parts = parts.stream().map(entry -> {
            if (entry.equals("projectile")) {
                return "head";
            }
            return entry;
        }).collect(Collectors.toCollection(LinkedList::new));
        internal_parts.forEach(part -> stats.add(this.material.getStats((String)part)));
        return stats.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (this.guideButton != null && this.guideButton.func_146116_c(minecraft, mouseX, mouseY)) {
            this.guideButton.openBook();
            return true;
        }
        return false;
    }
}

