/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.severing;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.SeveringRecipe;
import slimeknights.tconstruct.plugin.jei.severing.SeveringRecipeCategory;

public class SeveringRecipeWrapper
implements IRecipeWrapper {
    protected final List<List<ItemStack>> input;
    protected final List<ItemStack> output;
    protected final ResourceLocation entity;
    private String configStr;
    private double configScale;
    private World curWorld;
    private EntityLivingBase entityInst;
    private boolean entityErrored = false;
    protected double renderScale = -1.0;

    public SeveringRecipeWrapper(SeveringRecipe recipe) {
        this.input = ImmutableList.of((Object)ImmutableList.of((Object)recipe.spawnEgg));
        this.output = ImmutableList.of((Object)recipe.getResult());
        this.entity = recipe.input;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.input);
        ingredients.setOutputs(ItemStack.class, this.output);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (minecraft.field_71441_e != null && minecraft.field_71441_e != this.curWorld) {
            this.curWorld = minecraft.field_71441_e;
            if (this.entityInst == null && !this.entityErrored) {
                try {
                    Class<EntityLivingBase> entityClass = EntityList.getClass((ResourceLocation)this.entity).asSubclass(EntityLivingBase.class);
                    this.entityInst = entityClass.getConstructor(World.class).newInstance(minecraft.field_71441_e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.entityErrored = true;
                }
            }
        }
        if (this.entityInst != null) {
            this.entityInst.field_70737_aN = Minecraft.func_71386_F() / 500L % 4L == 0L ? 100 : 0;
            this.renderScale = -1.0;
            if (this.renderScale < 0.0) {
                double scaleFact;
                double width = this.entityInst.field_70130_N;
                double height = this.entityInst.field_70131_O;
                if (width > height) {
                    scaleFact = 13.0;
                    this.renderScale = scaleFact / width;
                } else {
                    scaleFact = 32.0;
                    this.renderScale = scaleFact / height;
                }
            }
            for (String scale : Config.entityJEIRendererTransformation) {
                String[] split = scale.split(";");
                if (this.configStr == scale || split.length != 2 || !this.entity.toString().equalsIgnoreCase(split[0])) continue;
                try {
                    this.configScale = Double.parseDouble(split[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.configStr = scale;
                break;
            }
            int x = 35;
            int y = 45;
            GlStateManager.func_179126_j();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            if (this.configStr != null) {
                GlStateManager.func_179139_a((double)this.configScale, (double)this.configScale, (double)this.configScale);
            }
            GuiInventory.func_147046_a((int)0, (int)0, (int)((int)Math.round(this.renderScale)), (float)-100.0f, (float)0.0f, (EntityLivingBase)this.entityInst);
            GlStateManager.func_179121_F();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        if (Config.fancyJEIBeheadingAnimation) {
            float theta = (float)(1.5707963267948966 * (double)(((float)minecraft.field_71441_e.func_82737_E() + minecraft.func_184121_ak()) / 10.0f + 5.0f));
            double movementX = Math.sin(theta);
            double movementY = Math.cos(theta);
            double x = 50.0 + movementX * 16.0;
            double y = 35.0 + movementY * 8.0;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
            GlStateManager.func_179114_b((float)((float)(120.0 * movementX)), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179097_i();
            SeveringRecipeCategory.instance.icon.draw(minecraft, 0, -16);
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179097_i();
            SeveringRecipeCategory.instance.icon.draw(minecraft, 50, 23);
            GlStateManager.func_179126_j();
        }
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX > 9 && mouseY > 8 && mouseX < 42 && mouseY < 57 && this.entityInst != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.entityInst.func_70005_c_());
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(this.entity.func_110624_b());
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                list.add(TextFormatting.DARK_GRAY + this.entity.toString());
            }
            list.add(TextFormatting.BLUE + "" + TextFormatting.ITALIC + (mod == null ? "Unknown" : mod.getName()));
            return list;
        }
        return ImmutableList.of();
    }
}

