/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.worldgen;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockCommonOre;

public class OverworldOreGenerator
implements IWorldGenerator {
    public static OverworldOreGenerator INSTANCE = new OverworldOreGenerator();
    public WorldGenMinable copperGen = new WorldGenMinable(TinkerCommons.blockCommonOre.func_176203_a(BlockCommonOre.OreTypes.COPPER.getMeta()), 5, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    public WorldGenMinable tinGen = new WorldGenMinable(TinkerCommons.blockCommonOre.func_176203_a(BlockCommonOre.OreTypes.TIN.getMeta()), 5, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    public WorldGenMinable aluminumGen = new WorldGenMinable(TinkerCommons.blockCommonOre.func_176203_a(BlockCommonOre.OreTypes.ALUMINUM.getMeta()), 5, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w instanceof WorldProviderSurface) {
            if (Config.genCopper) {
                this.generateOverworldOre(this.copperGen, Config.copperRate, Config.copperHeightMin, Config.copperHeightMax, random, chunkX, chunkZ, world);
            }
            if (Config.genTin) {
                this.generateOverworldOre(this.tinGen, Config.tinRate, Config.tinHeightMin, Config.tinHeightMax, random, chunkX, chunkZ, world);
            }
            if (Config.genAluminum) {
                this.generateOverworldOre(this.aluminumGen, Config.aluminumRate, Config.aluminumHeightMin, Config.aluminumHeightMax, random, chunkX, chunkZ, world);
            }
        }
    }

    public void generateOverworldOre(WorldGenMinable gen, int rate, int heightMin, int heightMax, Random random, int chunkX, int chunkZ, World world) {
        for (int i = 0; i < rate; ++i) {
            BlockPos pos = new BlockPos(chunkX * 16, heightMin, chunkZ * 16);
            pos = pos.func_177982_a(random.nextInt(16), random.nextInt(heightMax - heightMin), random.nextInt(16));
            gen.func_180709_b(world, random, pos);
        }
    }
}

