/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.sound.SoundFading;
import slimeknights.tconstruct.library.sound.ISoundSource;
import slimeknights.tconstruct.library.sound.SoundType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockFaucet;
import slimeknights.tconstruct.smeltery.network.FaucetActivationPacket;

public class TileFaucet
extends TileEntity
implements ITickable,
ISoundSource {
    public static final int LIQUID_TRANSFER = Config.liquidTransferRate;
    public static final int TRANSACTION_AMOUNT = 144;
    public EnumFacing direction;
    public boolean isPouring;
    public boolean stopPouring;
    public FluidStack drained;
    public boolean lastRedstoneState;

    public TileFaucet() {
        this.reset();
    }

    public boolean activate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        if (!state.func_177227_a().contains(BlockFaucet.FACING)) {
            return false;
        }
        if (this.isPouring) {
            this.stopPouring = true;
            return true;
        }
        this.direction = (EnumFacing)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFaucet.FACING);
        this.doTransfer();
        if (this.drained != null) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, Sounds.faucet_trigger, SoundCategory.BLOCKS, 1.0f, 0.8f + 0.4f * this.field_145850_b.field_73012_v.nextFloat());
            } else {
                TinkerSmeltery.proxy.playSound(this.getSound());
            }
        }
        return this.isPouring;
    }

    public void handleRedstone(boolean hasSignal) {
        if (hasSignal != this.lastRedstoneState) {
            this.lastRedstoneState = hasSignal;
            if (hasSignal) {
                this.field_145850_b.func_175684_a(this.field_174879_c, this.func_145838_q(), 2);
            }
        }
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.isPouring) {
            return;
        }
        if (this.drained != null) {
            if (this.drained.amount <= 0) {
                this.drained = null;
                if (!this.stopPouring) {
                    this.doTransfer();
                } else {
                    this.reset();
                }
                if (!this.func_145831_w().field_72995_K && !this.isPouring) {
                    this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f, 0.8f + 0.4f * this.field_145850_b.field_73012_v.nextFloat());
                }
            } else {
                this.pour();
            }
        }
    }

    protected void doTransfer() {
        int filled;
        FluidStack drained;
        if (this.drained != null) {
            return;
        }
        IFluidHandler toDrain = this.getFluidHandler(this.field_174879_c.func_177972_a(this.direction), this.direction.func_176734_d());
        IFluidHandler toFill = this.getFluidHandler(this.field_174879_c.func_177977_b(), EnumFacing.UP);
        if (toDrain != null && toFill != null && (drained = toDrain.drain(144, false)) != null && (Config.drainGaseousFluids || !drained.getFluid().isGaseous()) && (filled = toFill.fill(drained, false)) > 0) {
            this.drained = toDrain.drain(filled, true);
            this.isPouring = true;
            this.pour();
            if (this.func_145831_w() instanceof WorldServer && !this.func_145831_w().field_72995_K) {
                TinkerNetwork.sendToClients((WorldServer)this.func_145831_w(), this.field_174879_c, (AbstractPacket)new FaucetActivationPacket(this.field_174879_c, drained));
            }
            return;
        }
        this.reset();
    }

    protected void pour() {
        if (this.drained == null) {
            return;
        }
        IFluidHandler toFill = this.getFluidHandler(this.field_174879_c.func_177977_b(), EnumFacing.UP);
        if (toFill != null) {
            FluidStack fillStack = this.drained.copy();
            fillStack.amount = Math.min(this.drained.amount, Config.liquidTransferRate);
            int filled = toFill.fill(fillStack, false);
            if (filled > 0) {
                this.drained.amount -= filled;
                fillStack.amount = filled;
                toFill.fill(fillStack, true);
            }
        } else {
            this.reset();
        }
    }

    protected void reset() {
        this.isPouring = false;
        this.stopPouring = false;
        this.drained = null;
        this.direction = EnumFacing.DOWN;
        this.lastRedstoneState = false;
        if (this.func_145831_w() instanceof WorldServer && !this.func_145831_w().field_72995_K) {
            TinkerNetwork.sendToClients((WorldServer)this.func_145831_w(), this.field_174879_c, (AbstractPacket)new FaucetActivationPacket(this.field_174879_c, null));
        }
    }

    protected IFluidHandler getFluidHandler(BlockPos pos, EnumFacing direction) {
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction)) {
            return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() - 1), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        if (this.drained != null) {
            this.drained.writeToNBT(compound);
            compound.func_74768_a("direction", this.direction.func_176745_a());
            compound.func_74757_a("stop", this.stopPouring);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.drained = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
        if (this.drained != null) {
            this.isPouring = true;
            this.direction = EnumFacing.values()[compound.func_74762_e("direction")];
            this.stopPouring = compound.func_74767_n("stop");
        } else {
            this.reset();
        }
    }

    public void onActivationPacket(FluidStack fluid) {
        if (fluid == null) {
            this.reset();
        } else {
            this.drained = fluid;
            this.isPouring = true;
            this.direction = (EnumFacing)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFaucet.FACING);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        boolean wasPouring = this.isPouring;
        this.func_145839_a(tag);
        if (!wasPouring && this.isPouring) {
            TinkerSmeltery.proxy.playSound(this.getSound());
        }
    }

    @Override
    public SoundType getSoundType() {
        return SoundType.FAUCET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISound getSound() {
        return new SoundFading(this, this.field_174879_c);
    }

    @Override
    public boolean shouldPlaySound() {
        return !this.func_145837_r() && this.isPouring;
    }
}

