/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.common.inventory.ContainerToolStation;

public class SlotToolStationOut
extends Slot {
    public ContainerToolStation parent;
    public boolean isToolForDeconstruction = false;

    public SlotToolStationOut(int index, int xPosition, int yPosition, ContainerToolStation container) {
        super((IInventory)new InventoryCraftResult(), index, xPosition, yPosition);
        this.parent = container;
    }

    public boolean func_75214_a(ItemStack stack) {
        return Config.deconstructTools && this.parent.getInputSlotContents().isEmpty() && !stack.func_190926_b() && stack.func_77973_b() instanceof TinkersItem && !stack.func_77951_h() && !ToolHelper.isBroken(stack) && this.parent.getBuildableTools().contains(stack.func_77973_b()) && !this.isSealedArtifact(stack) && this.hasEnoughXP(stack) && this.hasEnoughLevels(stack) && this.parent.getSelectedTool() == null;
    }

    public void func_75215_d(@Nonnull ItemStack stack) {
        super.func_75215_d(stack);
        if (this.func_75214_a(stack)) {
            this.isToolForDeconstruction = true;
            this.parent.func_75130_a((IInventory)this.parent.getTile());
            this.parent.func_75142_b();
        }
    }

    @Nonnull
    public ItemStack func_190901_a(EntityPlayer playerIn, @Nonnull ItemStack stack) {
        FMLCommonHandler.instance().firePlayerCraftingEvent(playerIn, stack, (IInventory)this.parent.getTile());
        this.parent.onResultTaken(playerIn, stack);
        stack.func_77980_a(playerIn.func_130014_f_(), playerIn, 1);
        return super.func_190901_a(playerIn, stack);
    }

    private boolean isSealedArtifact(ItemStack stack) {
        NBTTagCompound modifierTag = TinkerUtil.getModifierTag(stack, "tconevo.artifact");
        return ModifierNBT.readTag((NBTTagCompound)modifierTag).level == 1;
    }

    private boolean hasEnoughXP(ItemStack stack) {
        NBTTagCompound modifierTag = TinkerUtil.getModifierTag(stack, "toolleveling");
        if (modifierTag.func_74764_b("xp")) {
            int xp = modifierTag.func_74762_e("xp");
            return xp >= Config.deconstructXPRequirement;
        }
        return true;
    }

    private boolean hasEnoughLevels(ItemStack stack) {
        NBTTagCompound modifierTag = TinkerUtil.getModifierTag(stack, "toolleveling");
        if (modifierTag.func_74764_b("level")) {
            int level = modifierTag.func_74762_e("level");
            return level >= Config.deconstructLevelRequirement;
        }
        return true;
    }
}

