/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import java.util.Collection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.capability.projectile.CapabilityTinkerProjectile;
import slimeknights.tconstruct.library.capability.projectile.ITinkerProjectile;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.tools.modifiers.ToolModifier;

public class ModBeheading
extends ToolModifier {
    private static String BEHEADING_ID = "beheading";
    private static String CLEAVER_MODIFIER_ID = BEHEADING_ID + "_cleaver";
    private static int BEHEADING_COLOR = 1070923;
    public static ModBeheading CLEAVER_BEHEADING_MOD = new ModBeheadingCleaver();

    public ModBeheading() {
        this("beheading");
        this.addAspects(ModifierAspect.freeModifier);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    ModBeheading(String traitBeheading) {
        super(traitBeheading, BEHEADING_COLOR);
        this.addAspects(new ModifierAspect.LevelAspect(this, 10), new ModifierAspect.DataAspect(this));
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        NBTTagCompound tag = TinkerUtil.getModifierTag(rootCompound, CLEAVER_MODIFIER_ID);
        if (!tag.func_82582_d()) {
            if (!modifierTag.func_74767_n("absorbedCleaver")) {
                ModifierNBT data = ModifierNBT.readTag(modifierTag);
                data.level += ModifierNBT.readTag((NBTTagCompound)tag).level;
                data.write(modifierTag);
                modifierTag.func_74757_a("absorbedCleaver", true);
            }
            NBTTagList tagList = TagUtil.getModifiersTagList(rootCompound);
            int index = TinkerUtil.getIndexInCompoundList(tagList, CLEAVER_MODIFIER_ID);
            tagList.func_74744_a(index);
            TagUtil.setModifiersTagList(rootCompound, tagList);
        }
    }

    private int getBeheadingLevel(DamageSource source) {
        if (!(source.func_76346_g() instanceof EntityLivingBase)) {
            return 0;
        }
        ItemStack item = CapabilityTinkerProjectile.getTinkerProjectile(source).map(ITinkerProjectile::getItemStack).orElse(((EntityLivingBase)source.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND));
        if (item.func_190926_b()) {
            return 0;
        }
        NBTTagCompound tag = TinkerUtil.getModifierTag(item, this.getIdentifier());
        int level = ModifierNBT.readTag((NBTTagCompound)tag).level;
        if (level == 0) {
            tag = TinkerUtil.getModifierTag(item, CLEAVER_MODIFIER_ID);
            level = ModifierNBT.readTag((NBTTagCompound)tag).level;
        }
        return level;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Collection<ItemStack> heads;
        int level = this.getBeheadingLevel(event.getSource());
        if (this.shouldDropHead(level) && !(heads = TinkerRegistry.getHeadDrop(event.getEntityLiving())).isEmpty()) {
            ItemStack head = heads.toArray(new ItemStack[0])[TConstruct.random.nextInt(heads.size())];
            if (head.func_190916_E() > 1) {
                head.func_190920_e(TConstruct.random.nextInt(head.func_190916_E()) + 1);
            }
            if (!head.func_190926_b() && !this.alreadyContainsDrop(event, head)) {
                EntityItem entityitem = new EntityItem(event.getEntityLiving().func_130014_f_(), event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, head.func_77946_l());
                entityitem.func_174869_p();
                event.getDrops().add(entityitem);
                TConstruct.log.debug("Dropped random head for {}: {}", (Object)event.getEntityLiving().getClass().getSimpleName(), (Object)head);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDrop(LivingDeathEvent event) {
        Collection<ItemStack> heads;
        int level;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.func_82736_K().func_82766_b("keepInventory") && entity instanceof EntityPlayerMP && this.shouldDropHead(level = this.getBeheadingLevel(event.getSource())) && !(heads = TinkerRegistry.getHeadDrop(entity)).isEmpty()) {
            ItemStack head = heads.toArray(new ItemStack[0])[TConstruct.random.nextInt(heads.size())];
            if (head.func_190916_E() > 1) {
                head.func_190920_e(TConstruct.random.nextInt(head.func_190916_E()) + 1);
            }
            if (!head.func_190926_b()) {
                ((EntityPlayerMP)entity).func_71019_a(head.func_77946_l(), true);
                TConstruct.log.debug("Dropped random head for player: {}", (Object)head);
            }
        }
    }

    private boolean shouldDropHead(int level) {
        return level > 0 && level > random.nextInt(10);
    }

    private boolean alreadyContainsDrop(LivingDropsEvent event, ItemStack head) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            return false;
        }
        return event.getDrops().stream().map(EntityItem::func_92059_d).anyMatch(drop -> ItemStack.func_77989_b((ItemStack)drop, (ItemStack)head));
    }

    private static class ModBeheadingCleaver
    extends ModBeheading {
        public ModBeheadingCleaver() {
            super(CLEAVER_MODIFIER_ID);
        }

        @Override
        public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        }

        @Override
        public String getLocalizedDesc() {
            return Util.translate("modifier.%s.desc", BEHEADING_ID);
        }

        @Override
        public String getLocalizedName() {
            return Util.translate("modifier.%s.name", BEHEADING_ID);
        }
    }
}

