/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tools;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockReed;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class Kama
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.field_151569_G, (Object)Material.field_151584_j, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151572_C, (Object)Material.field_151570_A, (Object[])new Material[]{Material.field_151580_n, Material.field_151583_m});

    public Kama(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.HARVEST, Category.WEAPON);
        this.setHarvestLevel("shears", 0);
    }

    public Kama() {
        this(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.kamaHead), PartMaterialType.extra(TinkerTools.binding));
    }

    @Override
    public float damagePotential() {
        return 1.0f;
    }

    @Override
    public double attackSpeed() {
        return 1.3f;
    }

    @Override
    public boolean isEffective(IBlockState state) {
        return effective_materials.contains((Object)state.func_185904_a());
    }

    @Override
    protected boolean breakBlock(ItemStack stack, BlockPos pos, EntityPlayer player) {
        return !ToolHelper.isBroken(stack) && ToolHelper.shearBlock(stack, player.func_130014_f_(), player, pos);
    }

    @Override
    protected void breakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos, BlockPos refPos) {
        ToolHelper.shearExtraBlock(stack, world, player, pos, refPos);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (Config.oldMattockAndKama) {
            return EnumActionResult.PASS;
        }
        return this.doTill(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (ToolHelper.isBroken(itemStackIn)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
        }
        RayTraceResult trace = this.func_77621_a(worldIn, playerIn, true);
        if (trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
        }
        int fortune = ToolHelper.getFortuneLevel(itemStackIn);
        BlockPos origin = trace.func_178782_a();
        boolean harvestedSomething = false;
        for (BlockPos pos : this.getAOEBlocks(itemStackIn, playerIn.func_130014_f_(), playerIn, origin)) {
            harvestedSomething |= this.harvestCrop(itemStackIn, worldIn, playerIn, pos, fortune);
        }
        if (harvestedSomething |= this.harvestCrop(itemStackIn, worldIn, playerIn, origin, fortune)) {
            playerIn.func_130014_f_().func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187730_dW, playerIn.func_184176_by(), 1.0f, 1.0f);
            this.swingTool(playerIn, hand);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    protected boolean canHarvestCrop(IBlockState state) {
        boolean canHarvest = state.func_177230_c() instanceof BlockReed;
        if (state.func_177230_c() instanceof BlockCrops && ((BlockCrops)state.func_177230_c()).func_185525_y(state)) {
            canHarvest = true;
        }
        if (state.func_177230_c() instanceof BlockNetherWart && (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a) == 3) {
            canHarvest = true;
        }
        return canHarvest;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target instanceof IShearable) {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            if (this.shearEntity(stack, player.func_130014_f_(), player, (Entity)target, fortune)) {
                this.swingTool(player, hand);
                return true;
            }
        }
        return false;
    }

    protected void swingTool(EntityPlayer player, EnumHand hand) {
        player.func_184609_a(hand);
        player.func_184810_cG();
    }

    public boolean harvestCrop(ItemStack stack, World world, EntityPlayer player, BlockPos pos, int fortune) {
        TinkerToolEvent.OnScytheHarvest event;
        IBlockState state = world.func_180495_p(pos);
        boolean canHarvest = this.canHarvestCrop(state);
        if (state.func_177230_c() instanceof BlockReed && !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockReed)) {
            canHarvest = false;
        }
        if ((event = TinkerToolEvent.OnScytheHarvest.fireEvent(stack, player, world, pos, state, canHarvest)).isCanceled()) {
            return false;
        }
        if (event.getResult() == Event.Result.DENY) {
            return true;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            canHarvest = true;
        }
        if (!canHarvest) {
            return false;
        }
        if (!world.field_72995_K) {
            this.doHarvestCrop(stack, world, player, pos, fortune, state);
        }
        return true;
    }

    protected void doHarvestCrop(ItemStack stack, World world, EntityPlayer player, BlockPos pos, int fortune, IBlockState state) {
        IBlockState down;
        float chance = 1.0f;
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, state, fortune);
        chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)player);
        IPlantable seed = null;
        for (ItemStack drop : drops) {
            if (drop.func_190926_b() || !(drop.func_77973_b() instanceof IPlantable)) continue;
            seed = (IPlantable)drop.func_77973_b();
            drop.func_190918_g(1);
            if (!drop.func_190926_b()) break;
            drops.remove((Object)drop);
            break;
        }
        boolean replanted = false;
        if (seed != null && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c().canSustainPlant(down, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, seed)) {
            IBlockState crop = seed.getPlant((IBlockAccess)world, pos);
            if (crop != state) {
                world.func_175656_a(pos, seed.getPlant((IBlockAccess)world, pos));
                ToolHelper.damageTool(stack, 1, (EntityLivingBase)player);
            }
            for (ItemStack drop : drops) {
                if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
            }
            replanted = true;
        }
        if (!replanted) {
            this.breakExtraBlock(stack, player.func_130014_f_(), player, pos, pos);
        }
    }

    public boolean shearEntity(ItemStack stack, World world, EntityPlayer player, Entity entity, int fortune) {
        if (!(entity instanceof IShearable)) {
            return false;
        }
        IShearable shearable = (IShearable)entity;
        if (shearable.isShearable(stack, (IBlockAccess)world, entity.func_180425_c())) {
            if (!world.field_72995_K) {
                List drops = shearable.onSheared(stack, (IBlockAccess)world, entity.func_180425_c(), fortune);
                Random rand = world.field_73012_v;
                for (ItemStack drop : drops) {
                    EntityItem entityItem = entity.func_70099_a(drop, 1.0f);
                    if (entityItem == null) continue;
                    entityItem.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    entityItem.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    entityItem.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
            }
            ToolHelper.damageTool(stack, 1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    @Override
    protected ToolNBT buildTagData(List<slimeknights.tconstruct.library.materials.Material> materials) {
        return this.buildDefaultTag(materials);
    }
}

