/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.eventbus.Subscribe;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.world.WorldEvents;
import slimeknights.tconstruct.world.block.BlockSlimeDirt;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.block.BlockSlimeLeaves;
import slimeknights.tconstruct.world.block.BlockSlimeSapling;
import slimeknights.tconstruct.world.block.BlockSlimeVine;
import slimeknights.tconstruct.world.block.BlockTallSlimeGrass;
import slimeknights.tconstruct.world.entity.EntityBlueSlime;
import slimeknights.tconstruct.world.entity.EntityPurpleSlime;
import slimeknights.tconstruct.world.item.ItemBlockLeaves;
import slimeknights.tconstruct.world.worldgen.MagmaSlimeIslandGenerator;
import slimeknights.tconstruct.world.worldgen.MagmaSlimePoolGenerator;
import slimeknights.tconstruct.world.worldgen.SlimeIslandGenerator;
import slimeknights.tconstruct.world.worldgen.SlimePoolGenerator;

@Pulse(id="TinkerWorld", description="Everything that's found in the world and worldgen")
public class TinkerWorld
extends TinkerPulse {
    public static final String PulseId = "TinkerWorld";
    static final Logger log = Util.getLogger("TinkerWorld");
    @SidedProxy(clientSide="slimeknights.tconstruct.world.WorldClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockSlimeDirt slimeDirt;
    public static BlockSlimeGrass slimeGrass;
    public static BlockSlimeLeaves slimeLeaves;
    public static BlockTallSlimeGrass slimeGrassTall;
    public static BlockSlimeSapling slimeSapling;
    public static BlockSlimeVine slimeVineBlue1;
    public static BlockSlimeVine slimeVinePurple1;
    public static BlockSlimeVine slimeVineBlue2;
    public static BlockSlimeVine slimeVinePurple2;
    public static BlockSlimeVine slimeVineBlue3;
    public static BlockSlimeVine slimeVinePurple3;
    public static final EnumPlantType slimePlantType;

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        slimeDirt = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockSlimeDirt(), "slime_dirt");
        slimeGrass = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockSlimeGrass(), "slime_grass");
        slimeLeaves = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockSlimeLeaves(), "slime_leaves");
        slimeGrassTall = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockTallSlimeGrass(), "slime_grass_tall");
        slimeSapling = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockSlimeSapling(), "slime_sapling");
        slimeVineBlue3 = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockSlimeVine(BlockSlimeGrass.FoliageType.BLUE, null), "slime_vine_blue_end");
        slimeVineBlue2 = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockSlimeVine(BlockSlimeGrass.FoliageType.BLUE, slimeVineBlue3), "slime_vine_blue_mid");
        slimeVineBlue1 = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockSlimeVine(BlockSlimeGrass.FoliageType.BLUE, slimeVineBlue2), "slime_vine_blue");
        slimeVinePurple3 = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockSlimeVine(BlockSlimeGrass.FoliageType.PURPLE, null), "slime_vine_purple_end");
        slimeVinePurple2 = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockSlimeVine(BlockSlimeGrass.FoliageType.PURPLE, slimeVinePurple3), "slime_vine_purple_mid");
        slimeVinePurple1 = TinkerWorld.registerBlock((IForgeRegistry<Block>)registry, new BlockSlimeVine(BlockSlimeGrass.FoliageType.PURPLE, slimeVinePurple2), "slime_vine_purple");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        slimeDirt = TinkerWorld.registerEnumItemBlock((IForgeRegistry<Item>)registry, slimeDirt);
        slimeGrass = (BlockSlimeGrass)((Object)TinkerWorld.registerItemBlockProp((IForgeRegistry<Item>)registry, (ItemBlock)new ItemBlockMeta((Block)slimeGrass), BlockSlimeGrass.TYPE));
        slimeLeaves = (BlockSlimeLeaves)((Object)TinkerWorld.registerItemBlockProp((IForgeRegistry<Item>)registry, (ItemBlock)new ItemBlockLeaves((Block)slimeLeaves), BlockSlimeGrass.FOLIAGE));
        slimeGrassTall = (BlockTallSlimeGrass)((Object)TinkerWorld.registerItemBlockProp((IForgeRegistry<Item>)registry, (ItemBlock)new ItemBlockMeta((Block)slimeGrassTall), BlockTallSlimeGrass.TYPE));
        slimeSapling = (BlockSlimeSapling)((Object)TinkerWorld.registerItemBlockProp((IForgeRegistry<Item>)registry, (ItemBlock)new ItemBlockMeta((Block)slimeSapling), BlockSlimeGrass.FOLIAGE));
        slimeVineBlue3 = TinkerWorld.registerItemBlock((IForgeRegistry<Item>)registry, slimeVineBlue3);
        slimeVineBlue2 = TinkerWorld.registerItemBlock((IForgeRegistry<Item>)registry, slimeVineBlue2);
        slimeVineBlue1 = TinkerWorld.registerItemBlock((IForgeRegistry<Item>)registry, slimeVineBlue1);
        slimeVinePurple3 = TinkerWorld.registerItemBlock((IForgeRegistry<Item>)registry, slimeVinePurple3);
        slimeVinePurple2 = TinkerWorld.registerItemBlock((IForgeRegistry<Item>)registry, slimeVinePurple2);
        slimeVinePurple1 = TinkerWorld.registerItemBlock((IForgeRegistry<Item>)registry, slimeVinePurple1);
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("blueslime"), EntityBlueSlime.class, (String)Util.prefix("blueslime"), (int)1, (Object)TConstruct.instance, (int)64, (int)1, (boolean)true, (int)4714485, (int)11337716);
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("purpleslime"), EntityPurpleSlime.class, (String)Util.prefix("purpleslime"), (int)4, (Object)TConstruct.instance, (int)64, (int)1, (boolean)true, (int)6488240, (int)13860095);
        LootTableList.func_186375_a((ResourceLocation)EntityBlueSlime.LOOT_TABLE);
        LootTableList.func_186375_a((ResourceLocation)EntityPurpleSlime.LOOT_TABLE);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        proxy.registerModels();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)SlimeIslandGenerator.INSTANCE, (int)25);
        GameRegistry.registerWorldGenerator((IWorldGenerator)MagmaSlimeIslandGenerator.INSTANCE, (int)25);
        GameRegistry.registerWorldGenerator((IWorldGenerator)SlimePoolGenerator.INSTANCE, (int)25);
        GameRegistry.registerWorldGenerator((IWorldGenerator)MagmaSlimePoolGenerator.INSTANCE, (int)25);
        MinecraftForge.EVENT_BUS.register((Object)new WorldEvents());
        proxy.postInit();
        TinkerRegistry.tabWorld.setDisplayIcon(new ItemStack((Block)slimeSapling));
    }

    static {
        slimePlantType = EnumPlantType.getPlantType((String)"slime");
    }
}

