/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockSlime;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;
import slimeknights.tconstruct.world.TinkerWorld;

@Pulse(id="TinkerOredict", forced=true)
public class TinkerOredict {
    public static final String PulseId = "TinkerOredict";
    public static final String[] dyes = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
    public static final Set<Item> COOKED_MEAT = ImmutableSet.builder().add((Object)Items.field_151083_be).add((Object)Items.field_151077_bg).add((Object)Items.field_179566_aV).add((Object)Items.field_179557_bn).add((Object)Items.field_151157_am).add((Object)Items.field_179559_bp).build();

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        TinkerOredict.ensureOredict();
        TinkerOredict.registerCommon();
        TinkerOredict.registerTools();
        TinkerOredict.registerSmeltery();
        TinkerOredict.registerWorld();
        TinkerOredict.registerGadgets();
    }

    private static void ensureOredict() {
        TinkerOredict.oredict(Blocks.field_150462_ai, "workbench");
        TinkerOredict.oredict((Block)Blocks.field_150434_aF, "blockCactus");
        TinkerOredict.oredict(Blocks.field_180399_cE, "blockSlime");
        TinkerOredict.oredict(Blocks.field_150343_Z, "obsidian");
        TinkerOredict.oredict(Blocks.field_150424_aL, "netherrack");
        TinkerOredict.oredict(Blocks.field_180397_cI, "prismarine");
        TinkerOredict.oredict(Blocks.field_150395_bd, "vine");
        TinkerOredict.oredict(Blocks.field_150346_d, "dirt");
        TinkerOredict.oredict(Blocks.field_150341_Y, "blockMossy");
        TinkerOredict.oredict(new ItemStack(Blocks.field_150417_aV, 1, BlockStoneBrick.field_176250_M), "blockMossy");
        TinkerOredict.oredict(Blocks.field_150415_aT, "trapdoorWood");
        TinkerOredict.oredict(Items.field_151119_aD, "clay");
        TinkerOredict.oredict(Blocks.field_150435_aG, "blockClay");
        for (Item meat : COOKED_MEAT) {
            TinkerOredict.oredict(meat, "listAllmeatcooked");
        }
        TinkerOredict.oredict(new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE), "fish");
    }

    private static void registerCommon() {
        String dict = "slimeball";
        TinkerOredict.oredict(Items.field_151123_aH, dict + "Green");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallBlue, dict, dict + "Blue");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallPurple, dict, dict + "Purple");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallBlood, dict, dict + "Blood");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallMagma, dict, dict + "Magma");
        TinkerOredict.oredict(TinkerCommons.matSlimeBallPink, dict);
        TinkerOredict.oredictNIB(TinkerCommons.nuggetCobalt, TinkerCommons.ingotCobalt, TinkerCommons.blockCobalt, "Cobalt");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetArdite, TinkerCommons.ingotArdite, TinkerCommons.blockArdite, "Ardite");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetManyullyn, TinkerCommons.ingotManyullyn, TinkerCommons.blockManyullyn, "Manyullyn");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetKnightSlime, TinkerCommons.ingotKnightSlime, TinkerCommons.blockKnightSlime, "Knightslime");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetPigIron, TinkerCommons.ingotPigIron, TinkerCommons.blockPigIron, "Pigiron");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetAlubrass, TinkerCommons.ingotAlubrass, TinkerCommons.blockAlubrass, "Alubrass");
        TinkerOredict.oredictNIB(TinkerCommons.nuggetAlumite, TinkerCommons.ingotAlumite, TinkerCommons.blockAlumite, "Alumite");
        if (Config.registerAllCommonMetals) {
            TinkerOredict.oredictNIB(TinkerCommons.nuggetCopper, TinkerCommons.ingotCopper, TinkerCommons.blockCopper, "Copper");
            TinkerOredict.oredictNIB(TinkerCommons.nuggetTin, TinkerCommons.ingotTin, TinkerCommons.blockTin, "Tin");
            TinkerOredict.oredictNIB(TinkerCommons.nuggetAluminum, TinkerCommons.ingotAluminum, TinkerCommons.blockAluminum, "Aluminum");
            TinkerOredict.oredictNIB(TinkerCommons.nuggetBronze, TinkerCommons.ingotBronze, TinkerCommons.blockBronze, "Bronze");
            TinkerOredict.oredictNIB(TinkerCommons.nuggetSteel, TinkerCommons.ingotSteel, TinkerCommons.blockSteel, "Steel");
            TinkerOredict.oredict(TinkerCommons.oreCopper, "oreCopper");
            TinkerOredict.oredict(TinkerCommons.oreTin, "oreTin");
            TinkerOredict.oredict(TinkerCommons.oreAluminum, "oreAluminum");
        }
        String metal = "blockMetal";
        TinkerOredict.oredict(new ItemStack(Blocks.field_150339_S), metal);
        TinkerOredict.oredict(new ItemStack(Blocks.field_150340_R), metal);
        TinkerOredict.oredict(TinkerCommons.searedBrick, "ingotBrickSeared");
        dict = "slimecrystal";
        TinkerOredict.oredict(TinkerCommons.matSlimeCrystalGreen, dict, dict + "Green");
        TinkerOredict.oredict(TinkerCommons.matSlimeCrystalBlue, dict, dict + "Blue");
        TinkerOredict.oredict(TinkerCommons.matSlimeCrystalMagma, dict, dict + "Magma");
        TinkerOredict.oredict(TinkerCommons.oreCobalt, "oreCobalt");
        TinkerOredict.oredict(TinkerCommons.oreArdite, "oreArdite");
        TinkerOredict.oredict(TinkerCommons.blockClearGlass, "blockGlass");
        TinkerOredict.oredict((Block)TinkerCommons.blockClearStainedGlass, "blockGlass");
        for (int i = 0; i < 16; ++i) {
            TinkerOredict.oredict((Block)TinkerCommons.blockClearStainedGlass, i, "blockGlass" + dyes[i]);
        }
    }

    private static void oredictNIB(ItemStack nugget, ItemStack ingot, ItemStack block, String oreSuffix) {
        TinkerOredict.oredict(nugget, "nugget" + oreSuffix);
        TinkerOredict.oredict(ingot, "ingot" + oreSuffix);
        TinkerOredict.oredict(block, "block" + oreSuffix);
    }

    private static void registerTools() {
        TinkerOredict.oredict((Block)TinkerTools.toolTables, BlockToolTable.TableTypes.CraftingStation.meta, "workbench");
        TinkerOredict.oredict(TinkerCommons.matNecroticBone, "boneWithered");
        TinkerOredict.oredict(TinkerCommons.matBloodyBone, "boneBloodied");
        TinkerOredict.oredict((Item)TinkerTools.pickHead, "partPickHead");
        TinkerOredict.oredict((Item)TinkerTools.binding, "partBinding");
        TinkerOredict.oredict((Item)TinkerTools.toolRod, "partToolRod");
        TinkerOredict.oredict((Item)TinkerTools.pattern, "pattern");
    }

    private static void registerSmeltery() {
        TinkerOredict.oredict((Item)TinkerSmeltery.cast, "cast");
        TinkerOredict.oredict((Item)TinkerSmeltery.castCustom, "cast");
        TinkerOredict.oredict((Block)TinkerSmeltery.searedBlock, Short.MAX_VALUE, "blockSeared");
    }

    private static void registerWorld() {
        TinkerOredict.oredict((Block)TinkerWorld.slimeSapling, "treeSapling");
        TinkerOredict.oredict((Block)TinkerCommons.blockSlime, "blockSlime");
        TinkerOredict.oredict((Block)TinkerCommons.blockSlime, BlockSlime.SlimeType.GREEN.meta, "blockSlimeGreen");
        TinkerOredict.oredict((Block)TinkerCommons.blockSlime, BlockSlime.SlimeType.BLUE.meta, "blockSlimeBlue");
        TinkerOredict.oredict((Block)TinkerCommons.blockSlime, BlockSlime.SlimeType.BLOOD.meta, "blockSlimeRed");
        TinkerOredict.oredict((Block)TinkerCommons.blockSlimeCongealed, "blockSlimeCongealed");
        TinkerOredict.oredict((Block)TinkerWorld.slimeDirt, "blockSlimeDirt");
        TinkerOredict.oredict((Block)TinkerWorld.slimeGrass, "blockSlimeGrass");
        TinkerOredict.oredict((Block)TinkerWorld.slimeLeaves, "treeLeaves");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVineBlue1, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVineBlue2, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVineBlue3, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVinePurple1, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVinePurple2, "vine");
        TinkerOredict.oredict((Block)TinkerWorld.slimeVinePurple3, "vine");
    }

    private static void registerGadgets() {
        TinkerOredict.oredict(TinkerGadgets.stoneStick, "rodStone");
        TinkerOredict.oredict(TinkerGadgets.stoneTorch, "torch");
    }

    public static void oredict(Item item, String ... name) {
        TinkerOredict.oredict(item, Short.MAX_VALUE, name);
    }

    public static void oredict(Block block, String ... name) {
        TinkerOredict.oredict(block, Short.MAX_VALUE, name);
    }

    public static void oredict(Item item, int meta, String ... name) {
        TinkerOredict.oredict(new ItemStack(item, 1, meta), name);
    }

    public static void oredict(Block block, int meta, String ... name) {
        TinkerOredict.oredict(new ItemStack(block, 1, meta), name);
    }

    public static void oredict(ItemStack stack, String ... names) {
        if (stack != null && !stack.func_190926_b()) {
            for (String name : names) {
                OreDictionary.registerOre((String)name, (ItemStack)stack);
            }
        }
    }
}

