/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.CreativeTab;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.DryingRecipe;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerAPIException;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.MaterialEvent;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ProjectileMaterialStats;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IPattern;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.Shard;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.FluidUtil;

public final class TinkerRegistry {
    public static final Logger log = Util.getLogger("API");
    public static CreativeTab tabGeneral = new CreativeTab("TinkerGeneral", new ItemStack(Items.field_151123_aH));
    public static CreativeTab tabTools = new CreativeTab("TinkerTools", new ItemStack(Items.field_151035_b));
    public static CreativeTab tabParts = new CreativeTab("TinkerToolParts", new ItemStack(Items.field_151055_y));
    public static CreativeTab tabSmeltery = new CreativeTab("TinkerSmeltery", new ItemStack(Item.func_150898_a((Block)Blocks.field_150417_aV)));
    public static CreativeTab tabWorld = new CreativeTab("TinkerWorld", new ItemStack(Item.func_150898_a((Block)Blocks.field_180399_cE)));
    public static CreativeTab tabGadgets = new CreativeTab("TinkerGadgets", new ItemStack(Blocks.field_150335_W));
    private static final Map<String, Material> materials = new Object2ObjectLinkedOpenHashMap();
    private static final Map<String, ITrait> traits = new Object2ObjectOpenHashMap();
    private static final Map<String, ModContainer> materialRegisteredByMod = new Object2ObjectOpenHashMap();
    private static final Map<String, Map<String, ModContainer>> statRegisteredByMod = new Object2ObjectOpenHashMap();
    private static final Map<String, Map<String, ModContainer>> traitRegisteredByMod = new Object2ObjectOpenHashMap();
    private static final Set<String> cancelledMaterials = new ObjectOpenHashSet();
    private static final Set<ToolCore> tools = new ObjectLinkedOpenHashSet();
    private static final Set<IToolPart> toolParts = new ObjectLinkedOpenHashSet();
    private static final Set<ToolCore> toolStationCrafting = new ObjectLinkedOpenHashSet();
    private static final Set<ToolCore> toolForgeCrafting = new ObjectLinkedOpenHashSet();
    private static final List<ItemStack> stencilTableCrafting = new ObjectArrayList();
    private static final Set<Item> patternItems = new ObjectOpenHashSet();
    private static final Set<Item> castItems = new ObjectOpenHashSet();
    private static Shard shardItem;
    private static final Map<String, IModifier> modifiers;
    private static final Multimap<Class<? extends EntityLivingBase>, Function<EntityLivingBase, ItemStack>> headDrops;
    private static final Multimap<Class<? extends EntityLivingBase>, ItemStack> headDropsRaw;
    private static List<MeltingRecipe> meltingRegistry;
    private static List<ICastingRecipe> tableCastRegistry;
    private static List<ICastingRecipe> basinCastRegistry;
    private static List<AlloyRecipe> alloyRegistry;
    private static Map<FluidStack, Integer> smelteryFuels;
    private static Map<ResourceLocation, FluidStack> entityMeltingRegistry;
    private static List<DryingRecipe> dryingRegistry;
    private static List<MaterialIntegration> materialIntegrations;

    private TinkerRegistry() {
    }

    public static void addMaterial(Material material, IMaterialStats stats, ITrait trait) {
        TinkerRegistry.addMaterial(material, stats);
        TinkerRegistry.addMaterialTrait(material.identifier, trait, null);
    }

    public static void addMaterial(Material material, ITrait trait) {
        TinkerRegistry.addMaterial(material);
        TinkerRegistry.addMaterialTrait(material.identifier, trait, null);
    }

    public static void addMaterial(Material material, IMaterialStats stats) {
        TinkerRegistry.addMaterial(material);
        TinkerRegistry.addMaterialStats(material.identifier, stats);
    }

    public static void addMaterial(Material material) {
        MaterialEvent.MaterialRegisterEvent event;
        if (CharMatcher.whitespace().matchesAnyOf((CharSequence)material.getIdentifier())) {
            log.fatal("Could not register material \"{}\": Material identifier must not contain any spaces.", (Object)material.identifier);
            return;
        }
        if (CharMatcher.javaUpperCase().matchesAnyOf((CharSequence)material.getIdentifier())) {
            log.fatal("Could not register material \"{}\": Material identifier must be completely lowercase.", (Object)material.identifier);
            return;
        }
        if (materials.containsKey(material.identifier)) {
            int registeredPriority;
            ModContainer currentMod = Loader.instance().activeModContainer();
            String currentModId = currentMod != null ? currentMod.getModId() : "unknown";
            ModContainer registeredMod = TinkerRegistry.getTrace(material);
            String registeredModId = registeredMod != null ? registeredMod.getModId() : "unknown";
            int currentPriority = TinkerRegistry.getModPriority(currentModId);
            if (currentPriority < (registeredPriority = TinkerRegistry.getModPriority(registeredModId))) {
                log.warn("Replacing material \"{}\" with material from {} ({})", (Object)material.identifier, (Object)currentMod.getName(), (Object)currentModId);
                materials.remove(material.identifier);
                materialRegisteredByMod.remove(material.identifier);
            } else {
                log.fatal("Could not register material \"{}\" from {} ({}): It was already registered by {} ({})", (Object)material.identifier, (Object)currentMod.getName(), (Object)currentModId, (Object)registeredMod.getName(), (Object)registeredModId);
                return;
            }
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new MaterialEvent.MaterialRegisterEvent(material)))) {
            log.trace("Addition of material \"{}\" cancelled by event", (Object)material.getIdentifier());
            cancelledMaterials.add(material.getIdentifier());
            return;
        }
        if (Arrays.stream(Config.materialIgnore).anyMatch(mat -> mat.equals(material.getIdentifier()))) {
            log.trace("Addition of material \"{}\" ignored by config", (Object)material.getIdentifier());
            cancelledMaterials.add(material.getIdentifier());
            return;
        }
        materials.put(material.identifier, material);
        TinkerRegistry.putMaterialTrace(material.identifier);
    }

    public static Material getMaterial(String identifier) {
        return materials.containsKey(identifier) ? materials.get(identifier) : Material.UNKNOWN;
    }

    public static Collection<Material> getAllMaterials() {
        return ImmutableList.copyOf(materials.values());
    }

    public static void removeHiddenMaterials() {
        materials.entrySet().removeIf(entry -> ((Material)((Object)((Object)entry.getValue()))).isHidden());
    }

    public static Collection<Material> getAllMaterialsWithStats(String statType) {
        ImmutableList.Builder mats = ImmutableList.builder();
        for (Material material : materials.values()) {
            if (!material.hasStats(statType)) continue;
            mats.add((Object)material);
        }
        return mats.build();
    }

    public static void addTrait(ITrait trait) {
        if (traits.containsKey(trait.getIdentifier())) {
            return;
        }
        traits.put(trait.getIdentifier(), trait);
        ModContainer activeMod = Loader.instance().activeModContainer();
        TinkerRegistry.putTraitTrace(trait.getIdentifier(), trait, activeMod);
    }

    public static void addMaterialStats(String materialIdentifier, IMaterialStats stats) {
        if (cancelledMaterials.contains(materialIdentifier)) {
            return;
        }
        if (!materials.containsKey(materialIdentifier)) {
            log.fatal("Could not add Stats \"{}\" to \"{}\": Unknown Material", (Object)stats.getIdentifier(), (Object)materialIdentifier);
            return;
        }
        Material material = materials.get(materialIdentifier);
        TinkerRegistry.addMaterialStats(material, stats);
    }

    public static void addMaterialStats(Material material, IMaterialStats stats, IMaterialStats ... stats2) {
        TinkerRegistry.addMaterialStats(material, stats);
        for (IMaterialStats stat : stats2) {
            TinkerRegistry.addMaterialStats(material, stat);
        }
    }

    public static void addMaterialStats(Material material, IMaterialStats stats) {
        if (material == null) {
            log.fatal("Could not add Stats \"{}\": Material is null", (Object)stats.getIdentifier());
            return;
        }
        if (cancelledMaterials.contains(material.identifier)) {
            return;
        }
        String identifier = material.identifier;
        if (material.getStats(stats.getIdentifier()) != null) {
            String registeredBy = "Unknown";
            Map<String, ModContainer> matReg = statRegisteredByMod.get(identifier);
            if (matReg != null) {
                registeredBy = matReg.get(stats.getIdentifier()).getName();
            }
            log.fatal("Could not add Stats to \"{}\": Stats of type \"{}\" were already registered by {}. Use the events to modify stats.", (Object)identifier, (Object)stats.getIdentifier(), (Object)registeredBy);
            return;
        }
        if (Material.UNKNOWN.getStats(stats.getIdentifier()) == null) {
            log.fatal("Could not add Stat of type \"{}\": Default Material does not have default stats for said type. Please add default-values to the default material \"unknown\" first.", (Object)stats.getIdentifier());
            return;
        }
        MaterialEvent.StatRegisterEvent<IMaterialStats> event = new MaterialEvent.StatRegisterEvent<IMaterialStats>(material, stats);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.getResult() == Event.Result.ALLOW) {
            stats = event.newStats;
        }
        material.addStats(stats);
        ModContainer activeMod = Loader.instance().activeModContainer();
        TinkerRegistry.putStatTrace(identifier, stats, activeMod);
        if (Objects.equals(stats.getIdentifier(), "head") && !material.hasStats("projectile")) {
            TinkerRegistry.addMaterialStats(material, (IMaterialStats)new ProjectileMaterialStats());
        }
    }

    public static void addMaterialTrait(String materialIdentifier, ITrait trait, String stats) {
        if (cancelledMaterials.contains(materialIdentifier)) {
            return;
        }
        if (!materials.containsKey(materialIdentifier)) {
            log.fatal("Could not add Trait \"{}\" to \"{}\": Unknown Material", (Object)trait.getIdentifier(), (Object)materialIdentifier);
            return;
        }
        Material material = materials.get(materialIdentifier);
        TinkerRegistry.addMaterialTrait(material, trait, stats);
    }

    public static void addMaterialTrait(Material material, ITrait trait, String stats) {
        if (TinkerRegistry.checkMaterialTrait(material, trait, stats)) {
            material.addTrait(trait);
        }
    }

    public static boolean checkMaterialTrait(Material material, ITrait trait, String stats) {
        if (material == null) {
            log.fatal("Could not add Trait \"{}\": Material is null", (Object)trait.getIdentifier());
            return false;
        }
        if (cancelledMaterials.contains(material.identifier)) {
            return false;
        }
        String identifier = material.identifier;
        if (material.hasTrait(trait.getIdentifier(), stats)) {
            String registeredBy = "Unknown";
            Map<String, ModContainer> matReg = traitRegisteredByMod.get(identifier);
            if (matReg != null) {
                registeredBy = matReg.get(trait.getIdentifier()).getName();
            }
            log.fatal("Could not add Trait to \"{}\": Trait \"{}\" was already registered by {}", (Object)identifier, (Object)trait.getIdentifier(), (Object)registeredBy);
            return false;
        }
        MaterialEvent.TraitRegisterEvent<ITrait> event = new MaterialEvent.TraitRegisterEvent<ITrait>(material, trait);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            log.trace("Trait {} on {} cancelled by event", (Object)trait.getIdentifier(), (Object)material.getIdentifier());
            return false;
        }
        TinkerRegistry.addTrait(trait);
        return true;
    }

    public static ITrait getTrait(String identifier) {
        return traits.get(identifier);
    }

    public static void registerTool(ToolCore tool) {
        tools.add(tool);
        for (PartMaterialType pmt : tool.getRequiredComponents()) {
            for (IToolPart tp : pmt.getPossibleParts()) {
                TinkerRegistry.registerToolPart(tp);
            }
        }
    }

    public static Set<ToolCore> getTools() {
        return ImmutableSet.copyOf(tools);
    }

    public static void registerToolPart(IToolPart part) {
        toolParts.add(part);
        if (part instanceof Item) {
            if (part.canBeCrafted()) {
                TinkerRegistry.addPatternForItem((Item)part);
            }
            if (part.canBeCasted()) {
                TinkerRegistry.addCastForItem((Item)part);
            }
        }
    }

    public static Set<IToolPart> getToolParts() {
        return ImmutableSet.copyOf(toolParts);
    }

    public static void registerToolCrafting(ToolCore tool) {
        TinkerRegistry.registerToolStationCrafting(tool);
        TinkerRegistry.registerToolForgeCrafting(tool);
    }

    public static void registerToolStationCrafting(ToolCore tool) {
        if (new TinkerRegisterEvent.ToolStationCraftingRegisterEvent(tool).fire()) {
            toolStationCrafting.add(tool);
        } else {
            log.debug("Registration of tool station recipe " + tool.getRegistryName().toString() + " has been cancelled by event");
        }
    }

    public static Set<ToolCore> getToolStationCrafting() {
        return ImmutableSet.copyOf(toolStationCrafting);
    }

    public static void registerToolForgeCrafting(ToolCore tool) {
        if (new TinkerRegisterEvent.ToolForgeCraftingRegisterEvent(tool).fire()) {
            toolForgeCrafting.add(tool);
        } else {
            log.debug("Registration of tool forge recipe " + tool.getRegistryName().toString() + " has been cancelled by event");
        }
    }

    public static Set<ToolCore> getToolForgeCrafting() {
        return ImmutableSet.copyOf(toolForgeCrafting);
    }

    public static void registerStencilTableCrafting(ItemStack stencil) {
        if (!(stencil.func_77973_b() instanceof IPattern)) {
            log.fatal("Stencil Table Crafting has to be a pattern ({})", (Object)stencil);
            return;
        }
        if (new TinkerRegisterEvent.StencilTableCraftingRegisterEvent(stencil).fire()) {
            stencilTableCrafting.add(stencil);
        } else {
            log.debug("Registration of stencil table stencil " + stencil + " has been cancelled by event");
        }
    }

    public static List<ItemStack> getStencilTableCrafting() {
        return ImmutableList.copyOf(stencilTableCrafting);
    }

    public static void setShardItem(Shard shard) {
        if (shard == null) {
            return;
        }
        shardItem = shard;
    }

    public static Shard getShard() {
        return shardItem;
    }

    public static ItemStack getShard(Material material) {
        ItemStack out = material.getShard();
        if (out.func_190926_b()) {
            out = shardItem.getItemstackWithMaterial(material);
        }
        return out;
    }

    public static void addPatternForItem(Item item) {
        patternItems.add(item);
    }

    public static void addCastForItem(Item item) {
        castItems.add(item);
    }

    public static Collection<Item> getPatternItems() {
        return ImmutableList.copyOf(patternItems);
    }

    public static Collection<Item> getCastItems() {
        return ImmutableList.copyOf(castItems);
    }

    public static void registerModifier(IModifier modifier) {
        TinkerRegistry.registerModifierAlias(modifier, modifier.getIdentifier());
    }

    public static void registerModifierAlias(IModifier modifier, String alias) {
        if (modifiers.containsKey(alias)) {
            log.fatal("Trying to register a modifier with the name " + alias + " but it already is registered");
            return;
        }
        if (new TinkerRegisterEvent.ModifierRegisterEvent(modifier).fire()) {
            modifiers.put(alias, modifier);
        } else {
            log.debug("Registration of modifier " + alias + " has been cancelled by event");
        }
    }

    public static IModifier getModifier(String identifier) {
        return modifiers.get(identifier);
    }

    public static Collection<IModifier> getAllModifiers() {
        return ImmutableList.copyOf(modifiers.values());
    }

    public static void registerHeadDropForAll(Class<? extends EntityLivingBase> clazz, ItemStack head) {
        for (EntityEntry entry : ForgeRegistries.ENTITIES) {
            Class entityClass = entry.getEntityClass();
            if (!clazz.isAssignableFrom(entityClass)) continue;
            TinkerRegistry.registerHeadDrop((Class<? extends EntityLivingBase>)entityClass, head);
        }
    }

    public static void registerHeadDrop(Class<? extends EntityLivingBase> clazz, Function<EntityLivingBase, ItemStack> callback) {
        headDrops.put(clazz, callback);
        log.info("Registered head drop for {}", (Object)clazz.getSimpleName());
    }

    public static void registerHeadDrop(Class<? extends EntityLivingBase> clazz, ItemStack head) {
        ItemStack safeStack = head.func_77946_l();
        TinkerRegistry.registerHeadDrop(clazz, (EntityLivingBase e) -> safeStack);
        headDropsRaw.put(clazz, (Object)head);
    }

    public static Collection<ItemStack> getHeadDrop(EntityLivingBase entity) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Map.Entry entry : headDrops.entries()) {
            ItemStack stack;
            if (!((Class)entry.getKey()).isAssignableFrom(entity.getClass()) || (stack = (ItemStack)((Function)entry.getValue()).apply(entity)).func_190926_b()) continue;
            drops.add(stack.func_77946_l());
        }
        return drops;
    }

    public static Map<Class<? extends EntityLivingBase>, Collection<ItemStack>> getAllSeveringRecipes() {
        return headDropsRaw.asMap();
    }

    public static void registerMelting(Item item, Fluid fluid, int amount) {
        ItemStack stack = new ItemStack(item, 1, Short.MAX_VALUE);
        TinkerRegistry.registerMelting(new MeltingRecipe((RecipeMatch)new RecipeMatch.Item(stack, 1, amount), fluid));
    }

    public static void registerMelting(Block block, Fluid fluid, int amount) {
        ItemStack stack = new ItemStack(block, 1, Short.MAX_VALUE);
        TinkerRegistry.registerMelting(new MeltingRecipe((RecipeMatch)new RecipeMatch.Item(stack, 1, amount), fluid));
    }

    public static void registerMelting(ItemStack stack, Fluid fluid, int amount) {
        TinkerRegistry.registerMelting(new MeltingRecipe((RecipeMatch)new RecipeMatch.ItemCombination(amount, new ItemStack[]{stack}), fluid));
    }

    public static void registerMelting(String oredict, Fluid fluid, int amount) {
        TinkerRegistry.registerMelting(new MeltingRecipe((RecipeMatch)new RecipeMatch.Oredict(oredict, 1, amount), fluid));
    }

    public static void registerMelting(MeltingRecipe recipe) {
        if (Arrays.stream(Config.fluidIgnore).anyMatch(f -> f.equals(recipe.output.getFluid().getName()))) {
            return;
        }
        if (new TinkerRegisterEvent.MeltingRegisterEvent(recipe).fire()) {
            meltingRegistry.add(recipe);
        } else {
            try {
                String input = recipe.input.getInputs().stream().findFirst().map(ItemStack::func_77977_a).orElse("?");
                log.debug("Registration of melting recipe for " + recipe.getResult().getUnlocalizedName() + " from " + input + " has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging melting event", (Throwable)e);
            }
        }
    }

    public static MeltingRecipe getMelting(ItemStack stack) {
        for (MeltingRecipe recipe : meltingRegistry) {
            if (!recipe.matches(stack)) continue;
            return recipe;
        }
        return null;
    }

    public static List<MeltingRecipe> getAllMeltingRecipies() {
        return ImmutableList.copyOf(meltingRegistry);
    }

    public static void registerAlloy(FluidStack result, FluidStack ... inputs) {
        if (result.amount < 1) {
            log.fatal("Alloy Recipe: Resulting alloy {} has to have an amount ({})", (Object)result.getLocalizedName(), (Object)result.amount);
            return;
        }
        if (inputs.length < 2) {
            log.fatal("Alloy Recipe: Alloy for {} must consist of at least 2 liquids", (Object)result.getLocalizedName());
            return;
        }
        TinkerRegistry.registerAlloy(new AlloyRecipe(result, inputs));
    }

    public static void registerAlloy(AlloyRecipe recipe) {
        if (new TinkerRegisterEvent.AlloyRegisterEvent(recipe).fire()) {
            alloyRegistry.add(recipe);
        } else {
            try {
                String input = recipe.getFluids().stream().map(FluidStack::getUnlocalizedName).collect(Collectors.joining(", "));
                String output = recipe.getResult().getUnlocalizedName();
                log.debug("Registration of alloy recipe for " + output + " from [" + input + "] has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging alloy event", (Throwable)e);
            }
        }
    }

    public static List<AlloyRecipe> getAlloys() {
        return ImmutableList.copyOf(alloyRegistry);
    }

    public static void registerTableCasting(ItemStack output, ItemStack cast, Fluid fluid, int amount) {
        if (Arrays.stream(Config.fluidIgnore).anyMatch(f -> f.equals(fluid.getName()))) {
            return;
        }
        RecipeMatch rm = null;
        if (cast != ItemStack.field_190927_a) {
            rm = RecipeMatch.ofNBT((ItemStack)cast);
        }
        TinkerRegistry.registerTableCasting(new CastingRecipe(output, rm, fluid, amount));
    }

    public static void registerTableCasting(ICastingRecipe recipe) {
        if (new TinkerRegisterEvent.TableCastingRegisterEvent(recipe).fire()) {
            tableCastRegistry.add(recipe);
        } else {
            try {
                String output = Optional.ofNullable(recipe.getResult(ItemStack.field_190927_a, FluidRegistry.WATER)).map(ItemStack::func_77977_a).orElse("Unknown");
                log.debug("Registration of table casting recipe for " + output + " has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging table casting event", (Throwable)e);
            }
        }
    }

    public static ICastingRecipe getTableCasting(ItemStack cast, Fluid fluid) {
        for (ICastingRecipe recipe : tableCastRegistry) {
            if (!recipe.matches(cast, fluid)) continue;
            return recipe;
        }
        return null;
    }

    public static List<ICastingRecipe> getAllTableCastingRecipes() {
        return ImmutableList.copyOf(tableCastRegistry);
    }

    public static void registerBasinCasting(ItemStack output, ItemStack cast, Fluid fluid, int amount) {
        if (Arrays.stream(Config.fluidIgnore).anyMatch(f -> f.equals(fluid.getName()))) {
            return;
        }
        RecipeMatch rm = null;
        if (!cast.func_190926_b()) {
            rm = RecipeMatch.ofNBT((ItemStack)cast);
        }
        TinkerRegistry.registerBasinCasting(new CastingRecipe(output, rm, fluid, amount));
    }

    public static void registerBasinCasting(ICastingRecipe recipe) {
        if (new TinkerRegisterEvent.BasinCastingRegisterEvent(recipe).fire()) {
            basinCastRegistry.add(recipe);
        } else {
            try {
                String output = Optional.ofNullable(recipe.getResult(ItemStack.field_190927_a, FluidRegistry.WATER)).map(ItemStack::func_77977_a).orElse("Unknown");
                log.debug("Registration of basin casting recipe for " + output + " has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging basin casting event", (Throwable)e);
            }
        }
    }

    public static ICastingRecipe getBasinCasting(ItemStack cast, Fluid fluid) {
        for (ICastingRecipe recipe : basinCastRegistry) {
            if (!recipe.matches(cast, fluid)) continue;
            return recipe;
        }
        return null;
    }

    public static List<ICastingRecipe> getAllBasinCastingRecipes() {
        return ImmutableList.copyOf(basinCastRegistry);
    }

    public static void registerSmelteryFuel(FluidStack fluidStack, int fuelDuration) {
        if (new TinkerRegisterEvent.SmelteryFuelRegisterEvent(fluidStack, fuelDuration).fire()) {
            smelteryFuels.put(fluidStack, fuelDuration);
        } else {
            try {
                String input = fluidStack.getUnlocalizedName();
                log.debug("Registration of smeltery fuel " + input + " has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging smeltery fuel event", (Throwable)e);
            }
        }
    }

    public static boolean isSmelteryFuel(FluidStack in) {
        for (Map.Entry<FluidStack, Integer> entry : smelteryFuels.entrySet()) {
            if (!entry.getKey().isFluidEqual(in)) continue;
            return true;
        }
        return false;
    }

    public static int consumeSmelteryFuel(FluidStack in) {
        for (Map.Entry<FluidStack, Integer> entry : smelteryFuels.entrySet()) {
            if (!entry.getKey().isFluidEqual(in)) continue;
            FluidStack fuel = entry.getKey();
            int out = entry.getValue();
            if (in.amount < fuel.amount) {
                float coeff = (float)in.amount / (float)fuel.amount;
                out = Math.round(coeff * (float)in.amount);
                in.amount = 0;
            } else {
                in.amount -= fuel.amount;
            }
            return out;
        }
        return 0;
    }

    public static Collection<FluidStack> getSmelteryFuels() {
        return ImmutableSet.copyOf(smelteryFuels.keySet());
    }

    public static void registerEntityMelting() {
        for (String entry : Config.entityMelting) {
            ResourceLocation entityLocation;
            int amount;
            String fluidName;
            String subtypes;
            String entityRL;
            block10: {
                String[] parts = entry.split(";");
                if (parts.length != 4) {
                    log.error("Invalid entity melting entry: {}", (Object)entry);
                    continue;
                }
                entityRL = parts[0];
                subtypes = parts[1];
                fluidName = parts[2];
                try {
                    amount = Integer.parseInt(parts[3]);
                }
                catch (NumberFormatException e) {
                    log.error("Invalid fluid amount in entity melting entry: {}", (Object)entry);
                    continue;
                }
                try {
                    entityLocation = new ResourceLocation(entityRL);
                    if (!Loader.isModLoaded((String)entityLocation.func_110624_b())) {
                    }
                    break block10;
                }
                catch (Exception e) {
                    log.error("Invalid entity resource location: {}", (Object)entityRL);
                }
                continue;
            }
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entityLocation);
            if (entityEntry == null) {
                log.error("Entity not found for melting: {}", (Object)entityRL);
                continue;
            }
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            if (fluid == null) {
                log.error("Fluid not found for entity melting: {}", (Object)fluidName);
                continue;
            }
            Class entityClass = entityEntry.getEntityClass();
            FluidStack fluidStack = new FluidStack(fluid, amount);
            if (subtypes.equals("true")) {
                TinkerRegistry.registerEntityMeltingForAll(entityClass, fluidStack);
                continue;
            }
            TinkerRegistry.registerEntityMelting(entityClass, fluidStack);
        }
    }

    public static void registerEntityMeltingForAll(Class<? extends Entity> clazz, FluidStack liquid) {
        for (EntityEntry entry : ForgeRegistries.ENTITIES) {
            Class entityClass = entry.getEntityClass();
            if (!clazz.isAssignableFrom(entityClass)) continue;
            TinkerRegistry.registerEntityMelting(entityClass, liquid);
        }
    }

    public static void registerEntityMelting(Class<? extends Entity> clazz, FluidStack liquid) {
        ResourceLocation name = EntityList.func_191306_a(clazz);
        if (name == null) {
            log.fatal("Entity Melting: Entity {} is not registered in the EntityList", (Object)clazz.getSimpleName());
            return;
        }
        TinkerRegisterEvent.EntityMeltingRegisterEvent event = new TinkerRegisterEvent.EntityMeltingRegisterEvent(clazz, liquid);
        if (event.fire()) {
            entityMeltingRegistry.put(name, event.getNewFluidStack());
        } else {
            try {
                String output = liquid.getUnlocalizedName();
                log.debug("Registration of entity melting for " + clazz.getName() + " into " + output + " has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging entity melting event", (Throwable)e);
            }
        }
        log.info("Registered entity melting for {} into {} mB of {}", (Object)clazz.getSimpleName(), (Object)liquid.amount, (Object)liquid.getLocalizedName());
    }

    public static FluidStack getMeltingForEntity(Entity entity) {
        ResourceLocation name = EntityList.func_191301_a((Entity)entity);
        FluidStack fluidStack = entityMeltingRegistry.get(name);
        return Optional.ofNullable(fluidStack).map(FluidUtil::getValidFluidStackOrNull).orElse(null);
    }

    public static Map<ResourceLocation, FluidStack> getAllEntityMeltingRecipes() {
        return ImmutableMap.copyOf(entityMeltingRegistry);
    }

    public static List<DryingRecipe> getAllDryingRecipes() {
        return ImmutableList.copyOf(dryingRegistry);
    }

    public static void registerDryingRecipe(ItemStack input, ItemStack output, int time) {
        if (output.func_190926_b() || input.func_190926_b()) {
            return;
        }
        TinkerRegistry.addDryingRecipe(new DryingRecipe((RecipeMatch)new RecipeMatch.Item(input, 1), output, time));
    }

    public static void registerDryingRecipe(Item input, ItemStack output, int time) {
        if (output.func_190926_b() || input == null) {
            return;
        }
        ItemStack stack = new ItemStack(input, 1, Short.MAX_VALUE);
        TinkerRegistry.addDryingRecipe(new DryingRecipe((RecipeMatch)new RecipeMatch.Item(stack, 1), output, time));
    }

    public static void registerDryingRecipe(Item input, Item output, int time) {
        if (output == null || input == null) {
            return;
        }
        ItemStack stack = new ItemStack(input, 1, Short.MAX_VALUE);
        TinkerRegistry.addDryingRecipe(new DryingRecipe((RecipeMatch)new RecipeMatch.Item(stack, 1), new ItemStack(output), time));
    }

    public static void registerDryingRecipe(Block input, Block output, int time) {
        if (output == null || input == null) {
            return;
        }
        ItemStack stack = new ItemStack(input, 1, Short.MAX_VALUE);
        TinkerRegistry.addDryingRecipe(new DryingRecipe((RecipeMatch)new RecipeMatch.Item(stack, 1), new ItemStack(output), time));
    }

    public static void registerDryingRecipe(String oredict, ItemStack output, int time) {
        if (output.func_190926_b() || oredict == null) {
            return;
        }
        TinkerRegistry.addDryingRecipe(new DryingRecipe((RecipeMatch)new RecipeMatch.Oredict(oredict, 1), output, time));
    }

    public static void addDryingRecipe(DryingRecipe recipe) {
        if (new TinkerRegisterEvent.DryingRackRegisterEvent(recipe).fire()) {
            dryingRegistry.add(recipe);
        } else {
            try {
                String input = recipe.input.getInputs().stream().findFirst().map(ItemStack::func_77977_a).orElse("?");
                String output = recipe.getResult().func_77977_a();
                log.debug("Registration of drying rack recipe for " + output + " from " + input + " has been cancelled by event");
            }
            catch (Exception e) {
                log.error("Error when logging drying rack event", (Throwable)e);
            }
        }
    }

    public static int getDryingTime(ItemStack input) {
        for (DryingRecipe r : dryingRegistry) {
            if (!r.matches(input)) continue;
            return r.getTime();
        }
        return -1;
    }

    public static ItemStack getDryingResult(ItemStack input) {
        for (DryingRecipe r : dryingRegistry) {
            if (!r.matches(input)) continue;
            return r.getResult();
        }
        return ItemStack.field_190927_a;
    }

    public static MaterialIntegration integrate(Material material) {
        return TinkerRegistry.integrate(new MaterialIntegration(material));
    }

    public static MaterialIntegration integrate(Material material, Fluid fluid) {
        return TinkerRegistry.integrate(new MaterialIntegration(material, fluid));
    }

    public static MaterialIntegration integrate(Material material, String oreRequirement) {
        MaterialIntegration materialIntegration = new MaterialIntegration(oreRequirement, material, null, null);
        materialIntegration.setRepresentativeItem(oreRequirement);
        return TinkerRegistry.integrate(materialIntegration);
    }

    public static MaterialIntegration integrate(Material material, Fluid fluid, String oreSuffix) {
        return TinkerRegistry.integrate(new MaterialIntegration(material, fluid, oreSuffix));
    }

    public static MaterialIntegration integrate(Fluid fluid, String oreSuffix) {
        return TinkerRegistry.integrate(new MaterialIntegration(null, fluid, oreSuffix));
    }

    public static MaterialIntegration integrate(MaterialIntegration materialIntegration) {
        MaterialEvent.IntegrationEvent event = new MaterialEvent.IntegrationEvent(materialIntegration.material, materialIntegration);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            log.debug("Registration of material integration for material " + (Object)((Object)materialIntegration.material) + " has been cancelled by event");
        } else {
            materialIntegrations.add(materialIntegration);
        }
        return materialIntegration;
    }

    public static List<MaterialIntegration> getMaterialIntegrations() {
        return ImmutableList.copyOf(materialIntegrations);
    }

    static int getModPriority(String modId) {
        for (int i = 0; i < Config.materialPriorities.length; ++i) {
            if (!Config.materialPriorities[i].equals(modId)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    static void putMaterialTrace(String materialIdentifier) {
        ModContainer activeMod = Loader.instance().activeModContainer();
        materialRegisteredByMod.put(materialIdentifier, activeMod);
    }

    static void putStatTrace(String materialIdentifier, IMaterialStats stats, ModContainer trace) {
        if (!statRegisteredByMod.containsKey(materialIdentifier)) {
            statRegisteredByMod.put(materialIdentifier, new HashMap());
        }
        statRegisteredByMod.get(materialIdentifier).put(stats.getIdentifier(), trace);
    }

    static void putTraitTrace(String materialIdentifier, ITrait trait, ModContainer trace) {
        if (!traitRegisteredByMod.containsKey(materialIdentifier)) {
            traitRegisteredByMod.put(materialIdentifier, new HashMap());
        }
        traitRegisteredByMod.get(materialIdentifier).put(trait.getIdentifier(), trace);
    }

    public static ModContainer getTrace(Material material) {
        return materialRegisteredByMod.get(material.identifier);
    }

    private static void error(String message, Object ... params) {
        throw new TinkerAPIException(String.format(message, params));
    }

    static {
        modifiers = new Object2ObjectOpenHashMap();
        headDrops = ArrayListMultimap.create();
        headDropsRaw = ArrayListMultimap.create();
        meltingRegistry = new ObjectArrayList();
        tableCastRegistry = new ObjectArrayList();
        basinCastRegistry = new ObjectArrayList();
        alloyRegistry = new ObjectArrayList();
        smelteryFuels = new Object2IntOpenHashMap();
        entityMeltingRegistry = new Object2ObjectOpenHashMap();
        dryingRegistry = new ObjectArrayList();
        materialIntegrations = new ArrayList<MaterialIntegration>();
    }
}

