/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.materials;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;

public class BowStringMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_Multiplier = "stat.bowstring.modifier.name";
    public static final String LOC_MultiplierDesc = "stat.bowstring.modifier.desc";
    public static final String COLOR_Modifier = HandleMaterialStats.COLOR_Modifier;
    public final float modifier;

    public BowStringMaterialStats(float modifier) {
        super("bowstring");
        this.modifier = modifier;
    }

    @Override
    public List<String> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        if (this.modifier != 0.0f) {
            info.add(BowStringMaterialStats.formatModifier(this.modifier));
        }
        return info;
    }

    @Override
    public List<String> getLocalizedDesc() {
        ArrayList info = Lists.newArrayList();
        if (this.modifier != 0.0f) {
            info.add(Util.translate(LOC_MultiplierDesc, new Object[0]));
        }
        return info;
    }

    public static String formatModifier(float quality) {
        return BowStringMaterialStats.formatNumber(LOC_Multiplier, COLOR_Modifier, quality);
    }
}

