/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entitymelting;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.plugin.jei.entitymelting.EntityMeltingRecipeWrapper;

public class EntityMeltingRecipeCategory
implements IRecipeCategory<EntityMeltingRecipeWrapper> {
    public static String CATEGORY = Util.prefix("entitymelting");
    public static ResourceLocation background_loc = Util.getResource("textures/gui/jei/smeltery2.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable tankOverlay;

    public EntityMeltingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(background_loc, 0, 0, 150, 62);
        this.icon = guiHelper.createDrawable(background_loc, 174, 0, 16, 16);
        this.tankOverlay = guiHelper.createDrawable(background_loc, 150, 33, 16, 16);
    }

    @Nonnull
    public String getUid() {
        return CATEGORY;
    }

    @Nonnull
    public String getTitle() {
        return Util.translate("gui.jei.entitymelting.title", new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, EntityMeltingRecipeWrapper recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        fluids.addTooltipCallback((slotIndex, input, fluid, text) -> {
            if (slotIndex == 0) {
                String ingredientName = (String)text.get(0);
                String modName = (String)text.get(text.size() - 1);
                text.clear();
                text.add(ingredientName);
                int amount = fluid.amount;
                GuiUtil.calcLiquidText(amount, 1, Util.translate("gui.jei.smeltery_damage.info", new Object[0]), text);
                text.add(modName);
            } else {
                GuiUtil.onFluidTooltip(slotIndex, input, fluid, text);
            }
        });
        fluids.init(0, false, 115, 11, 16, 32, recipe.outputAmount, false, null);
        fluids.set(ingredients);
        fluids.init(1, false, 75, 43, 16, 16, 1000, false, this.tankOverlay);
        fluids.set(1, recipe.fuels);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return ImmutableList.of();
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getModName() {
        return "Tinkers' Antique";
    }
}

