/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entitymelting;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.EntityMeltingRecipe;
import slimeknights.tconstruct.library.TinkerRegistry;

public class EntityMeltingRecipeWrapper
implements IRecipeWrapper {
    protected double renderScale = -1.0;
    protected final ResourceLocation entity;
    protected final List<FluidStack> outputs;
    protected final List<FluidStack> fuels;
    protected final List<List<ItemStack>> inputs;
    private String configStr;
    private double configScale;
    private World curWorld;
    private EntityLivingBase entityInst;
    private boolean entityErrored = false;
    public int outputAmount;

    public EntityMeltingRecipeWrapper(EntityMeltingRecipe recipe) {
        this.entity = recipe.getEntity();
        FluidStack result = recipe.getResultStack();
        this.outputAmount = result.amount;
        this.outputs = ImmutableList.of((Object)result);
        this.inputs = ImmutableList.of((Object)ImmutableList.of((Object)recipe.spawnEgg));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (FluidStack fs : TinkerRegistry.getSmelteryFuels()) {
            fs = fs.copy();
            fs.amount = 1000;
            builder.add((Object)fs);
        }
        this.fuels = builder.build();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutputs(FluidStack.class, this.outputs);
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (minecraft.field_71441_e != null && minecraft.field_71441_e != this.curWorld) {
            this.curWorld = minecraft.field_71441_e;
            if (this.entityInst == null && !this.entityErrored) {
                try {
                    Class<EntityLivingBase> entityClass = EntityList.getClass((ResourceLocation)this.entity).asSubclass(EntityLivingBase.class);
                    this.entityInst = entityClass.getConstructor(World.class).newInstance(minecraft.field_71441_e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.entityErrored = true;
                }
            }
        }
        if (this.entityInst != null) {
            this.entityInst.field_70737_aN = Minecraft.func_71386_F() / 500L % 4L == 0L ? 100 : 0;
            if (this.renderScale < 0.0) {
                double scaleFact;
                double width = this.entityInst.field_70130_N;
                double height = this.entityInst.field_70131_O;
                if (width > height) {
                    scaleFact = 13.0;
                    this.renderScale = scaleFact / width;
                } else {
                    scaleFact = 32.0;
                    this.renderScale = scaleFact / height;
                }
            }
            for (String scale : Config.entityJEIRendererTransformation) {
                String[] split = scale.split(";");
                if (this.configStr == scale || split.length != 2 || !this.entity.toString().equalsIgnoreCase(split[0])) continue;
                try {
                    this.configScale = Double.parseDouble(split[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.configStr = scale;
                break;
            }
            int x = 35;
            int y = 40;
            GlStateManager.func_179126_j();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            if (this.configStr != null) {
                GlStateManager.func_179139_a((double)this.configScale, (double)this.configScale, (double)this.configScale);
            }
            GuiInventory.func_147046_a((int)0, (int)0, (int)((int)Math.round(this.renderScale)), (float)-100.0f, (float)0.0f, (EntityLivingBase)this.entityInst);
            GlStateManager.func_179121_F();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        int x = 80 - minecraft.field_71466_p.func_78256_a("-") / 2;
        minecraft.field_71466_p.func_175063_a("-", (float)x, 7.0f, Color.red.getRGB());
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX > 21 && mouseY > 5 && mouseX < 49 && mouseY < 41 && this.entityInst != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.entityInst.func_70005_c_());
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(this.entity.func_110624_b());
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                list.add(TextFormatting.DARK_GRAY + this.entity.toString());
            }
            list.add(TextFormatting.BLUE + "" + TextFormatting.ITALIC + (mod == null ? "Unknown" : mod.getName()));
            return list;
        }
        return ImmutableList.of();
    }
}

