/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.Subscribe;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.mantle.util.RecipeMatchRegistry;
import slimeknights.tconstruct.TinkerIntegration;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.BucketCastingRecipe;
import slimeknights.tconstruct.library.smeltery.Cast;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.smeltery.PreferenceCastingRecipe;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.shared.block.BlockSlime;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.smeltery.block.BlockChannel;
import slimeknights.tconstruct.smeltery.block.BlockFaucet;
import slimeknights.tconstruct.smeltery.block.BlockSeared;
import slimeknights.tconstruct.smeltery.block.BlockSearedFurnaceController;
import slimeknights.tconstruct.smeltery.block.BlockSearedGlass;
import slimeknights.tconstruct.smeltery.block.BlockSearedLadder;
import slimeknights.tconstruct.smeltery.block.BlockSearedSlab;
import slimeknights.tconstruct.smeltery.block.BlockSearedSlab2;
import slimeknights.tconstruct.smeltery.block.BlockSearedStairs;
import slimeknights.tconstruct.smeltery.block.BlockSmelteryController;
import slimeknights.tconstruct.smeltery.block.BlockSmelteryIO;
import slimeknights.tconstruct.smeltery.block.BlockTank;
import slimeknights.tconstruct.smeltery.block.BlockTinkerTankController;
import slimeknights.tconstruct.smeltery.item.CastCustom;
import slimeknights.tconstruct.smeltery.item.ItemChannel;
import slimeknights.tconstruct.smeltery.item.ItemTank;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingBasin;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingTable;
import slimeknights.tconstruct.smeltery.tileentity.TileChannel;
import slimeknights.tconstruct.smeltery.tileentity.TileDrain;
import slimeknights.tconstruct.smeltery.tileentity.TileFaucet;
import slimeknights.tconstruct.smeltery.tileentity.TileSearedFurnace;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;
import slimeknights.tconstruct.smeltery.tileentity.TileTinkerTank;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.world.TinkerWorld;

@Pulse(id="TinkerSmeltery", description="The smeltery and items needed for it")
public class TinkerSmeltery
extends TinkerPulse {
    public static final String PulseId = "TinkerSmeltery";
    public static final Logger log = Util.getLogger("TinkerSmeltery");
    @SidedProxy(clientSide="slimeknights.tconstruct.smeltery.SmelteryClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockSeared searedBlock;
    public static BlockSmelteryController smelteryController;
    public static BlockTank searedTank;
    public static BlockFaucet faucet;
    public static BlockChannel channel;
    public static BlockCasting castingBlock;
    public static BlockSmelteryIO smelteryIO;
    public static BlockSearedGlass searedGlass;
    public static BlockSearedLadder searedLadder;
    public static Block searedFurnaceController;
    public static Block tinkerTankController;
    public static BlockSearedSlab searedSlab;
    public static BlockSearedSlab2 searedSlab2;
    public static Block searedStairsStone;
    public static Block searedStairsCobble;
    public static Block searedStairsPaver;
    public static Block searedStairsBrick;
    public static Block searedStairsBrickCracked;
    public static Block searedStairsBrickFancy;
    public static Block searedStairsBrickSquare;
    public static Block searedStairsBrickTriangle;
    public static Block searedStairsBrickSmall;
    public static Block searedStairsRoad;
    public static Block searedStairsTile;
    public static Block searedStairsCreeper;
    public static Cast cast;
    public static CastCustom castCustom;
    public static Cast clayCast;
    public static ItemStack castIngot;
    public static ItemStack castNugget;
    public static ItemStack castGem;
    public static ItemStack castShard;
    public static ItemStack castPlate;
    public static ItemStack castGear;
    private static Map<Fluid, Set<Pair<String, Integer>>> knownOreFluids;
    public static List<FluidStack> castCreationFluids;
    public static List<FluidStack> clayCreationFluids;
    public static ImmutableSet<Block> validSmelteryBlocks;
    public static ImmutableSet<Block> searedStairsSlabs;
    public static ImmutableSet<Block> validTinkerTankBlocks;
    public static ImmutableSet<Block> validTinkerTankFloorBlocks;
    public static List<ItemStack> meltingBlacklist;

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        searedBlock = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSeared(), "seared");
        smelteryController = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSmelteryController(), "smeltery_controller");
        searedTank = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockTank(), "seared_tank");
        faucet = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockFaucet(), "faucet");
        channel = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockChannel(), "channel");
        castingBlock = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockCasting(), "casting");
        smelteryIO = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSmelteryIO(), "smeltery_io");
        searedGlass = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSearedGlass(), "seared_glass");
        searedLadder = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSearedLadder(), "seared_ladder");
        searedFurnaceController = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSearedFurnaceController(), "seared_furnace_controller");
        tinkerTankController = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockTinkerTankController(), "tinker_tank_controller");
        searedSlab = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSearedSlab(), "seared_slab");
        searedSlab2 = TinkerSmeltery.registerBlock((IForgeRegistry<Block>)registry, new BlockSearedSlab2(), "seared_slab2");
        searedStairsStone = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.STONE, "seared_stairs_stone");
        searedStairsCobble = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.COBBLE, "seared_stairs_cobble");
        searedStairsPaver = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.PAVER, "seared_stairs_paver");
        searedStairsBrick = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK, "seared_stairs_brick");
        searedStairsBrickCracked = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK_CRACKED, "seared_stairs_brick_cracked");
        searedStairsBrickFancy = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK_FANCY, "seared_stairs_brick_fancy");
        searedStairsBrickSquare = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK_SQUARE, "seared_stairs_brick_square");
        searedStairsBrickTriangle = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK_TRIANGLE, "seared_stairs_brick_triangle");
        searedStairsBrickSmall = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.BRICK_SMALL, "seared_stairs_brick_small");
        searedStairsRoad = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.ROAD, "seared_stairs_road");
        searedStairsTile = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.TILE, "seared_stairs_tile");
        searedStairsCreeper = TinkerSmeltery.registerBlockSearedStairsFrom((IForgeRegistry<Block>)registry, searedBlock, BlockSeared.SearedType.CREEPER, "seared_stairs_creeper");
        TinkerSmeltery.registerTE(TileSmeltery.class, "smeltery_controller");
        TinkerSmeltery.registerTE(TileSmelteryComponent.class, "smeltery_component");
        TinkerSmeltery.registerTE(TileTank.class, "tank");
        TinkerSmeltery.registerTE(TileFaucet.class, "faucet");
        TinkerSmeltery.registerTE(TileChannel.class, "channel");
        TinkerSmeltery.registerTE(TileCastingTable.class, "casting_table");
        TinkerSmeltery.registerTE(TileCastingBasin.class, "casting_basin");
        TinkerSmeltery.registerTE(TileDrain.class, "smeltery_drain");
        TinkerSmeltery.registerTE(TileSearedFurnace.class, "seared_furnace");
        TinkerSmeltery.registerTE(TileTinkerTank.class, "tinker_tank");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        searedBlock = TinkerSmeltery.registerEnumItemBlock((IForgeRegistry<Item>)registry, searedBlock);
        smelteryController = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, smelteryController);
        searedTank = (BlockTank)TinkerSmeltery.registerItemBlockProp((IForgeRegistry<Item>)registry, (ItemBlock)new ItemTank((Block)searedTank), BlockTank.TYPE);
        faucet = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, faucet);
        channel = (BlockChannel)TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, (ItemBlock)new ItemChannel((Block)channel));
        castingBlock = (BlockCasting)TinkerSmeltery.registerItemBlockProp((IForgeRegistry<Item>)registry, (ItemBlock)new ItemBlockMeta((Block)castingBlock), BlockCasting.TYPE);
        smelteryIO = TinkerSmeltery.registerEnumItemBlock((IForgeRegistry<Item>)registry, smelteryIO);
        searedGlass = TinkerSmeltery.registerEnumItemBlock((IForgeRegistry<Item>)registry, searedGlass);
        searedLadder = TinkerSmeltery.registerEnumItemBlock((IForgeRegistry<Item>)registry, searedLadder);
        searedFurnaceController = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedFurnaceController);
        tinkerTankController = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, tinkerTankController);
        searedSlab = TinkerSmeltery.registerEnumItemBlockSlab((IForgeRegistry<Item>)registry, searedSlab);
        searedSlab2 = TinkerSmeltery.registerEnumItemBlockSlab((IForgeRegistry<Item>)registry, searedSlab2);
        searedStairsStone = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsStone);
        searedStairsCobble = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsCobble);
        searedStairsPaver = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsPaver);
        searedStairsBrick = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrick);
        searedStairsBrickCracked = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrickCracked);
        searedStairsBrickFancy = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrickFancy);
        searedStairsBrickSquare = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrickSquare);
        searedStairsBrickTriangle = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrickTriangle);
        searedStairsBrickSmall = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsBrickSmall);
        searedStairsRoad = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsRoad);
        searedStairsTile = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsTile);
        searedStairsCreeper = TinkerSmeltery.registerItemBlock((IForgeRegistry<Item>)registry, searedStairsCreeper);
        cast = TinkerSmeltery.registerItem((IForgeRegistry<Item>)registry, new Cast(), "cast");
        castCustom = TinkerSmeltery.registerItem((IForgeRegistry<Item>)registry, new CastCustom(), "cast_custom");
        castIngot = castCustom.addMeta(0, "ingot", 144);
        castNugget = castCustom.addMeta(1, "nugget", 16);
        castGem = castCustom.addMeta(2, "gem", 666);
        castPlate = castCustom.addMeta(3, "plate", 144);
        castGear = castCustom.addMeta(4, "gear", 576);
        if (Config.claycasts) {
            clayCast = TinkerSmeltery.registerItem((IForgeRegistry<Item>)registry, new Cast(), "clay_cast");
        }
        if (TinkerRegistry.getShard() != null) {
            TinkerRegistry.addCastForItem(TinkerRegistry.getShard());
            castShard = new ItemStack((Item)cast);
            Cast.setTagForPart(castShard, TinkerRegistry.getShard());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)searedBlock);
        builder.add((Object)searedTank);
        builder.add((Object)smelteryIO);
        builder.add((Object)searedGlass);
        builder.add((Object)searedLadder);
        validSmelteryBlocks = builder.build();
        validTinkerTankBlocks = builder.build();
        validTinkerTankFloorBlocks = ImmutableSet.of((Object)((Object)searedBlock), (Object)((Object)searedGlass), (Object)((Object)smelteryIO));
        builder = ImmutableSet.builder();
        builder.add((Object)searedBlock);
        builder.add((Object)searedSlab);
        builder.add((Object)searedSlab2);
        builder.add((Object)searedStairsStone);
        builder.add((Object)searedStairsCobble);
        builder.add((Object)searedStairsPaver);
        builder.add((Object)searedStairsBrick);
        builder.add((Object)searedStairsBrickCracked);
        builder.add((Object)searedStairsBrickFancy);
        builder.add((Object)searedStairsBrickSquare);
        builder.add((Object)searedStairsBrickTriangle);
        builder.add((Object)searedStairsBrickSmall);
        builder.add((Object)searedStairsRoad);
        builder.add((Object)searedStairsTile);
        builder.add((Object)searedStairsCreeper);
        searedStairsSlabs = builder.build();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        proxy.registerModels();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        castCreationFluids.add(new FluidStack((Fluid)TinkerFluids.gold, 288));
        castCreationFluids.add(new FluidStack((Fluid)TinkerFluids.brass, 144));
        castCreationFluids.add(new FluidStack((Fluid)TinkerFluids.alubrass, 144));
        if (Config.claycasts) {
            clayCreationFluids.add(new FluidStack((Fluid)TinkerFluids.clay, 288));
        }
        this.registerSmelting();
        proxy.init();
    }

    private void registerSmelting() {
        GameRegistry.addSmelting((ItemStack)TinkerCommons.grout, (ItemStack)TinkerCommons.searedBrick, (float)0.4f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.BRICK.getMeta()), (ItemStack)new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.BRICK_CRACKED.getMeta()), (float)0.1f);
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        this.registerSmelteryFuel();
        this.registerMeltingCasting();
        for (FluidStack fs : castCreationFluids) {
            TinkerRegistry.registerTableCasting(new ItemStack((Item)cast), ItemStack.field_190927_a, fs.getFluid(), fs.amount);
            TinkerRegistry.registerTableCasting(new CastingRecipe(castGem, RecipeMatch.of((String)"gemEmerald"), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castGem, RecipeMatch.of((String)"gemDiamond"), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, RecipeMatch.of((String)"ingotBrick"), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, RecipeMatch.of((String)"ingotBrickNether"), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, (RecipeMatch)new RecipeMatch.Item(TinkerCommons.searedBrick, 1), fs, true, true));
        }
        proxy.postInit();
        TinkerRegistry.tabSmeltery.setDisplayIcon(new ItemStack((Block)searedTank));
    }

    private void registerSmelteryFuel() {
        TinkerRegistry.registerSmelteryFuel(new FluidStack(FluidRegistry.LAVA, 50), 100);
        TinkerRegistry.registerSmelteryFuel(new FluidStack((Fluid)TinkerFluids.blazingBlood, 50), 150);
    }

    private void registerMeltingCasting() {
        ItemStack stack;
        int bucket = 1000;
        TinkerRegistry.registerTableCasting(new BucketCastingRecipe(Items.field_151133_ar));
        Fluid water = FluidRegistry.WATER;
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Block)Blocks.field_150432_aD, (int)bucket), water, 305));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Block)Blocks.field_150403_cj, (int)(bucket * 2)), water, 310));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Block)Blocks.field_150433_aE, (int)bucket), water, 305));
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((Item)Items.field_151126_ay, (int)(bucket / 8)), water, 301));
        TinkerRegistry.registerMelting(Items.field_151078_bh, (Fluid)TinkerFluids.blood, 40);
        if (TinkerCommons.matSlimeBallBlood != null) {
            TinkerRegistry.registerTableCasting(new CastingRecipe(TinkerCommons.matSlimeBallBlood.func_77946_l(), null, TinkerFluids.blood, 250, 50));
            TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 1, BlockSlime.SlimeType.BLOOD.meta), null, TinkerFluids.blood, 1000, 100));
            TinkerRegistry.registerMelting(TinkerCommons.matSlimeBallBlood, (Fluid)TinkerFluids.blood, 250);
            ItemStack slimeblock_blood = new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 1, BlockSlime.SlimeType.BLOOD.meta);
            TinkerRegistry.registerMelting(slimeblock_blood, (Fluid)TinkerFluids.blood, 1000);
        }
        TinkerRegistry.registerMelting(Items.field_151070_bp, (Fluid)TinkerFluids.venom, 40);
        TinkerRegistry.registerMelting(new ItemStack(Items.field_151115_aP, 1, 3), (Fluid)TinkerFluids.venom, 40);
        TinkerRegistry.registerMelting(Items.field_151123_aH, (Fluid)TinkerFluids.greenSlime, 250);
        ItemStack slimeblock_green = new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 1, BlockSlime.SlimeType.GREEN.meta);
        TinkerRegistry.registerMelting(slimeblock_green, (Fluid)TinkerFluids.greenSlime, 1000);
        slimeblock_green = new ItemStack(Blocks.field_180399_cE);
        TinkerRegistry.registerMelting(slimeblock_green, (Fluid)TinkerFluids.greenSlime, 2250);
        TinkerRegistry.registerMelting(TinkerCommons.matSlimeBallBlue, (Fluid)TinkerFluids.blueslime, 250);
        ItemStack slimeblock_blue = new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 1, BlockSlime.SlimeType.BLUE.meta);
        TinkerRegistry.registerMelting(slimeblock_blue, (Fluid)TinkerFluids.blueslime, 1000);
        slimeblock_blue = new ItemStack((Block)TinkerCommons.blockSlime, 1, BlockSlime.SlimeType.BLUE.meta);
        TinkerRegistry.registerMelting(slimeblock_blue, (Fluid)TinkerFluids.blueslime, 2250);
        TinkerRegistry.registerMelting(TinkerCommons.matSlimeBallPurple, (Fluid)TinkerFluids.purpleSlime, 250);
        ItemStack slimeblock = new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 1, BlockSlime.SlimeType.PURPLE.meta);
        TinkerRegistry.registerMelting(slimeblock, (Fluid)TinkerFluids.purpleSlime, 1000);
        slimeblock = new ItemStack((Block)TinkerCommons.blockSlime, 1, BlockSlime.SlimeType.PURPLE.meta);
        TinkerRegistry.registerMelting(slimeblock, (Fluid)TinkerFluids.purpleSlime, 2250);
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((String)"stone", (int)72), TinkerFluids.searedStone, Material.VALUE_Ore()));
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((String)"cobblestone", (int)72), TinkerFluids.searedStone, Material.VALUE_Ore()));
        TinkerRegistry.registerMelting((Block)searedLadder, (Fluid)TinkerFluids.searedStone, 288);
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((String)"obsidian", (int)Material.VALUE_Ore()), TinkerFluids.obsidian, Material.VALUE_Ore()));
        TinkerSmeltery.registerToolpartMeltingCasting(TinkerMaterials.obsidian);
        TinkerRegistry.registerBasinCasting(new ItemStack(Blocks.field_150343_Z), ItemStack.field_190927_a, TinkerFluids.obsidian, Material.VALUE_Ore());
        TinkerRegistry.registerMelting(Items.field_151138_bX, (Fluid)TinkerFluids.iron, 576);
        TinkerRegistry.registerMelting(Items.field_151136_bY, (Fluid)TinkerFluids.gold, 576);
        TinkerRegistry.registerMelting(Blocks.field_150448_aq, (Fluid)TinkerFluids.iron, 54);
        TinkerRegistry.registerMelting(Blocks.field_150408_cc, (Fluid)TinkerFluids.iron, 144);
        TinkerRegistry.registerMelting(Blocks.field_150319_E, (Fluid)TinkerFluids.iron, 144);
        TinkerRegistry.registerMelting(Blocks.field_150318_D, (Fluid)TinkerFluids.gold, 144);
        for (IToolPart toolPart : TinkerRegistry.getToolParts()) {
            if (!toolPart.canBeCasted() || !(toolPart instanceof MaterialItem)) continue;
            stack = toolPart.getItemstackWithMaterial(TinkerMaterials.stone);
            TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.ofNBT((ItemStack)stack, (int)(toolPart.getCost() * 72 / 144)), TinkerFluids.searedStone, (int)((double)toolPart.getCost() * Config.oreToIngotRatio)));
        }
        ItemStack blockSeared = new ItemStack((Block)searedBlock);
        blockSeared.func_77964_b(BlockSeared.SearedType.STONE.getMeta());
        TinkerRegistry.registerTableCasting(TinkerCommons.searedBrick, castIngot, TinkerFluids.searedStone, 72);
        TinkerRegistry.registerBasinCasting(blockSeared, ItemStack.field_190927_a, TinkerFluids.searedStone, 288);
        ItemStack searedCobble = new ItemStack((Block)searedBlock, 1, BlockSeared.SearedType.COBBLE.getMeta());
        TinkerRegistry.registerBasinCasting(new CastingRecipe(searedCobble, RecipeMatch.of((String)"cobblestone"), TinkerFluids.searedStone, 216, true, false));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack(searedFurnaceController), RecipeMatch.of((Block)Blocks.field_150460_al), new FluidStack((Fluid)TinkerFluids.searedStone, 576), true, true));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)searedGlass, 1, BlockSearedGlass.GlassType.GLASS.getMeta()), RecipeMatch.of((String)"blockGlass"), new FluidStack((Fluid)TinkerFluids.searedStone, 288), true, true));
        TinkerRegistry.registerMelting((Block)searedBlock, (Fluid)TinkerFluids.searedStone, 288);
        TinkerRegistry.registerMelting(TinkerCommons.searedBrick, (Fluid)TinkerFluids.searedStone, 72);
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount(RecipeMatch.of((ItemStack)TinkerCommons.grout, (int)72), TinkerFluids.searedStone, 24));
        stack = new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE);
        RecipeMatch.Item rm = new RecipeMatch.Item(stack, 1, 144);
        TinkerRegistry.registerMelting(MeltingRecipe.forAmount((RecipeMatch)rm, TinkerFluids.dirt, 576));
        TinkerRegistry.registerTableCasting(TinkerCommons.mudBrick, castIngot, TinkerFluids.dirt, 144);
        TinkerRegistry.registerMelting(TinkerCommons.mudBrick, (Fluid)TinkerFluids.dirt, 144);
        TinkerRegistry.registerMelting(TinkerCommons.mudBrickBlock, (Fluid)TinkerFluids.dirt, 576);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)Pair.of((Object)"clay", (Object)144));
        builder.add((Object)Pair.of((Object)"blockClay", (Object)576));
        TinkerSmeltery.addKnownOreFluid(TinkerFluids.clay, (Set<Pair<String, Integer>>)builder.build());
        TinkerRegistry.registerBasinCasting(new ItemStack(Blocks.field_150405_ch), ItemStack.field_190927_a, TinkerFluids.clay, 576);
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack(Blocks.field_150405_ch), RecipeMatch.of((ItemStack)new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE)), new FluidStack(FluidRegistry.WATER, 250), 150, true, false));
        if (Config.castableBricks) {
            TinkerRegistry.registerTableCasting(new ItemStack(Items.field_151118_aC), castIngot, TinkerFluids.clay, 144);
        }
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"oreEmerald", (int)((int)(666.0 * Config.oreToIngotRatio))), TinkerFluids.emerald));
        builder = ImmutableSet.builder();
        builder.add((Object)Pair.of((Object)"gemEmerald", (Object)666));
        builder.add((Object)Pair.of((Object)"blockEmerald", (Object)5994));
        TinkerSmeltery.addKnownOreFluid(TinkerFluids.emerald, (Set<Pair<String, Integer>>)builder.build());
        TinkerRegistry.registerTableCasting(new ItemStack(Items.field_151166_bC), castGem, TinkerFluids.emerald, 666);
        TinkerRegistry.registerBasinCasting(new ItemStack(Blocks.field_150475_bE), ItemStack.field_190927_a, TinkerFluids.emerald, 5994);
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"oreDiamond", (int)((int)(666.0 * Config.oreToIngotRatio))), TinkerFluids.diamond));
        builder = ImmutableSet.builder();
        builder.add((Object)Pair.of((Object)"gemDiamond", (Object)666));
        builder.add((Object)Pair.of((Object)"blockDiamond", (Object)5994));
        TinkerSmeltery.addKnownOreFluid(TinkerFluids.diamond, (Set<Pair<String, Integer>>)builder.build());
        TinkerRegistry.registerTableCasting(new ItemStack(Items.field_151045_i), castGem, TinkerFluids.diamond, 666);
        TinkerRegistry.registerBasinCasting(new ItemStack(Blocks.field_150484_ah), ItemStack.field_190927_a, TinkerFluids.diamond, 5994);
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"sand", (int)1000), TinkerFluids.glass));
        builder = ImmutableSet.builder();
        builder.add((Object)Pair.of((Object)"blockGlass", (Object)1000));
        builder.add((Object)Pair.of((Object)"paneGlass", (Object)375));
        TinkerSmeltery.addKnownOreFluid(TinkerFluids.glass, (Set<Pair<String, Integer>>)builder.build());
        TinkerRegistry.registerTableCasting(new CastingRecipe(new ItemStack(Blocks.field_150410_aZ), null, TinkerFluids.glass, 375, 50));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack(TinkerCommons.blockClearGlass), null, TinkerFluids.glass, 1000, 120));
        TinkerRegistry.registerMelting(new ItemStack(Items.field_151100_aR, 1, 15), (Fluid)TinkerFluids.calcium, 48);
        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)"bone", (int)144), TinkerFluids.calcium));
        TinkerRegistry.registerMelting(new ItemStack(Blocks.field_189880_di), (Fluid)TinkerFluids.calcium, 432);
        TinkerRegistry.registerTableCasting(new CastingRecipe(new ItemStack(Items.field_151103_aS), null, TinkerFluids.calcium, 144, 50));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack(Blocks.field_189880_di), null, TinkerFluids.calcium, 432, 100));
        if (TinkerCommons.isToolsLoaded()) {
            TinkerRegistry.registerTableCasting(new CastingRecipe(TinkerCommons.matBloodyBone, RecipeMatch.of((String)"bone"), new FluidStack((Fluid)TinkerFluids.blood, 250), true, false));
            TinkerRegistry.registerTableCasting(new CastingRecipe(TinkerCommons.matVenomousBone, RecipeMatch.of((String)"bone"), new FluidStack((Fluid)TinkerFluids.venom, 250), true, false));
            TinkerRegistry.registerTableCasting(new CastingRecipe(TinkerCommons.matBlazingBone, RecipeMatch.of((String)"boneWithered"), new FluidStack((Fluid)TinkerFluids.blazingBlood, 250), 12, true, false));
        }
        TinkerRegistry.registerBasinCasting(new CastingRecipe(TinkerCommons.lavawood, RecipeMatch.of((String)"plankWood"), new FluidStack(FluidRegistry.LAVA, 250), 100, true, false));
        TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)Blocks.field_150354_m, 1, 1), RecipeMatch.of((ItemStack)new ItemStack((Block)Blocks.field_150354_m, 1, 0)), new FluidStack((Fluid)TinkerFluids.blood, 10), true, false));
        if (TinkerSmeltery.isWorldLoaded()) {
            TinkerRegistry.registerTableCasting(new CastingRecipe(new ItemStack(Items.field_151123_aH), null, TinkerFluids.greenSlime, 250, 50));
            TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)TinkerWorld.slimeDirt, 1, BlockSlime.SlimeType.GREEN.meta), RecipeMatch.of((String)"dirt"), new FluidStack((Fluid)TinkerFluids.greenSlime, 250), 100, true, false));
            TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 1, BlockSlime.SlimeType.GREEN.meta), null, TinkerFluids.greenSlime, 1000, 100));
            TinkerRegistry.registerTableCasting(new CastingRecipe(TinkerCommons.matSlimeBallBlue.func_77946_l(), null, TinkerFluids.blueslime, 250, 50));
            TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)TinkerWorld.slimeDirt, 1, BlockSlime.SlimeType.BLUE.meta), RecipeMatch.of((String)"dirt"), new FluidStack((Fluid)TinkerFluids.blueslime, 250), 100, true, false));
            TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 1, BlockSlime.SlimeType.BLUE.meta), null, TinkerFluids.blueslime, 1000, 100));
            TinkerRegistry.registerTableCasting(new CastingRecipe(TinkerCommons.matSlimeBallPurple.func_77946_l(), null, TinkerFluids.purpleSlime, 250, 50));
            TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)TinkerWorld.slimeDirt, 1, BlockSlime.SlimeType.PURPLE.meta), RecipeMatch.of((String)"dirt"), new FluidStack((Fluid)TinkerFluids.purpleSlime, 250), 100, true, false));
            TinkerRegistry.registerBasinCasting(new CastingRecipe(new ItemStack((Block)TinkerCommons.blockSlimeCongealed, 1, BlockSlime.SlimeType.PURPLE.meta), null, TinkerFluids.purpleSlime, 1000, 100));
        }
        if (Config.steelAlloy && Config.registerAllCommonMetals) {
            TinkerRegistry.registerTableCasting(new CastingRecipe(TinkerCommons.ingotSteel, RecipeMatch.of((String)"ingotIron"), new FluidStack((Fluid)TinkerFluids.blazingBlood, 100), true, false));
            TinkerRegistry.registerTableCasting(new CastingRecipe(TinkerCommons.blockSteel, RecipeMatch.of((String)"blockIron"), new FluidStack((Fluid)TinkerFluids.blazingBlood, 900), true, false));
        }
        TinkerRegistry.registerEntityMelting();
    }

    public static void registerAlloys() {
        if (!TinkerSmeltery.isSmelteryLoaded()) {
            return;
        }
        if (Config.obsidianAlloy) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.obsidian, 36), new FluidStack(FluidRegistry.WATER, 125), new FluidStack(FluidRegistry.LAVA, 125));
        }
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.clay, 144), new FluidStack(FluidRegistry.WATER, 250), new FluidStack((Fluid)TinkerFluids.searedStone, 72), new FluidStack((Fluid)TinkerFluids.dirt, 144));
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.knightslime, 72), new FluidStack((Fluid)TinkerFluids.iron, 72), new FluidStack((Fluid)TinkerFluids.purpleSlime, 125), new FluidStack((Fluid)TinkerFluids.searedStone, 144));
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.pigIron, 144), new FluidStack((Fluid)TinkerFluids.iron, 144), new FluidStack((Fluid)TinkerFluids.blood, 40), new FluidStack((Fluid)TinkerFluids.clay, 72));
        TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.manyullyn, 2), new FluidStack((Fluid)TinkerFluids.cobalt, 2), new FluidStack((Fluid)TinkerFluids.ardite, 2));
        if (TinkerIntegration.isIntegrated(TinkerFluids.bronze) && TinkerIntegration.isIntegrated(TinkerFluids.copper) && TinkerIntegration.isIntegrated(TinkerFluids.tin)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.bronze, 4), new FluidStack((Fluid)TinkerFluids.copper, 3), new FluidStack((Fluid)TinkerFluids.tin, 1));
        }
        if (TinkerIntegration.isIntegrated(TinkerFluids.electrum) && TinkerIntegration.isIntegrated(TinkerFluids.gold) && TinkerIntegration.isIntegrated(TinkerFluids.silver)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.electrum, 2), new FluidStack((Fluid)TinkerFluids.gold, 1), new FluidStack((Fluid)TinkerFluids.silver, 1));
        }
        if (TinkerIntegration.isIntegrated(TinkerFluids.alubrass) && TinkerIntegration.isIntegrated(TinkerFluids.copper) && TinkerIntegration.isIntegrated(TinkerFluids.aluminum)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.alubrass, 4), new FluidStack((Fluid)TinkerFluids.copper, 1), new FluidStack((Fluid)TinkerFluids.aluminum, 3));
        }
        if (TinkerIntegration.isIntegrated(TinkerFluids.brass) && TinkerIntegration.isIntegrated(TinkerFluids.copper) && TinkerIntegration.isIntegrated(TinkerFluids.zinc)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.brass, 3), new FluidStack((Fluid)TinkerFluids.copper, 2), new FluidStack((Fluid)TinkerFluids.zinc, 1));
        }
        if (TinkerIntegration.isIntegrated(TinkerFluids.alumite) && TinkerIntegration.isIntegrated(TinkerFluids.aluminum) && TinkerIntegration.isIntegrated(TinkerFluids.iron)) {
            TinkerRegistry.registerAlloy(new FluidStack((Fluid)TinkerFluids.alumite, 144), new FluidStack((Fluid)TinkerFluids.aluminum, 144), new FluidStack((Fluid)TinkerFluids.iron, 144), new FluidStack((Fluid)TinkerFluids.obsidian, 288));
        }
    }

    public static void registerToolpartMeltingCasting(Material material) {
        Fluid fluid = material.getFluid();
        for (IToolPart toolPart : TinkerRegistry.getToolParts()) {
            if (!toolPart.canBeCasted() || !toolPart.canUseMaterial(material) || !(toolPart instanceof MaterialItem)) continue;
            ItemStack stack = toolPart.getItemstackWithMaterial(material);
            ItemStack cast = new ItemStack((Item)TinkerSmeltery.cast);
            Cast.setTagForPart(cast, stack.func_77973_b());
            if (fluid != null) {
                TinkerRegistry.registerMelting(stack, fluid, toolPart.getCost());
                TinkerRegistry.registerTableCasting(stack, cast, fluid, toolPart.getCost());
            }
            for (FluidStack fs : castCreationFluids) {
                TinkerRegistry.registerTableCasting(new CastingRecipe(cast, RecipeMatch.ofNBT((ItemStack)stack), fs, true, true));
            }
            if (!Config.claycasts) continue;
            ItemStack clayCast = new ItemStack((Item)TinkerSmeltery.clayCast);
            Cast.setTagForPart(clayCast, stack.func_77973_b());
            if (fluid != null) {
                RecipeMatch rm = RecipeMatch.ofNBT((ItemStack)clayCast);
                FluidStack fs = new FluidStack(fluid, toolPart.getCost());
                TinkerRegistry.registerTableCasting(new CastingRecipe(stack, rm, fs, true, false));
            }
            for (FluidStack fs : clayCreationFluids) {
                TinkerRegistry.registerTableCasting(new CastingRecipe(clayCast, RecipeMatch.ofNBT((ItemStack)stack), fs, true, true));
            }
        }
        if (castShard != null) {
            ItemStack stack = TinkerRegistry.getShard(material);
            int cost = TinkerRegistry.getShard().getCost();
            if (fluid != null) {
                TinkerRegistry.registerMelting(stack, fluid, cost);
                TinkerRegistry.registerTableCasting(stack, castShard, fluid, cost);
            }
            for (FluidStack fs : castCreationFluids) {
                TinkerRegistry.registerTableCasting(new CastingRecipe(castShard, RecipeMatch.ofNBT((ItemStack)stack), fs, true, true));
            }
        }
    }

    public static void registerOredictMeltingCasting(Fluid fluid, String ore) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Pair nuggetOre = Pair.of((Object)("nugget" + ore), (Object)16);
        Pair ingotOre = Pair.of((Object)("ingot" + ore), (Object)144);
        Pair blockOre = Pair.of((Object)("block" + ore), (Object)1296);
        Pair oreOre = Pair.of((Object)("ore" + ore), (Object)Material.VALUE_Ore());
        Pair oreNetherOre = Pair.of((Object)("oreNether" + ore), (Object)((int)(288.0 * Config.oreToIngotRatio)));
        Pair oreDenseOre = Pair.of((Object)("denseore" + ore), (Object)((int)(432.0 * Config.oreToIngotRatio)));
        Pair orePoorOre = Pair.of((Object)("orePoor" + ore), (Object)((int)(48.0 * Config.oreToIngotRatio)));
        Pair oreNuggetOre = Pair.of((Object)("oreNugget" + ore), (Object)((int)(16.0 * Config.oreToIngotRatio)));
        Pair plateOre = Pair.of((Object)("plate" + ore), (Object)144);
        Pair gearOre = Pair.of((Object)("gear" + ore), (Object)576);
        Pair dustOre = Pair.of((Object)("dust" + ore), (Object)144);
        builder.add((Object[])new Pair[]{nuggetOre, ingotOre, blockOre, oreOre, oreNetherOre, oreDenseOre, orePoorOre, oreNuggetOre, plateOre, gearOre, dustOre});
        ImmutableSet knownOres = builder.build();
        TinkerSmeltery.addKnownOreFluid(fluid, (Set<Pair<String, Integer>>)knownOres);
        TinkerRegistry.registerTableCasting(new PreferenceCastingRecipe((String)ingotOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castIngot), fluid, (int)((Integer)ingotOre.getRight())));
        TinkerRegistry.registerTableCasting(new PreferenceCastingRecipe((String)nuggetOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castNugget), fluid, (int)((Integer)nuggetOre.getRight())));
        TinkerRegistry.registerBasinCasting(new PreferenceCastingRecipe((String)blockOre.getLeft(), null, fluid, (int)((Integer)blockOre.getRight())));
        TinkerRegistry.registerTableCasting(new PreferenceCastingRecipe((String)plateOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castPlate), fluid, (int)((Integer)plateOre.getRight())));
        TinkerRegistry.registerTableCasting(new PreferenceCastingRecipe((String)gearOre.getLeft(), RecipeMatch.ofNBT((ItemStack)castGear), fluid, (int)((Integer)gearOre.getRight())));
        for (FluidStack fs : castCreationFluids) {
            TinkerRegistry.registerTableCasting(new CastingRecipe(castIngot, RecipeMatch.of((String)((String)ingotOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castNugget, RecipeMatch.of((String)((String)nuggetOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castPlate, RecipeMatch.of((String)((String)plateOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting(new CastingRecipe(castGear, RecipeMatch.of((String)((String)gearOre.getLeft())), fs, true, true));
        }
    }

    private static void addKnownOreFluid(Fluid fluid, Set<Pair<String, Integer>> knownOres) {
        if (Arrays.stream(Config.fluidIgnore).anyMatch(f -> f.equals(fluid.getName()))) {
            return;
        }
        for (Pair<String, Integer> pair : knownOres) {
            TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((String)((String)pair.getLeft()), (int)((Integer)pair.getRight())), fluid));
        }
        knownOreFluids.put(fluid, knownOres);
    }

    public static void registerRecipeOredictMelting() {
        if (!TinkerSmeltery.isSmelteryLoaded()) {
            return;
        }
        log.info("Started adding oredict melting recipes");
        long start = System.nanoTime();
        File cacheFile = new File("config" + File.separator + "tconstruct" + "_oredictcache.dat");
        NBTTagCompound cacheNBT = new NBTTagCompound();
        if (cacheFile.exists()) {
            try {
                cacheNBT = CompressedStreamTools.func_74797_a((File)cacheFile);
                NBTTagList modsNBT = cacheNBT.func_150295_c("Mods", 8);
                Set cachedMods = StreamSupport.stream(modsNBT.spliterator(), false).map(nbt -> ((NBTTagString)nbt).func_150285_a_()).collect(Collectors.toSet());
                HashSet currentMods = new HashSet(Loader.instance().getIndexedModList().keySet());
                if (cachedMods.equals(currentMods)) {
                    NBTTagList recipeList = cacheNBT.func_150295_c("Recipes", 10);
                    for (int i = 0; i < recipeList.func_74745_c(); ++i) {
                        NBTTagCompound nBTTagCompound = recipeList.func_150305_b(i);
                        ItemStack item = new ItemStack(nBTTagCompound.func_74775_l("item"));
                        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound.func_74775_l("fluid"));
                        if (item.func_190926_b() || fluid == null) continue;
                        TinkerRegistry.registerMelting(new MeltingRecipe(RecipeMatch.of((ItemStack)item, (int)fluid.amount), fluid));
                    }
                    log.info("Loaded cached oredict melting recipes in {} seconds", (Object)((double)(System.nanoTime() - start) / 1.0E9));
                    return;
                }
                log.info("Mod list changed, rescanning recipes");
                cacheNBT = new NBTTagCompound();
            }
            catch (IOException e) {
                log.error("Failed to read cache file, rescanning recipes", (Throwable)e);
            }
        } else {
            log.info("Cache file doesn't exist, scanning recipes");
        }
        RecipeMatchRegistry oredictMeltingIgnore = new RecipeMatchRegistry();
        for (String ignore : Config.oredictMeltingIgnore) {
            if (ignore.isEmpty() || ignore.startsWith("#")) continue;
            if (ignore.contains(":")) {
                Item item;
                int meta;
                String[] stringArray;
                block28: {
                    stringArray = ignore.split(":");
                    meta = Short.MAX_VALUE;
                    if (stringArray.length > 2) {
                        try {
                            meta = Integer.parseInt(stringArray[2]);
                            if (meta < 0) {
                                log.error("Invalid oredict melting ignore {}, metadata must be non-negative", (Object)ignore);
                            }
                            break block28;
                        }
                        catch (NumberFormatException e) {
                            log.error("Invalid oredict melting ignore {}, metadata must be a number", (Object)ignore);
                        }
                        continue;
                    }
                }
                if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(stringArray[0], stringArray[1]))) == null || item == Items.field_190931_a) {
                    log.error("Invalid oredict melting ignore {}, unknown item", (Object)ignore);
                    continue;
                }
                oredictMeltingIgnore.addItem(new ItemStack(item, 1, meta), 1, 1);
                continue;
            }
            oredictMeltingIgnore.addItem(ignore);
        }
        ObjectOpenHashSet blacklistSet = new ObjectOpenHashSet(meltingBlacklist);
        Object2ObjectOpenHashMap oreFluidLookup = new Object2ObjectOpenHashMap();
        NonNullList subItems = NonNullList.func_191196_a();
        for (Map.Entry entry : knownOreFluids.entrySet()) {
            Fluid fluid = (Fluid)entry.getKey();
            for (Pair pair : (Set)entry.getValue()) {
                for (Object stack : OreDictionary.getOres((String)((String)pair.getLeft()), (boolean)false)) {
                    if (stack.func_77960_j() == Short.MAX_VALUE) {
                        subItems.clear();
                        stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, subItems);
                        for (ItemStack subStack : subItems) {
                            oreFluidLookup.put((Object)subStack.func_77946_l(), (Object)Pair.of((Object)fluid, (Object)pair.getRight()));
                        }
                        continue;
                    }
                    oreFluidLookup.put((Object)stack.func_77946_l(), (Object)Pair.of((Object)fluid, (Object)pair.getRight()));
                }
            }
        }
        NBTTagList recipeList = new NBTTagList();
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            Fluid fluid;
            int amount;
            ItemStack output = recipe.func_77571_b();
            if (output.func_190926_b() || TinkerRegistry.getMelting(output) != null || blacklistSet.stream().anyMatch(blacklist -> OreDictionary.itemMatches((ItemStack)blacklist, (ItemStack)output, (boolean)false))) continue;
            NonNullList inputs = recipe.func_192400_c();
            Object2IntOpenHashMap knownFluids = new Object2IntOpenHashMap(2);
            for (Ingredient ingredient : inputs) {
                ItemStack[] matchingStacks = ingredient.func_193365_a();
                if (matchingStacks.length == 0) continue;
                boolean found = false;
                for (ItemStack stack : matchingStacks) {
                    if (oredictMeltingIgnore.matches(new ItemStack[]{stack}).isPresent()) {
                        found = true;
                        break;
                    }
                    Pair fluidData = null;
                    for (ItemStack oreStack : oreFluidLookup.keySet()) {
                        if (!TinkerSmeltery.ingredientMatches(ingredient, oreStack)) continue;
                        fluidData = (Pair)oreFluidLookup.get((Object)oreStack);
                        break;
                    }
                    if (fluidData == null) continue;
                    knownFluids.addTo(fluidData.getLeft(), ((Integer)fluidData.getRight()).intValue());
                    found = true;
                    break;
                }
                if (found) continue;
                knownFluids.clear();
                break;
            }
            if (knownFluids.size() != 1 || (amount = knownFluids.getInt((Object)(fluid = (Fluid)knownFluids.keySet().iterator().next())) / output.func_190916_E()) <= 0) continue;
            ItemStack outputCopy = output.func_77946_l();
            outputCopy.func_190920_e(1);
            MeltingRecipe meltingRecipe = new MeltingRecipe(RecipeMatch.of((ItemStack)outputCopy, (int)amount), fluid);
            TinkerRegistry.registerMelting(meltingRecipe);
            ItemStack input = (ItemStack)meltingRecipe.input.getInputs().get(0);
            FluidStack outputFluid = meltingRecipe.output;
            if (!input.func_190926_b() && FluidRegistry.isFluidRegistered((Fluid)outputFluid.getFluid())) {
                NBTTagCompound recipeNBT = new NBTTagCompound();
                recipeNBT.func_74782_a("item", (NBTBase)input.serializeNBT());
                recipeNBT.func_74782_a("fluid", (NBTBase)TinkerSmeltery.fluidToNBT(outputFluid));
                recipeList.func_74742_a((NBTBase)recipeNBT);
            }
            log.trace("Added automatic melting recipe for {} ({} {})", (Object)outputCopy, (Object)amount, (Object)fluid.getName());
        }
        cacheNBT.func_74782_a("Recipes", (NBTBase)recipeList);
        NBTTagList nBTTagList = new NBTTagList();
        Loader.instance().getIndexedModList().keySet().stream().map(NBTTagString::new).forEach(arg_0 -> ((NBTTagList)nBTTagList).func_74742_a(arg_0));
        cacheNBT.func_74782_a("Mods", (NBTBase)nBTTagList);
        try {
            if (!cacheFile.exists()) {
                cacheFile.createNewFile();
            }
            CompressedStreamTools.func_74795_b((NBTTagCompound)cacheNBT, (File)cacheFile);
            log.info("Cache file written successfully");
        }
        catch (IOException e) {
            log.error("Failed to write cache file", (Throwable)e);
        }
        log.info("Oredict melting recipes finished in {} seconds", (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    private static boolean ingredientMatches(Ingredient ingredient, ItemStack stack) {
        if (stack.func_77960_j() != Short.MAX_VALUE) {
            return ingredient.apply(stack);
        }
        NonNullList stacks = NonNullList.func_191196_a();
        stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, stacks);
        return stacks.stream().anyMatch(arg_0 -> ((Ingredient)ingredient).apply(arg_0));
    }

    private static NBTTagCompound fluidToNBT(FluidStack fluidStack) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("FluidName", fluidStack.getFluid().getName());
        nbt.func_74768_a("Amount", fluidStack.amount);
        if (fluidStack.tag != null) {
            nbt.func_74782_a("Tag", (NBTBase)fluidStack.tag);
        }
        return nbt;
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockSearedStairs registerBlockSearedStairsFrom(IForgeRegistry<Block> registry, EnumBlock<E> block, E value, String name) {
        return TinkerSmeltery.registerBlock(registry, new BlockSearedStairs(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    static {
        knownOreFluids = new Object2ObjectOpenHashMap();
        castCreationFluids = new ObjectArrayList();
        clayCreationFluids = new ObjectArrayList();
        meltingBlacklist = new ObjectArrayList();
    }
}

