/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.eventbus.Subscribe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.ModelRegisterUtil;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.tools.AbstractToolPulse;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ModExtraTraitDisplay;
import slimeknights.tconstruct.tools.modifiers.ModFortifyDisplay;

@Pulse(id="TinkerModelRegister", description="Registers tool models and co", pulsesRequired="TinkerTools", forced=true)
public class AggregateModelRegistrar
extends AbstractToolPulse {
    public static final String PulseId = "TinkerModelRegister";
    static final Logger log = Util.getLogger("TinkerModelRegister");
    @SidedProxy(clientSide="slimeknights.tconstruct.tools.AggregateModelRegistrar$AggregateClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;

    @Override
    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (Pair toolPartPattern : toolPartPatterns) {
            this.registerStencil((Item)toolPartPattern.getLeft(), (ToolPart)toolPartPattern.getRight());
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        proxy.registerModels();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    private void registerStencil(Item pattern, ToolPart toolPart) {
        for (ToolCore toolCore : TinkerRegistry.getTools()) {
            for (PartMaterialType partMaterialType : toolCore.getRequiredComponents()) {
                if (!partMaterialType.getPossibleParts().contains(toolPart)) continue;
                ItemStack stencil = new ItemStack(pattern);
                Pattern.setTagForPart(stencil, toolPart);
                TinkerRegistry.registerStencilTableCrafting(stencil);
                return;
            }
        }
    }

    public static class AggregateClientProxy
    extends ClientProxy {
        @Override
        public void registerModels() {
            super.registerModels();
            for (ToolPart part : AbstractToolPulse.toolparts) {
                ModelRegisterUtil.registerPartModel(part);
            }
            for (ToolCore tool : AbstractToolPulse.tools) {
                ModelRegisterUtil.registerToolModel(tool);
            }
            this.registerModifierModels();
        }

        private void registerModifierModels() {
            for (IModifier modifier : AbstractToolPulse.modifiers) {
                if (modifier == TinkerModifiers.modCreative || modifier == TinkerModifiers.modHarvestWidth || modifier == TinkerModifiers.modHarvestHeight || modifier == TinkerModifiers.modEndearment || modifier == TinkerModifiers.modIncognito) continue;
                ModelRegisterUtil.registerModifierModel(modifier, Util.getModifierResource(modifier.getIdentifier()));
            }
            ModelRegisterUtil.registerModifierModel(new ModFortifyDisplay(), Util.getResource("models/item/modifiers/fortify"));
            new ModExtraTraitDisplay();
        }
    }
}

