/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.gadgets.item.ItemPiggybackPack;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.AbstractToolPulse;
import slimeknights.tconstruct.tools.modifiers.ModAntiMonsterType;
import slimeknights.tconstruct.tools.modifiers.ModAutosmelt;
import slimeknights.tconstruct.tools.modifiers.ModBeheading;
import slimeknights.tconstruct.tools.modifiers.ModBlasting;
import slimeknights.tconstruct.tools.modifiers.ModCreative;
import slimeknights.tconstruct.tools.modifiers.ModDiamond;
import slimeknights.tconstruct.tools.modifiers.ModEmerald;
import slimeknights.tconstruct.tools.modifiers.ModExtraModifier;
import slimeknights.tconstruct.tools.modifiers.ModExtraTrait;
import slimeknights.tconstruct.tools.modifiers.ModFiery;
import slimeknights.tconstruct.tools.modifiers.ModFins;
import slimeknights.tconstruct.tools.modifiers.ModFortify;
import slimeknights.tconstruct.tools.modifiers.ModGlowing;
import slimeknights.tconstruct.tools.modifiers.ModHarvestSize;
import slimeknights.tconstruct.tools.modifiers.ModHaste;
import slimeknights.tconstruct.tools.modifiers.ModIncognito;
import slimeknights.tconstruct.tools.modifiers.ModKnockback;
import slimeknights.tconstruct.tools.modifiers.ModLuck;
import slimeknights.tconstruct.tools.modifiers.ModMendingMoss;
import slimeknights.tconstruct.tools.modifiers.ModNecrotic;
import slimeknights.tconstruct.tools.modifiers.ModReinforced;
import slimeknights.tconstruct.tools.modifiers.ModSharpness;
import slimeknights.tconstruct.tools.modifiers.ModShulking;
import slimeknights.tconstruct.tools.modifiers.ModSilktouch;
import slimeknights.tconstruct.tools.modifiers.ModSoulbound;
import slimeknights.tconstruct.tools.modifiers.ModWebbed;
import slimeknights.tconstruct.tools.traits.InfiTool;

@Pulse(id="TinkerModifiers", description="All the modifiers in one handy package", pulsesRequired="TinkerTools", forced=true)
public class TinkerModifiers
extends AbstractToolPulse {
    public static final String PulseId = "TinkerModifiers";
    public static final Logger log = Util.getLogger("TinkerModifiers");
    @SidedProxy(clientSide="slimeknights.tconstruct.tools.ToolClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static Modifier modBaneOfArthopods;
    public static Modifier modBeheading;
    public static Modifier modBlasting;
    public static Modifier modDiamond;
    public static Modifier modEmerald;
    public static Modifier modFiery;
    public static Modifier modFins;
    public static Modifier modGlowing;
    public static Modifier modHaste;
    public static Modifier modHarvestWidth;
    public static Modifier modHarvestHeight;
    public static Modifier modKnockback;
    public static ModLuck modLuck;
    public static Modifier modMendingMoss;
    public static Modifier modNecrotic;
    public static Modifier modReinforced;
    public static Modifier modSharpness;
    public static Modifier modShulking;
    public static Modifier modSilktouch;
    public static Modifier modAutosmelt;
    public static Modifier modWebbed;
    public static Modifier modSmite;
    public static Modifier modSoulbound;
    public static Modifier modEndearment;
    public static Modifier modIncognito;
    public static Modifier modCreative;
    public static List<Modifier> fortifyMods;
    public static List<Modifier> extraTraitMods;
    private Map<String, ModExtraTrait> extraTraitLookup = new HashMap<String, ModExtraTrait>();

    @Override
    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        this.registerModifiers();
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)ItemPiggybackPack.CarryPotionEffect.INSTANCE);
    }

    @Override
    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        this.registerFortifyModifiers();
        this.registerExtraTraitModifiers();
        this.registerMobHeadDrops();
    }

    protected void registerModifiers() {
        ItemStack tnt = new ItemStack(Blocks.field_150335_W);
        ItemStack glowstoneDust = new ItemStack(Items.field_151114_aO);
        modBaneOfArthopods = new ModAntiMonsterType("bane_of_arthopods", 6404681, 5, 24, EnumCreatureAttribute.ARTHROPOD);
        modBaneOfArthopods = this.registerModifier(modBaneOfArthopods);
        modBaneOfArthopods.addItem(Items.field_151071_bq);
        modBeheading = this.registerModifier(new ModBeheading());
        modBeheading.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{new ItemStack(Items.field_151079_bi), new ItemStack(Blocks.field_150343_Z)}));
        modBlasting = this.registerModifier(new ModBlasting());
        modBlasting.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{tnt, tnt, tnt}));
        modDiamond = this.registerModifier(new ModDiamond());
        modDiamond.addItem("gemDiamond");
        modEmerald = this.registerModifier(new ModEmerald());
        modEmerald.addItem("gemEmerald");
        modFiery = this.registerModifier(new ModFiery());
        modFiery.addItem(Items.field_151065_br);
        modFins = this.registerModifier(new ModFins());
        modFins.addItem("fish", 2, 1);
        modGlowing = this.registerModifier(new ModGlowing());
        modGlowing.addRecipeMatch((RecipeMatch)new RecipeMatch.ItemCombination(1, new ItemStack[]{glowstoneDust, new ItemStack(Items.field_151061_bv), glowstoneDust}));
        modHaste = this.registerModifier(new ModHaste(50));
        modHaste.addItem("dustRedstone");
        modHaste.addItem("blockRedstone", 1, 9);
        modHarvestWidth = this.registerModifier(new ModHarvestSize("width"));
        modHarvestWidth.addItem(TinkerCommons.matExpanderW, 1, 1);
        modHarvestHeight = this.registerModifier(new ModHarvestSize("height"));
        modHarvestHeight.addItem(TinkerCommons.matExpanderH, 1, 1);
        modKnockback = this.registerModifier(new ModKnockback());
        modKnockback.addItem((Block)Blocks.field_150331_J, 1);
        modKnockback.addItem((Block)Blocks.field_150320_F, 1);
        modLuck = this.registerModifier(new ModLuck());
        modLuck.addItem("gemLapis");
        modLuck.addItem("blockLapis", 1, 9);
        modMendingMoss = this.registerModifier(new ModMendingMoss());
        modMendingMoss.addItem(TinkerCommons.matMendingMoss, 1, 1);
        modNecrotic = this.registerModifier(new ModNecrotic());
        modNecrotic.addItem("boneWithered");
        modReinforced = this.registerModifier(new ModReinforced());
        modReinforced.addItem(TinkerCommons.matReinforcement, 1, 1);
        modSharpness = this.registerModifier(new ModSharpness(72));
        modSharpness.addItem("gemQuartz");
        modSharpness.addItem("blockQuartz", 1, 4);
        modShulking = this.registerModifier(new ModShulking());
        modShulking.addItem(Items.field_185162_cT);
        modSilktouch = this.registerModifier(new ModSilktouch());
        modSilktouch.addItem(TinkerCommons.matSilkyJewel, 1, 1);
        modAutosmelt = this.registerModifier(new ModAutosmelt());
        modAutosmelt.addItem(TinkerCommons.matLavaCrystal, 1, 1);
        modWebbed = this.registerModifier(new ModWebbed());
        modWebbed.addItem(Blocks.field_150321_G, 1);
        modSmite = new ModAntiMonsterType("smite", 15258880, 5, 24, EnumCreatureAttribute.UNDEAD);
        modSmite = this.registerModifier(modSmite);
        modSmite.addItem(TinkerCommons.consecratedSoil, 1, 1);
        modSoulbound = this.registerModifier(new ModSoulbound());
        modSoulbound.addItem(Items.field_151156_bN);
        modEndearment = this.registerModifier(new ModExtraModifier());
        modEndearment.addItem(new ItemStack(Items.field_151144_bL, 1, 5), 1, 1);
        modIncognito = this.registerModifier(new ModIncognito());
        modIncognito.addItem(new ItemStack(Blocks.field_150360_v, 1, 1), 1, 1);
        modCreative = this.registerModifier(new ModCreative());
        modCreative.addItem(TinkerCommons.matCreativeModifier, 1, 1);
        TinkerRegistry.addTrait(InfiTool.INSTANCE);
    }

    private void registerFortifyModifiers() {
        fortifyMods = Lists.newArrayList();
        for (Material mat : TinkerRegistry.getAllMaterialsWithStats("head")) {
            fortifyMods.add(new ModFortify(mat));
        }
    }

    private void registerMobHeadDrops() {
        HashMap<String, List> entityDrops = new HashMap<String, List>();
        for (String entry : Config.mobHeadDrops) {
            ResourceLocation itemLocation;
            int maxQuantity;
            int metadata;
            String itemName;
            boolean applyToSubtypes;
            String entityRL;
            block26: {
                block25: {
                    String[] parts = entry.split(";");
                    if (parts.length < 3) {
                        log.error("Invalid mob head drop entry: {}", (Object)entry);
                        continue;
                    }
                    entityRL = parts[0];
                    String subtypes = parts[1];
                    String itemResource = parts[2];
                    try {
                        applyToSubtypes = Boolean.parseBoolean(subtypes);
                    }
                    catch (Exception e) {
                        log.error("Invalid subtypes value in mob head drop entry: {}", (Object)entry);
                        continue;
                    }
                    String[] itemParts = itemResource.split(":");
                    if (itemParts.length < 2 || itemParts.length > 3) {
                        log.error("Invalid item resource location in mob head drop entry: {}", (Object)entry);
                        continue;
                    }
                    itemName = itemParts[0] + ":" + itemParts[1];
                    try {
                        metadata = itemParts.length == 3 ? Integer.parseInt(itemParts[2]) : 0;
                    }
                    catch (NumberFormatException e) {
                        log.error("Invalid metadata in mob head drop entry: {}", (Object)entry);
                        continue;
                    }
                    maxQuantity = 1;
                    if (parts.length == 4) {
                        try {
                            maxQuantity = Integer.parseInt(parts[3]);
                            if (maxQuantity < 1) {
                                log.error("Invalid quantity value in mob head drop entry: {}", (Object)entry);
                            }
                            break block25;
                        }
                        catch (NumberFormatException e) {
                            log.error("Invalid quantity format in mob head drop entry: {}", (Object)entry);
                        }
                        continue;
                    }
                }
                try {
                    itemLocation = new ResourceLocation(itemName);
                    if (!Loader.isModLoaded((String)itemLocation.func_110624_b())) {
                    }
                    break block26;
                }
                catch (Exception e) {
                    log.error("Invalid item resource location: {}", (Object)itemName);
                }
                continue;
            }
            Item headItem = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            if (headItem == null) {
                log.error("Item not found for mob head drop: {}", (Object)itemName);
                continue;
            }
            ItemDrop drop2 = new ItemDrop(headItem, metadata, maxQuantity, applyToSubtypes);
            entityDrops.computeIfAbsent(entityRL, k -> new ArrayList()).add(drop2);
        }
        for (Map.Entry entry : entityDrops.entrySet()) {
            ResourceLocation entityLocation;
            List drops;
            String entityRL;
            block27: {
                entityRL = (String)entry.getKey();
                drops = (List)entry.getValue();
                if (entityRL.equals("minecraft:player")) {
                    TinkerRegistry.registerHeadDrop(EntityPlayerMP.class, entity -> {
                        ArrayList<ItemStack> dropStacks = new ArrayList<ItemStack>();
                        for (ItemDrop drop : drops) {
                            ItemStack stack = new ItemStack(drop.item, drop.maxQuantity, drop.metadata);
                            if (entity instanceof EntityPlayer && drop.item instanceof ItemSkull) {
                                NBTUtil.func_180708_a((NBTTagCompound)stack.func_190925_c("SkullOwner"), (GameProfile)((EntityPlayer)entity).func_146103_bH());
                            }
                            dropStacks.add(stack);
                        }
                        return dropStacks.isEmpty() ? null : (ItemStack)dropStacks.get(TConstruct.random.nextInt(dropStacks.size()));
                    });
                    drops.forEach(drop -> log.info("Registered mob head drop for {} into {} with metadata {} (quantity <={}, subtypes: {})", (Object)entityRL, (Object)ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)drop.item), (Object)drop.metadata, (Object)drop.maxQuantity, (Object)drop.subtypes));
                    continue;
                }
                try {
                    entityLocation = new ResourceLocation(entityRL);
                    if (!Loader.isModLoaded((String)entityLocation.func_110624_b())) {
                    }
                    break block27;
                }
                catch (Exception e) {
                    log.error("Invalid entity resource location: {}", (Object)entityRL);
                }
                continue;
            }
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entityLocation);
            if (entityEntry == null) {
                log.error("Entity not found for mob head drop: {}", (Object)entityRL);
                continue;
            }
            Class entityClass = entityEntry.getEntityClass();
            if (!EntityLivingBase.class.isAssignableFrom(entityClass)) {
                log.error("Entity class {} is not a suitable entity for mob head drop: {}", (Object)entityClass.getName(), (Object)entry);
                continue;
            }
            for (ItemDrop drop3 : drops) {
                ItemStack headStack = new ItemStack(drop3.item, drop3.maxQuantity, drop3.metadata);
                if (drop3.subtypes) {
                    TinkerRegistry.registerHeadDropForAll(entityClass, headStack);
                } else {
                    TinkerRegistry.registerHeadDrop((Class<? extends EntityLivingBase>)entityClass, headStack);
                }
                log.info("Registered mob head drop for {} into {} with metadata {} (quantity <={}, subtypes: {})", (Object)entityRL, (Object)ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)drop3.item), (Object)drop3.metadata, (Object)drop3.maxQuantity, (Object)drop3.subtypes);
            }
        }
    }

    private void registerExtraTraitModifiers() {
        TinkerRegistry.getAllMaterials().forEach(this::registerExtraTraitModifiers);
        extraTraitMods = Lists.newArrayList(this.extraTraitLookup.values());
    }

    private void registerExtraTraitModifiers(Material material) {
        TinkerRegistry.getTools().forEach(tool -> this.registerExtraTraitModifiers(material, (ToolCore)tool));
    }

    private void registerExtraTraitModifiers(Material material, ToolCore tool) {
        tool.getRequiredComponents().forEach(pmt -> this.registerExtraTraitModifiers(material, tool, (PartMaterialType)pmt));
    }

    private void registerExtraTraitModifiers(Material material, ToolCore tool, PartMaterialType partMaterialType) {
        partMaterialType.getPossibleParts().forEach(part -> this.registerExtraTraitModifiers(material, tool, partMaterialType, (IToolPart)part));
    }

    private <T extends Item> void registerExtraTraitModifiers(Material material, ToolCore tool, PartMaterialType partMaterialType, IToolPart toolPart) {
        Collection<ITrait> traits;
        if (toolPart instanceof Item && !(traits = partMaterialType.getApplicableTraitsForMaterial(material)).isEmpty()) {
            ImmutableSet traits2 = ImmutableSet.copyOf(traits);
            String identifier = ModExtraTrait.generateIdentifier(material, (Collection<ITrait>)traits2);
            ModExtraTrait mod = this.extraTraitLookup.computeIfAbsent(identifier, arg_0 -> TinkerModifiers.lambda$registerExtraTraitModifiers$6(material, (Collection)traits2, identifier, arg_0));
            mod.addCombination(tool, (Item)toolPart);
        }
    }

    private static /* synthetic */ ModExtraTrait lambda$registerExtraTraitModifiers$6(Material material, Collection traits2, String identifier, String id) {
        return new ModExtraTrait(material, traits2, identifier);
    }

    private static class ItemDrop {
        final Item item;
        final int metadata;
        final int maxQuantity;
        final boolean subtypes;

        ItemDrop(Item item, int metadata, int maxQuantity, boolean subtypes) {
            this.item = item;
            this.metadata = metadata;
            this.maxQuantity = maxQuantity;
            this.subtypes = subtypes;
        }
    }
}

