/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.block;

import com.google.common.collect.ImmutableList;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.tools.common.block.ITinkerStationBlock;
import slimeknights.tconstruct.tools.common.tileentity.TileCraftingStation;
import slimeknights.tconstruct.tools.common.tileentity.TilePartBuilder;
import slimeknights.tconstruct.tools.common.tileentity.TilePartChest;
import slimeknights.tconstruct.tools.common.tileentity.TilePatternChest;
import slimeknights.tconstruct.tools.common.tileentity.TileStencilTable;
import slimeknights.tconstruct.tools.common.tileentity.TileTinkerChest;
import slimeknights.tconstruct.tools.common.tileentity.TileToolStation;

public class BlockToolTable
extends BlockTable
implements ITinkerStationBlock {
    public static final PropertyEnum<TableTypes> TABLES = PropertyEnum.func_177709_a((String)"type", TableTypes.class);
    private static ImmutableList<AxisAlignedBB> BOUNDS_Chest = ImmutableList.of((Object)new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0), (Object)new AxisAlignedBB(0.0625, 0.1875, 0.0625, 0.9375, 1.0, 0.9375), (Object)new AxisAlignedBB(0.03125, 0.0, 0.03125, 0.15625, 0.75, 0.15625), (Object)new AxisAlignedBB(0.84375, 0.0, 0.03125, 0.96875, 0.75, 0.15625), (Object)new AxisAlignedBB(0.84375, 0.0, 0.84375, 0.96875, 0.75, 0.96875), (Object)new AxisAlignedBB(0.03125, 0.0, 0.84375, 0.15625, 0.75, 0.96875));

    public BlockToolTable() {
        super(Material.field_151575_d);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabGeneral);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149752_b(5.0f);
        this.func_149711_c(1.0f);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        switch (TableTypes.fromMeta(meta)) {
            case CraftingStation: {
                return new TileCraftingStation();
            }
            case StencilTable: {
                return new TileStencilTable();
            }
            case PartBuilder: {
                return new TilePartBuilder();
            }
            case ToolStation: {
                return new TileToolStation();
            }
            case CastChest: 
            case PatternChest: {
                return new TilePatternChest();
            }
            case PartChest: {
                return new TilePartChest();
            }
        }
        return super.func_149915_a(worldIn, meta);
    }

    @Override
    public boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            player.openGui((Object)TConstruct.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (player.field_71070_bA instanceof BaseContainer) {
                ((BaseContainer)player.field_71070_bA).syncOnOpen((EntityPlayerMP)player);
            }
        }
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float clickX, float clickY, float clickZ) {
        IItemHandlerModifiable itemHandler;
        ItemStack rest;
        TileEntity te = world.func_175625_s(pos);
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (!heldItem.func_190926_b() && te instanceof TileTinkerChest && ((rest = ItemHandlerHelper.insertItem((IItemHandler)(itemHandler = ((TileTinkerChest)te).getItemHandler()), (ItemStack)heldItem, (boolean)false)).func_190926_b() || rest.func_190916_E() < heldItem.func_190916_E())) {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)rest);
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, clickX, clickY, clickZ);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, TableTypes.CraftingStation.meta));
        this.addBlocksFromOredict("plankWood", TableTypes.StencilTable.meta, list);
        list.add((Object)new ItemStack((Block)this, 1, TableTypes.PatternChest.meta));
        this.addBlocksFromOredict("logWood", TableTypes.PartBuilder.meta, list);
        list.add((Object)new ItemStack((Block)this, 1, TableTypes.PartChest.meta));
        list.add((Object)new ItemStack((Block)this, 1, TableTypes.ToolStation.meta));
    }

    private void addBlocksFromOredict(String oredict, int meta, NonNullList<ItemStack> list) {
        for (ItemStack stack : OreDictionary.getOres((String)oredict)) {
            Block block = BlockToolTable.func_149634_a((Item)stack.func_77973_b());
            int blockMeta = stack.func_77952_i();
            if (blockMeta == Short.MAX_VALUE) {
                NonNullList subBlocks = NonNullList.func_191196_a();
                block.func_149666_a(null, subBlocks);
                for (ItemStack subBlock : subBlocks) {
                    list.add((Object)BlockToolTable.createItemstack(this, meta, BlockToolTable.func_149634_a((Item)subBlock.func_77973_b()), subBlock.func_77952_i()));
                    if (Config.listAllTables) continue;
                    return;
                }
                continue;
            }
            list.add((Object)BlockToolTable.createItemstack(this, meta, block, blockMeta));
            if (Config.listAllTables) continue;
            return;
        }
    }

    @Override
    protected boolean keepInventory(IBlockState state) {
        return Config.chestsKeepInventory && (state.func_177229_b(TABLES) == TableTypes.PatternChest || state.func_177229_b(TABLES) == TableTypes.PartChest || state.func_177229_b(TABLES) == TableTypes.CastChest);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TABLES}, new IUnlistedProperty[]{TEXTURE, INVENTORY, FACING});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TABLES, (Comparable)((Object)TableTypes.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((TableTypes)((Object)state.func_177229_b(BlockToolTable.TABLES))).meta;
    }

    @Override
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        if (((TableTypes)((Object)blockState.func_177229_b(BlockToolTable.TABLES))).isChest) {
            return BlockToolTable.raytraceMultiAABB(BOUNDS_Chest, pos, start, end);
        }
        return super.func_180636_a(blockState, worldIn, pos, start, end);
    }

    @Override
    public int getGuiNumber(IBlockState state) {
        switch ((TableTypes)((Object)state.func_177229_b(TABLES))) {
            case StencilTable: {
                return 10;
            }
            case CastChest: 
            case PatternChest: {
                return 15;
            }
            case PartChest: {
                return 16;
            }
            case PartBuilder: {
                return 20;
            }
            case ToolStation: {
                return 25;
            }
            case CraftingStation: {
                return 50;
            }
        }
        return 0;
    }

    public static enum TableTypes implements IStringSerializable
    {
        CraftingStation,
        StencilTable,
        PartBuilder,
        ToolStation,
        PatternChest(true),
        PartChest(true),
        CastChest(true);

        public final int meta = this.ordinal();
        public final boolean isChest;

        private TableTypes() {
            this.isChest = false;
        }

        private TableTypes(boolean chest) {
            this.isChest = chest;
        }

        public static TableTypes fromMeta(int meta) {
            if (meta < 0 || meta >= TableTypes.values().length) {
                meta = 0;
            }
            return TableTypes.values()[meta];
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }
    }
}

