/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.tconstruct.library.smeltery.ICast;
import slimeknights.tconstruct.library.tools.IPattern;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.tools.common.block.BlockToolTable;
import slimeknights.tconstruct.tools.common.client.GuiPatternChest;
import slimeknights.tconstruct.tools.common.inventory.ContainerPatternChest;
import slimeknights.tconstruct.tools.common.tileentity.TileTinkerChest;

public class TilePatternChest
extends TileTinkerChest
implements IInventoryGui {
    protected final NonNullList<ItemStack> casts = OreDictionary.getOres((String)"cast");
    protected final NonNullList<ItemStack> patterns = OreDictionary.getOres((String)"pattern");

    public TilePatternChest() {
        super("gui.patternchest.name", 256, 1);
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerPatternChest(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiPatternChest(inventoryplayer, world, pos, this);
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        boolean blockInWorldIsCastChest;
        super.func_70299_a(slot, itemstack);
        boolean isCastChest = this.isCastChest();
        boolean bl = blockInWorldIsCastChest = this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockToolTable.TABLES) == BlockToolTable.TableTypes.CastChest;
        if (isCastChest != blockInWorldIsCastChest) {
            TilePatternChest.setState(isCastChest, this.field_145850_b, this.field_174879_c);
        }
    }

    public static void setState(boolean isCast, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (isCast) {
            worldIn.func_180501_a(pos, iblockstate.func_177226_a(BlockToolTable.TABLES, (Comparable)((Object)BlockToolTable.TableTypes.CastChest)), 3);
        } else {
            worldIn.func_180501_a(pos, iblockstate.func_177226_a(BlockToolTable.TABLES, (Comparable)((Object)BlockToolTable.TableTypes.PatternChest)), 3);
        }
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack itemstack) {
        int i;
        if (itemstack.func_190926_b() || !this.isPattern(itemstack) && !this.isCast(itemstack)) {
            return false;
        }
        Item part = Pattern.getPartFromTag(itemstack);
        boolean hasContents = false;
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.isStackInSlot(i)) continue;
            hasContents = true;
            break;
        }
        if (!hasContents) {
            return true;
        }
        boolean castChest = this.isCastChest();
        if (castChest && !this.isCast(itemstack)) {
            return false;
        }
        if (!(castChest || this.isPattern(itemstack) && !this.isCast(itemstack))) {
            return false;
        }
        if (part == null) {
            for (i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack inv = this.func_70301_a(i);
                if (inv.func_190926_b() || !ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)inv) || !ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)inv)) continue;
                return false;
            }
            return true;
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            Item slotPart = Pattern.getPartFromTag(this.func_70301_a(i));
            if (slotPart == null) continue;
            if (this.func_70301_a(i).func_77973_b() != itemstack.func_77973_b()) {
                return false;
            }
            if (slotPart != part) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.isCastChest()) {
            return "gui.castchest.name";
        }
        return super.func_70005_c_();
    }

    public boolean isCastChest() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.isCast(this.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isCast(ItemStack stack) {
        if (stack.func_77973_b() instanceof ICast) {
            return true;
        }
        for (ItemStack target : this.casts) {
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean isPattern(ItemStack stack) {
        if (stack.func_77973_b() instanceof IPattern) {
            return true;
        }
        for (ItemStack target : this.patterns) {
            if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)stack, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

