/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.common.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.tconstruct.library.client.ToolBuildGuiInfo;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.block.PropertyTableItem;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.shared.tileentity.TileTable;
import slimeknights.tconstruct.tools.common.client.GuiButtonRepair;
import slimeknights.tconstruct.tools.common.client.GuiToolStation;
import slimeknights.tconstruct.tools.common.inventory.ContainerToolStation;

public class TileToolStation
extends TileTable
implements IInventoryGui {
    protected ItemStack deconstructingStack = ItemStack.field_190927_a;

    public TileToolStation() {
        super("gui.toolstation.name", 6);
        this.itemHandler = new ConfigurableInvWrapperCapability((IInventory)this, false, false);
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerToolStation(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiToolStation(inventoryplayer, world, pos, this);
    }

    @Override
    protected IExtendedBlockState setInventoryDisplay(IExtendedBlockState state) {
        PropertyTableItem.TableItems toDisplay = new PropertyTableItem.TableItems();
        ToolBuildGuiInfo info = GuiButtonRepair.info;
        if (this.isDeconstructing()) {
            PropertyTableItem.TableItem item = TileToolStation.getTableItem(this.deconstructingStack, this.func_145831_w(), null);
            toDisplay.items.add(item);
        } else {
            float s = 0.46875f;
            for (int i = 0; i < info.positions.size(); ++i) {
                ItemStack stackInSlot = this.func_70301_a(i);
                PropertyTableItem.TableItem item = TileToolStation.getTableItem(stackInSlot, this.func_145831_w(), null);
                if (item == null) continue;
                item.x = (float)(33 - info.positions.get(i).getX()) / 61.0f;
                item.z = (float)(42 - info.positions.get(i).getY()) / 61.0f;
                item.s *= s;
                if (i == 0 || info != GuiButtonRepair.info) {
                    item.s *= 1.3f;
                }
                if (stackInSlot.func_77973_b() instanceof ItemBlock && !(Block.func_149634_a((Item)stackInSlot.func_77973_b()) instanceof BlockPane)) {
                    item.y = -(1.0f - item.s) / 2.0f;
                }
                toDisplay.items.add(item);
            }
        }
        return state.withProperty((IUnlistedProperty)BlockTable.INVENTORY, (Object)toDisplay);
    }

    public void setDeconstructingStack(ItemStack stack) {
        this.deconstructingStack = stack;
    }

    public ItemStack getDeconstructingStack() {
        return this.deconstructingStack;
    }

    public boolean isDeconstructing() {
        return !this.deconstructingStack.func_190926_b();
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        ItemStack stack = new ItemStack(tags.func_74775_l("DeconstructingStack"));
        this.setDeconstructingStack(stack);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        NBTTagCompound tag = super.func_189515_b(tags);
        tag.func_74782_a("DeconstructingStack", (NBTBase)this.deconstructingStack.serializeNBT());
        return tag;
    }
}

