/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.melee.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.SwordCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.shared.client.ParticleEffect;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.melee.TinkerMeleeWeapons;
import slimeknights.tconstruct.tools.ranged.TinkerRangedWeapons;

public class Rapier
extends SwordCore {
    public static final float DURABILITY_MODIFIER = 0.8f;

    public Rapier() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.swordBlade), PartMaterialType.extra(TinkerTools.crossGuard));
        this.addCategory(Category.WEAPON);
    }

    @Override
    public float damagePotential() {
        return 0.55f;
    }

    @Override
    public float damageCutoff() {
        return 13.0f;
    }

    @Override
    public double attackSpeed() {
        return 3.0;
    }

    @Override
    public float knockback() {
        return 0.6f;
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        boolean hit = player instanceof EntityPlayer ? Rapier.dealHybridDamage(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), entity, damage) : Rapier.dealHybridDamage(DamageSource.func_76358_a((EntityLivingBase)player), entity, damage);
        if (hit && this.readyForSpecialAttack(player)) {
            TinkerTools.proxy.spawnAttackParticle(Particles.RAPIER_ATTACK, (Entity)player, 0.8);
        }
        return hit;
    }

    public static boolean dealHybridDamage(DamageSource source, Entity target, float damage) {
        boolean hit;
        if (target instanceof EntityLivingBase) {
            damage /= 2.0f;
        }
        if ((hit = target.func_70097_a(source, damage)) && target instanceof EntityLivingBase) {
            EntityLivingBase targetLiving = (EntityLivingBase)target;
            targetLiving.field_70172_ad = 0;
            targetLiving.field_110153_bc = 0.0f;
            targetLiving.func_70097_a(source.func_76348_h(), damage);
            int count = Math.round(damage / 2.0f);
            if (count > 0) {
                TinkerTools.proxy.spawnEffectParticle(ParticleEffect.Type.HEART_ARMOR, (Entity)targetLiving, count);
            }
        }
        return hit;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack offhand = playerIn.func_184592_cb();
            Item offhandItem = offhand.func_77973_b();
            if (!offhand.func_190926_b() && (offhandItem == TinkerMeleeWeapons.battleSign || offhandItem.isShield(offhand, (EntityLivingBase)playerIn) || offhandItem == TinkerRangedWeapons.shuriken)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)itemStackIn);
            }
        }
        if (playerIn.field_70122_E) {
            playerIn.func_71020_j(0.1f);
            playerIn.field_70181_x += 0.32;
            float f = 0.5f;
            playerIn.field_70159_w = MathHelper.func_76126_a((float)(playerIn.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(playerIn.field_70125_A / 180.0f * (float)Math.PI)) * f;
            playerIn.field_70179_y = -MathHelper.func_76134_b((float)(playerIn.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(playerIn.field_70125_A / 180.0f * (float)Math.PI)) * f;
            playerIn.func_184811_cZ().func_185145_a(itemStackIn.func_77973_b(), 4);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public float getRepairModifierForPart(int index) {
        return 0.8f;
    }

    @Override
    public ToolNBT buildTagData(List<Material> materials) {
        ToolNBT data = this.buildDefaultTag(materials);
        data.durability = (int)((float)data.durability * 0.8f);
        return data;
    }
}

