/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tools;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.HarvestLevels;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerTools;

public class Mattock
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials_axe = ImmutableSet.of((Object)Material.field_151575_d, (Object)Material.field_151570_A, (Object)Material.field_151585_k, (Object)Material.field_151582_l, (Object)Material.field_151572_C);
    public static final ImmutableSet<Material> effective_materials_shovel = ImmutableSet.of((Object)Material.field_151577_b, (Object)Material.field_151578_c, (Object)Material.field_151571_B);

    public Mattock() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.axeHead), PartMaterialType.head(TinkerTools.shovelHead));
        this.addCategory(Category.HARVEST);
        this.setHarvestLevel("mattock", 0);
        this.setHarvestLevel("axe", 0);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (StringUtils.func_151246_b((String)toolClass)) {
            return -1;
        }
        if (toolClass.equals("axe")) {
            return this.getAxeLevel(stack);
        }
        if (toolClass.equals("shovel")) {
            return this.getShovelLevel(stack);
        }
        return super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    @Override
    public boolean isEffective(IBlockState state) {
        return effective_materials_axe.contains((Object)state.func_185904_a()) || effective_materials_shovel.contains((Object)state.func_185904_a());
    }

    @Override
    public float miningSpeedModifier() {
        return 0.95f;
    }

    @Override
    public float damagePotential() {
        return 0.9f;
    }

    @Override
    public float knockback() {
        return 1.1f;
    }

    @Override
    public double attackSpeed() {
        return 0.9f;
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (Config.oldMattockAndKama) {
            return this.doTill(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        return this.doMakePath(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public boolean isAoeHarvestTool() {
        return false;
    }

    @Override
    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability(!detailed);
        String text = Util.translate("stat.mattock.axelevel.name", new Object[0]);
        info.add(String.format("%s: %s", text, HarvestLevels.getHarvestLevelName(this.getAxeLevel(stack))) + TextFormatting.RESET);
        text = Util.translate("stat.mattock.shovellevel.name", new Object[0]);
        info.add(String.format("%s: %s", text, HarvestLevels.getHarvestLevelName(this.getShovelLevel(stack))) + TextFormatting.RESET);
        info.addMiningSpeed();
        info.addAttack();
        if (ToolHelper.getFreeModifiers(stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }

    @Override
    public ToolNBT buildTagData(List<slimeknights.tconstruct.library.materials.Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats axe = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats shovel = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        MattockToolNBT data = new MattockToolNBT();
        data.head(axe, shovel);
        data.handle(handle);
        data.axeLevel = axe.harvestLevel;
        data.shovelLevel = shovel.harvestLevel;
        data.attack += 3.0f;
        return data;
    }

    protected int getAxeLevel(ItemStack stack) {
        return new MattockToolNBT((NBTTagCompound)TagUtil.getToolTag((ItemStack)stack)).axeLevel;
    }

    protected int getShovelLevel(ItemStack stack) {
        return new MattockToolNBT((NBTTagCompound)TagUtil.getToolTag((ItemStack)stack)).shovelLevel;
    }

    public static class MattockToolNBT
    extends ToolNBT {
        private static final String TAG_AxeLevel = "HarvestLevelAxe";
        private static final String TAG_ShovelLevel = "HarvestLevelShovel";
        public int axeLevel;
        public int shovelLevel;

        public MattockToolNBT() {
        }

        public MattockToolNBT(NBTTagCompound tag) {
            super(tag);
        }

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.axeLevel = tag.func_74762_e(TAG_AxeLevel);
            this.shovelLevel = tag.func_74762_e(TAG_ShovelLevel);
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.func_74768_a(TAG_AxeLevel, this.axeLevel);
            tag.func_74768_a(TAG_ShovelLevel, this.shovelLevel);
        }
    }
}

