/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockSlime;

public class MagmaSlimePoolGenerator
extends WorldGenerator
implements IWorldGenerator {
    public static MagmaSlimePoolGenerator INSTANCE = new MagmaSlimePoolGenerator();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!Config.genSlimePools) {
            return;
        }
        if (world.func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        if (!(world.field_73011_w instanceof WorldProviderHell)) {
            return;
        }
        this.generateMagmaPool(world, random, chunkX * 16, chunkZ * 16);
    }

    public void generateMagmaPool(World world, Random random, int chunkX, int chunkZ) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        if (random.nextInt(Config.magmaPoolRate) == 0) {
            pos.func_181079_c(chunkX + 8 + random.nextInt(8), random.nextInt(128), chunkZ + 8 + random.nextInt(8));
            this.func_180709_b(world, random, (BlockPos)pos);
        }
    }

    public boolean func_180709_b(World world, Random rand, BlockPos blockPos) {
        int yOffset;
        int xOffset;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(blockPos.func_177958_n() - 8, blockPos.func_177956_o(), blockPos.func_177952_p() - 8);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        while (y > 5 && world.func_175623_d((BlockPos)pos)) {
            pos.func_185336_p(--y);
        }
        if (y <= 4) {
            return false;
        }
        pos.func_185336_p(y -= 4);
        boolean[] shape = new boolean[2048];
        int shapeCount = rand.nextInt(4) + 4;
        ArrayList<BlockPos> fluidPositions = new ArrayList<BlockPos>();
        for (int i = 0; i < shapeCount; ++i) {
            double xSize = rand.nextDouble() * 6.0 + 3.0;
            double ySize = rand.nextDouble() * 4.0 + 2.0;
            double zSize = rand.nextDouble() * 6.0 + 3.0;
            double xCenter = rand.nextDouble() * (16.0 - xSize - 2.0) + 1.0 + xSize / 2.0;
            double yCenter = rand.nextDouble() * (8.0 - ySize - 4.0) + 2.0 + ySize / 2.0;
            double zCenter = rand.nextDouble() * (16.0 - zSize - 2.0) + 1.0 + zSize / 2.0;
            for (int xOffset2 = 1; xOffset2 < 15; ++xOffset2) {
                for (int zOffset = 1; zOffset < 15; ++zOffset) {
                    for (int yOffset2 = 1; yOffset2 < 7; ++yOffset2) {
                        double xDist = ((double)xOffset2 - xCenter) / (xSize / 2.0);
                        double yDist = ((double)yOffset2 - yCenter) / (ySize / 2.0);
                        double zDist = ((double)zOffset - zCenter) / (zSize / 2.0);
                        if (!(xDist * xDist + yDist * yDist + zDist * zDist < 1.0)) continue;
                        shape[(xOffset2 * 16 + zOffset) * 8 + yOffset2] = true;
                    }
                }
            }
        }
        for (xOffset = 0; xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                for (yOffset = 0; yOffset < 8; ++yOffset) {
                    boolean isEdge;
                    boolean bl = isEdge = !shape[(xOffset * 16 + zOffset) * 8 + yOffset] && (xOffset < 15 && shape[((xOffset + 1) * 16 + zOffset) * 8 + yOffset] || xOffset > 0 && shape[((xOffset - 1) * 16 + zOffset) * 8 + yOffset] || zOffset < 15 && shape[(xOffset * 16 + zOffset + 1) * 8 + yOffset] || zOffset > 0 && shape[(xOffset * 16 + (zOffset - 1)) * 8 + yOffset] || yOffset < 7 && shape[(xOffset * 16 + zOffset) * 8 + yOffset + 1] || yOffset > 0 && shape[(xOffset * 16 + zOffset) * 8 + (yOffset - 1)]);
                    if (!isEdge) continue;
                    pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset);
                    Material material = world.func_180495_p((BlockPos)pos).func_185904_a();
                    if (yOffset >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (yOffset >= 4 || material.func_76220_a() || world.func_180495_p((BlockPos)pos).func_177230_c() == Blocks.field_150353_l) continue;
                    return false;
                }
            }
        }
        for (xOffset = 0; xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                for (yOffset = 0; yOffset < 8; ++yOffset) {
                    if (!shape[(xOffset * 16 + zOffset) * 8 + yOffset]) continue;
                    pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset);
                    if (yOffset < 4) {
                        fluidPositions.add(pos.func_185334_h());
                    }
                    world.func_180501_a((BlockPos)pos, yOffset >= 4 ? Blocks.field_150350_a.func_176223_P() : Blocks.field_150353_l.func_176223_P(), 2);
                }
            }
        }
        if (Blocks.field_150353_l.func_176223_P().func_185904_a() == Material.field_151587_i) {
            for (xOffset = 0; xOffset < 16; ++xOffset) {
                for (int zOffset = 0; zOffset < 16; ++zOffset) {
                    for (yOffset = 0; yOffset < 8; ++yOffset) {
                        boolean isEdge;
                        boolean bl = isEdge = !shape[(xOffset * 16 + zOffset) * 8 + yOffset] && (xOffset < 15 && shape[((xOffset + 1) * 16 + zOffset) * 8 + yOffset] || xOffset > 0 && shape[((xOffset - 1) * 16 + zOffset) * 8 + yOffset] || zOffset < 15 && shape[(xOffset * 16 + zOffset + 1) * 8 + yOffset] || zOffset > 0 && shape[(xOffset * 16 + (zOffset - 1)) * 8 + yOffset] || yOffset < 7 && shape[(xOffset * 16 + zOffset) * 8 + yOffset + 1] || yOffset > 0 && shape[(xOffset * 16 + zOffset) * 8 + (yOffset - 1)]);
                        if (!isEdge || yOffset >= 4 && rand.nextInt(2) == 0) continue;
                        pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset);
                        if (!world.func_180495_p((BlockPos)pos).func_185904_a().func_76220_a()) continue;
                        pos.func_185336_p(y + yOffset + 1);
                        if (world.func_180495_p((BlockPos)pos).func_185904_a() == Material.field_151587_i) continue;
                        pos.func_185336_p(y + yOffset);
                        world.func_180501_a((BlockPos)pos, TinkerCommons.blockSlimeCongealed.func_176223_P().func_177226_a(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.MAGMA)), 2);
                    }
                }
            }
        }
        if (!fluidPositions.isEmpty()) {
            int magmaCubeCount = rand.nextInt(5) + 2;
            Collections.shuffle(fluidPositions, rand);
            for (int i = 0; i < Math.min(magmaCubeCount, fluidPositions.size()); ++i) {
                BlockPos spawnPos = (BlockPos)fluidPositions.get(i);
                if (!world.func_175623_d(spawnPos.func_177984_a())) continue;
                EntityMagmaCube magmaCube = new EntityMagmaCube(world);
                magmaCube.func_70012_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)magmaCube);
            }
        }
        return true;
    }
}

