/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.shared.block.BlockSlime;

public class SlimePoolGenerator
extends WorldGenerator
implements IWorldGenerator {
    public static SlimePoolGenerator INSTANCE = new SlimePoolGenerator();

    protected boolean shouldGenerateInDimension(int id) {
        for (int dim : Config.slimePoolDimensions) {
            if (dim != id) continue;
            return !Config.slimePoolDimensionsIsBlacklist;
        }
        return Config.slimePoolDimensionsIsBlacklist;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!Config.genSlimePools) {
            return;
        }
        if (world.func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        if (!Config.slimePoolsOnlyGenerateInSurfaceWorlds && !world.field_73011_w.func_76569_d()) {
            return;
        }
        if (!this.shouldGenerateInDimension(world.field_73011_w.getDimension())) {
            return;
        }
        this.generateSlimePool(world, random, chunkX * 16, chunkZ * 16);
    }

    public void generateSlimePool(World world, Random random, int chunkX, int chunkZ) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        if (random.nextInt(Config.slimePoolRate) == 0) {
            int height = random.nextInt(Config.slimePoolHeightMax);
            pos.func_181079_c(chunkX + 8 + random.nextInt(8), height, chunkZ + 8 + random.nextInt(8));
            this.func_180709_b(world, random, (BlockPos)pos);
        }
        pos.func_181079_c(chunkX + 16, 0, chunkZ + 16);
        Biome biome = world.func_180494_b((BlockPos)pos);
        if (biome.func_185353_n() >= 0.8f && biome.func_76727_i() >= 0.9f && random.nextInt(Config.slimePoolRate / 4 + 1) == 0) {
            int height = random.nextInt(Config.slimePoolHeightMax * 3);
            pos.func_181079_c(chunkX + 8 + random.nextInt(8), height, chunkZ + 8 + random.nextInt(8));
            this.func_180709_b(world, random, (BlockPos)pos);
        }
    }

    public boolean func_180709_b(World world, Random rand, BlockPos blockPos) {
        int yOffset;
        int xOffset;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(blockPos.func_177958_n() - 8, blockPos.func_177956_o(), blockPos.func_177952_p() - 8);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        while (y > 5 && world.func_175623_d((BlockPos)pos)) {
            pos.func_185336_p(--y);
        }
        if (y <= 4) {
            return false;
        }
        pos.func_185336_p(y -= 4);
        boolean[] shape = new boolean[2048];
        int shapeCount = rand.nextInt(4) + 4;
        ArrayList<BlockPos> fluidPositions = new ArrayList<BlockPos>();
        for (int i = 0; i < shapeCount; ++i) {
            double xSize = rand.nextDouble() * 6.0 + 3.0;
            double ySize = rand.nextDouble() * 4.0 + 2.0;
            double zSize = rand.nextDouble() * 6.0 + 3.0;
            double xCenter = rand.nextDouble() * (16.0 - xSize - 2.0) + 1.0 + xSize / 2.0;
            double yCenter = rand.nextDouble() * (8.0 - ySize - 4.0) + 2.0 + ySize / 2.0;
            double zCenter = rand.nextDouble() * (16.0 - zSize - 2.0) + 1.0 + zSize / 2.0;
            for (int xOffset2 = 1; xOffset2 < 15; ++xOffset2) {
                for (int zOffset = 1; zOffset < 15; ++zOffset) {
                    for (int yOffset2 = 1; yOffset2 < 7; ++yOffset2) {
                        double xDist = ((double)xOffset2 - xCenter) / (xSize / 2.0);
                        double yDist = ((double)yOffset2 - yCenter) / (ySize / 2.0);
                        double zDist = ((double)zOffset - zCenter) / (zSize / 2.0);
                        if (!(xDist * xDist + yDist * yDist + zDist * zDist < 1.0)) continue;
                        shape[(xOffset2 * 16 + zOffset) * 8 + yOffset2] = true;
                    }
                }
            }
        }
        for (xOffset = 0; xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                for (yOffset = 0; yOffset < 8; ++yOffset) {
                    boolean isEdge;
                    boolean bl = isEdge = !shape[(xOffset * 16 + zOffset) * 8 + yOffset] && (xOffset < 15 && shape[((xOffset + 1) * 16 + zOffset) * 8 + yOffset] || xOffset > 0 && shape[((xOffset - 1) * 16 + zOffset) * 8 + yOffset] || zOffset < 15 && shape[(xOffset * 16 + zOffset + 1) * 8 + yOffset] || zOffset > 0 && shape[(xOffset * 16 + (zOffset - 1)) * 8 + yOffset] || yOffset < 7 && shape[(xOffset * 16 + zOffset) * 8 + yOffset + 1] || yOffset > 0 && shape[(xOffset * 16 + zOffset) * 8 + (yOffset - 1)]);
                    if (!isEdge) continue;
                    pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset);
                    Material material = world.func_180495_p((BlockPos)pos).func_185904_a();
                    if (yOffset >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (yOffset >= 4 || material.func_76220_a() || world.func_180495_p((BlockPos)pos).func_177230_c() == TinkerFluids.greenSlime.getBlock()) continue;
                    return false;
                }
            }
        }
        for (xOffset = 0; xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                for (yOffset = 0; yOffset < 8; ++yOffset) {
                    if (!shape[(xOffset * 16 + zOffset) * 8 + yOffset]) continue;
                    pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset);
                    if (yOffset < 4) {
                        fluidPositions.add(pos.func_185334_h());
                    }
                    world.func_180501_a((BlockPos)pos, yOffset >= 4 ? Blocks.field_150350_a.func_176223_P() : TinkerFluids.greenSlime.getBlock().func_176223_P(), 2);
                }
            }
        }
        for (xOffset = 0; xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                for (yOffset = 4; yOffset < 8; ++yOffset) {
                    if (!shape[(xOffset * 16 + zOffset) * 8 + yOffset]) continue;
                    pos.func_181079_c(x + xOffset, y + yOffset - 1, z + zOffset);
                    if (world.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150346_d) continue;
                    pos.func_185336_p(y + yOffset);
                    if (world.func_175642_b(EnumSkyBlock.SKY, (BlockPos)pos) <= 0) continue;
                    pos.func_185336_p(0);
                    Biome biome = world.func_180494_b((BlockPos)pos.func_181079_c(x + xOffset, 0, z + zOffset));
                    pos.func_185336_p(y + yOffset - 1);
                    if (biome.field_76752_A.func_177230_c() == Blocks.field_150391_bh) {
                        world.func_180501_a((BlockPos)pos, Blocks.field_150391_bh.func_176223_P(), 2);
                        continue;
                    }
                    world.func_180501_a((BlockPos)pos, Blocks.field_150349_c.func_176223_P(), 2);
                }
            }
        }
        if (TinkerFluids.greenSlime.getBlock().func_176223_P().func_185904_a() == Material.field_151586_h) {
            for (xOffset = 0; xOffset < 16; ++xOffset) {
                for (int zOffset = 0; zOffset < 16; ++zOffset) {
                    for (yOffset = 0; yOffset < 8; ++yOffset) {
                        boolean isEdge;
                        boolean bl = isEdge = !shape[(xOffset * 16 + zOffset) * 8 + yOffset] && (xOffset < 15 && shape[((xOffset + 1) * 16 + zOffset) * 8 + yOffset] || xOffset > 0 && shape[((xOffset - 1) * 16 + zOffset) * 8 + yOffset] || zOffset < 15 && shape[(xOffset * 16 + zOffset + 1) * 8 + yOffset] || zOffset > 0 && shape[(xOffset * 16 + (zOffset - 1)) * 8 + yOffset] || yOffset < 7 && shape[(xOffset * 16 + zOffset) * 8 + yOffset + 1] || yOffset > 0 && shape[(xOffset * 16 + zOffset) * 8 + (yOffset - 1)]);
                        if (!isEdge || yOffset >= 4 && rand.nextInt(2) == 0) continue;
                        pos.func_181079_c(x + xOffset, y + yOffset, z + zOffset);
                        if (!world.func_180495_p((BlockPos)pos).func_185904_a().func_76220_a()) continue;
                        pos.func_185336_p(y + yOffset + 1);
                        if (world.func_180495_p((BlockPos)pos).func_185904_a() == Material.field_151586_h) continue;
                        pos.func_185336_p(y + yOffset);
                        world.func_180501_a((BlockPos)pos, TinkerCommons.blockSlimeCongealed.func_176223_P().func_177226_a(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.GREEN)), 2);
                    }
                }
            }
        }
        if (!fluidPositions.isEmpty()) {
            int slimeCount = rand.nextInt(5) + 2;
            Collections.shuffle(fluidPositions, rand);
            for (int i = 0; i < Math.min(slimeCount, fluidPositions.size()); ++i) {
                BlockPos spawnPos = (BlockPos)fluidPositions.get(i);
                if (!world.func_175623_d(spawnPos.func_177984_a())) continue;
                EntitySlime slime = new EntitySlime(world);
                slime.func_70012_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)slime);
            }
        }
        return true;
    }
}

