/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.quark.mixin;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.quark.base.sounds.QuarkSounds;
import vazkii.quark.misc.feature.Pickarang;
import vazkii.quark.world.entity.EntityPickarang;

@Mixin(value={EntityPickarang.class}, remap=false)
public abstract class UTEntityPickarangMixin
extends EntityThrowable {
    @Shadow
    @Final
    private static ThreadLocal<Boolean> IS_PICKARANG_UPDATING;
    @Shadow
    @Final
    private static DataParameter<Boolean> RETURNING;
    @Shadow
    private int liveTime;
    @Shadow
    private int slot;

    public UTEntityPickarangMixin(World worldIn) {
        super(worldIn);
    }

    @Shadow
    public abstract ItemStack getStack();

    @Shadow
    public abstract int getEfficiencyModifier();

    @Inject(method={"onUpdate"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void onUpdate(CallbackInfo info) {
        IS_PICKARANG_UPDATING.set(true);
        super.func_70071_h_();
        IS_PICKARANG_UPDATING.set(false);
        if (this.field_70128_L) {
            info.cancel();
            return;
        }
        boolean returning = (Boolean)this.field_70180_af.func_187225_a(RETURNING);
        ++this.liveTime;
        if (!returning) {
            if (this.liveTime > Pickarang.timeout) {
                this.setReturning();
            }
        } else {
            this.field_70145_X = true;
            ItemStack stack = this.getStack();
            int eff = this.getEfficiencyModifier();
            List items = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_186662_g(2.0));
            List xp = this.field_70170_p.func_72872_a(EntityXPOrb.class, this.func_174813_aQ().func_186662_g(2.0));
            Vec3d ourPos = this.func_174791_d();
            for (EntityItem item : items) {
                if (item.func_184218_aH()) continue;
                item.func_184220_m((Entity)this);
                item.func_174867_a(2);
            }
            for (EntityXPOrb xpOrb : xp) {
                if (xpOrb.func_184218_aH()) continue;
                xpOrb.func_184220_m((Entity)this);
                xpOrb.field_70532_c = 2;
            }
            EntityLivingBase owner = this.func_85052_h();
            if (owner == null || owner.field_70128_L || !(owner instanceof EntityPlayer)) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(stack, 0.0f);
                    this.func_70106_y();
                }
                info.cancel();
                return;
            }
            Vec3d ownerPos = owner.func_174791_d().func_72441_c(0.0, 1.0, 0.0);
            Vec3d motion = ownerPos.func_178788_d(ourPos);
            double motionMag = 3.25 + (double)eff * 0.25;
            if (motion.func_189985_c() < motionMag) {
                EntityPlayer player = (EntityPlayer)owner;
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(this.slot);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_184185_a(QuarkSounds.ENTITY_PICKARANG_PICKUP, 1.0f, 1.0f);
                    if (!stack.func_190926_b()) {
                        if (!player.field_70128_L && stackInSlot.func_190926_b()) {
                            player.field_71071_by.func_70299_a(this.slot, stack);
                        } else if (player.field_70128_L || !player.field_71071_by.func_70441_a(stack)) {
                            player.func_71019_a(stack, false);
                        }
                    }
                    if (!player.field_70128_L) {
                        ItemStack drop;
                        for (EntityItem item : items) {
                            if (item.field_70128_L) continue;
                            drop = item.func_92059_d();
                            if (!player.func_191521_c(drop)) {
                                player.func_71019_a(drop, false);
                            }
                            item.func_70106_y();
                        }
                        for (EntityXPOrb xpOrb : xp) {
                            if (xpOrb.field_70128_L) continue;
                            xpOrb.func_70100_b_(player);
                        }
                        for (Entity riding : this.func_184188_bt()) {
                            if (riding.field_70128_L) continue;
                            if (riding instanceof EntityItem) {
                                drop = ((EntityItem)riding).func_92059_d();
                                if (!player.func_191521_c(drop)) {
                                    player.func_71019_a(drop, false);
                                }
                                riding.func_70106_y();
                                continue;
                            }
                            if (!(riding instanceof EntityXPOrb)) continue;
                            riding.func_70100_b_(player);
                        }
                    }
                    this.func_70106_y();
                }
            } else {
                motion = motion.func_72432_b().func_186678_a(0.7 + (double)((float)eff * 0.325f));
                this.field_70159_w = motion.field_72450_a;
                this.field_70181_x = motion.field_72448_b;
                this.field_70179_y = motion.field_72449_c;
            }
        }
        info.cancel();
    }

    @Shadow
    protected abstract void setReturning();
}

