/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.entities.trading;

import java.util.HashMap;
import java.util.Map;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class UTVillagerProfessionRestriction {
    public static final Map<String, Entry> VILLAGER_PROFESSION_MAP = new HashMap<String, Entry>();

    public static void initBiomeRestrictions() {
        VILLAGER_PROFESSION_MAP.clear();
        for (String entry : UTConfigTweaks.ENTITIES.utVillagerProfessionBiomeRestriction) {
            try {
                String[] parts = entry.split(";");
                if (parts.length != 2) {
                    UniversalTweaks.LOGGER.warn("Invalid villager profession blacklist entry: {}", (Object)entry);
                    continue;
                }
                String mode = parts[0].trim().toLowerCase();
                if (!mode.equals("whitelist") && !mode.equals("blacklist")) {
                    UniversalTweaks.LOGGER.warn("Invalid mode in villager profession blacklist entry (must be 'whitelist' or 'blacklist'): {}", (Object)entry);
                    continue;
                }
                String[] biomeProfParts = parts[1].split("=");
                if (biomeProfParts.length != 2) {
                    UniversalTweaks.LOGGER.warn("Invalid format in villager profession blacklist entry: {}", (Object)entry);
                    continue;
                }
                String biome = biomeProfParts[0].trim();
                String[] professions = biomeProfParts[1].split(",");
                if (ForgeRegistries.BIOMES.getValue(new ResourceLocation(biome)) == null) {
                    UniversalTweaks.LOGGER.warn("Invalid biome in villager profession blacklist entry: {}", (Object)biome);
                    continue;
                }
                for (String prof : professions) {
                    if (ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation(prof = prof.trim())) != null) continue;
                    UniversalTweaks.LOGGER.warn("Invalid profession in villager profession blacklist entry: {}", (Object)prof);
                }
                VILLAGER_PROFESSION_MAP.put(biome, new Entry(mode, professions));
            }
            catch (Exception e) {
                UniversalTweaks.LOGGER.error("Error parsing villager profession blacklist entry: {}", (Object)entry, (Object)e);
            }
        }
    }

    public static class Entry {
        public final String mode;
        public final String[] professions;

        public Entry(String mode, String[] professions) {
            this.mode = mode;
            this.professions = professions;
        }
    }
}

