/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.gamewindow.mixin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.client.Minecraft;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.Util;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.Display;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Minecraft.class})
public abstract class UTWindowIconMixin {
    @Shadow
    protected abstract ByteBuffer func_152340_a(InputStream var1) throws IOException;

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setWindowIcon()V"))
    private void utWindowIcon(Minecraft mc) {
        this.ut$setWindowIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void ut$setWindowIcon() {
        block12: {
            if (Launch.minecraftHome == null) {
                return;
            }
            boolean isMac = Util.func_110647_a() == Util.EnumOS.OSX;
            InputStream icon16 = null;
            InputStream icon32 = null;
            InputStream icon256 = null;
            try {
                Path icon256Path;
                Path icon16Path = Paths.get(Launch.minecraftHome.getPath(), UTConfigTweaks.MISC.GAME_WINDOW.utGameWindowIcon16);
                Path icon32Path = Paths.get(Launch.minecraftHome.getPath(), UTConfigTweaks.MISC.GAME_WINDOW.utGameWindowIcon32);
                Path path = icon256Path = isMac ? Paths.get(Launch.minecraftHome.getPath(), UTConfigTweaks.MISC.GAME_WINDOW.utGameWindowIcon256) : null;
                if (!Files.isRegularFile(icon16Path, new LinkOption[0]) || !Files.isRegularFile(icon32Path, new LinkOption[0]) || isMac && !Files.isRegularFile(icon256Path, new LinkOption[0])) {
                    UniversalTweaks.LOGGER.error("UTWindowIcon ::: One or more icon files are missing or invalid");
                    return;
                }
                icon16 = Files.newInputStream(icon16Path, new OpenOption[0]);
                icon32 = Files.newInputStream(icon32Path, new OpenOption[0]);
                if (isMac) {
                    icon256 = Files.newInputStream(icon256Path, new OpenOption[0]);
                    Display.setIcon((ByteBuffer[])new ByteBuffer[]{this.func_152340_a(icon16), this.func_152340_a(icon32), this.func_152340_a(icon256)});
                } else {
                    Display.setIcon((ByteBuffer[])new ByteBuffer[]{this.func_152340_a(icon16), this.func_152340_a(icon32)});
                }
                IOUtils.closeQuietly((InputStream)icon16);
            }
            catch (IOException e) {
                UniversalTweaks.LOGGER.error("UTWindowIcon ::: Couldn't set icon", (Throwable)e);
                break block12;
            }
            finally {
                IOUtils.closeQuietly(icon16);
                IOUtils.closeQuietly(icon32);
                if (isMac) {
                    IOUtils.closeQuietly(icon256);
                }
            }
            IOUtils.closeQuietly((InputStream)icon32);
            if (isMac) {
                IOUtils.closeQuietly((InputStream)icon256);
            }
        }
    }
}

