/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.gui.lanserverproperties;

import java.io.IOException;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.tweaks.misc.gui.lanserverproperties.mixin.GuiShareToLanAccessor;
import mod.acgaming.universaltweaks.tweaks.misc.gui.lanserverproperties.mixin.PlayerListAccessor;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiShareToLan;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UTGuiShareToLan
extends GuiShareToLan {
    public static final String ONLINE_MODE_LANG_KEY = "btn.universaltweaks.lanserverproperties.online_mode";
    public static final String ONLINE_MODE_LANG_KEY_DESC = "btn.universaltweaks.lanserverproperties.online_mode_desc";
    public static final String SPAWN_ANIMALS_LANG_KEY = "btn.universaltweaks.lanserverproperties.spawn_animals";
    public static final String SPAWN_NPCS_LANG_KEY = "btn.universaltweaks.lanserverproperties.spawn_npcs";
    public static final String ALLOW_PVP_LANG_KEY = "btn.universaltweaks.lanserverproperties.allow_pvp";
    public static final String ALLOW_FLIGHT_LANG_KEY = "btn.universaltweaks.lanserverproperties.allow_flight";
    public static final String PORT_LANG_KEY = "btn.universaltweaks.lanserverproperties.port";
    public static final String MAX_PLAYERS_LANG_KEY = "btn.universaltweaks.lanserverproperties.max_players";
    public static final String NBT_TAG = "LANServerProperties";
    protected final GuiScreen field_146598_a;
    protected GuiTextField portTextField = null;
    protected GuiTextField maxPlayersTextField = null;
    protected GuiButton onlineModeButton = null;
    protected GuiButton spawnAnimalsButton = null;
    protected GuiButton spawnNpcsButton = null;
    protected GuiButton allowPvpButton = null;
    protected GuiButton allowFlightButton = null;
    protected boolean onlineMode = true;
    protected boolean spawnAnimals = true;
    protected boolean spawnNpcs = true;
    protected boolean allowPvp = true;
    protected boolean allowFlight = true;
    protected int port = 25565;
    protected int maxPlayers = 4;

    public UTGuiShareToLan(GuiScreen lastScreen) {
        super(lastScreen);
        this.field_146598_a = lastScreen;
    }

    public void func_73866_w_() {
        this.loadSavedSettings();
        super.func_73866_w_();
        GuiButton button = null;
        String msg = I18n.func_135052_a((String)"lanServer.start", (Object[])new Object[0]);
        for (GuiButton widget : this.field_146292_n) {
            if (!widget.field_146126_j.equals(msg)) continue;
            button = widget;
            break;
        }
        if (button == null) {
            UniversalTweaks.LOGGER.info("LAN Server Properties ::: Unable to locate start server button!");
            return;
        }
        this.onlineModeButton = new GuiButton(233, this.field_146294_l / 2 - 155, 124, 150, 20, this.getOnlineButtonText());
        this.func_189646_b(this.onlineModeButton);
        this.spawnAnimalsButton = new GuiButton(234, this.field_146294_l / 2 + 5, 124, 150, 20, this.getSpawnAnimalsButtonText());
        this.func_189646_b(this.spawnAnimalsButton);
        this.spawnNpcsButton = new GuiButton(235, this.field_146294_l / 2 + 5, 148, 150, 20, this.getSpawnNpcsButtonText());
        this.func_189646_b(this.spawnNpcsButton);
        this.allowPvpButton = new GuiButton(236, this.field_146294_l / 2 + 5, 172, 150, 20, this.getAllowPvpButtonText());
        this.func_189646_b(this.allowPvpButton);
        this.allowFlightButton = new GuiButton(237, this.field_146294_l / 2 + 5, 196, 150, 20, this.getAllowFlightButtonText());
        this.func_189646_b(this.allowFlightButton);
        this.portTextField = new GuiTextField(238, this.field_146289_q, this.field_146294_l / 2 - 154, this.field_146295_m - 54, 148, 20);
        this.portTextField.func_146180_a(String.valueOf(this.port));
        this.maxPlayersTextField = new GuiTextField(239, this.field_146289_q, this.field_146294_l / 2 + 6, this.field_146295_m - 54, 148, 20);
        this.maxPlayersTextField.func_146180_a(String.valueOf(this.maxPlayers));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 101) {
            this.serverStartButtonClick(button);
        } else if (button.field_146127_k == 233) {
            this.onlineMode = !this.onlineMode;
            button.field_146126_j = this.getOnlineButtonText();
        } else if (button.field_146127_k == 234) {
            this.spawnAnimals = !this.spawnAnimals;
            button.field_146126_j = this.getSpawnAnimalsButtonText();
        } else if (button.field_146127_k == 235) {
            this.spawnNpcs = !this.spawnNpcs;
            button.field_146126_j = this.getSpawnNpcsButtonText();
        } else if (button.field_146127_k == 236) {
            this.allowPvp = !this.allowPvp;
            button.field_146126_j = this.getAllowPvpButtonText();
        } else if (button.field_146127_k == 237) {
            this.allowFlight = !this.allowFlight;
            button.field_146126_j = this.getAllowFlightButtonText();
        } else {
            super.func_146284_a(button);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)PORT_LANG_KEY, (Object[])new Object[0]), this.field_146294_l / 2 - 155, this.field_146295_m - 66, 0xA0A0A0);
        this.portTextField.func_146194_f();
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)MAX_PLAYERS_LANG_KEY, (Object[])new Object[0]), this.field_146294_l / 2 + 5, this.field_146295_m - 66, 0xA0A0A0);
        this.maxPlayersTextField.func_146194_f();
        if (this.onlineModeButton.func_146115_a()) {
            this.func_146279_a(I18n.func_135052_a((String)ONLINE_MODE_LANG_KEY_DESC, (Object[])new Object[0]), mouseX, mouseY);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.portTextField.func_146201_a(typedChar, keyCode)) {
            this.portTextField.func_146193_g(this.validateInt(this.portTextField.func_146179_b()) > 0 ? 0xFFFFFF : 0xFF0000);
        } else if (this.maxPlayersTextField.func_146201_a(typedChar, keyCode)) {
            this.maxPlayersTextField.func_146193_g(this.validateInt(this.maxPlayersTextField.func_146179_b()) > 0 ? 0xFFFFFF : 0xFF0000);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.portTextField.func_146192_a(mouseX, mouseY, mouseButton);
        this.maxPlayersTextField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    private int validateInt(String text) {
        boolean valid = true;
        int parsedInt = -1;
        try {
            if (!(text.isEmpty() || (parsedInt = Integer.parseInt(text)) > 0 && parsedInt <= 65535)) {
                valid = false;
            }
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid ? parsedInt : -1;
    }

    private void loadSavedSettings() {
        WorldServer worldServer = this.field_146297_k.func_71401_C().func_71218_a(0);
        if (worldServer != null) {
            WorldInfo worldInfo = worldServer.func_72912_H();
            NBTTagCompound nbt = worldInfo.getDimensionData(worldServer.field_73011_w.getDimension());
            NBTTagCompound customSettings = nbt.func_74775_l(NBT_TAG);
            if (!customSettings.func_82582_d()) {
                if (customSettings.func_74764_b("GameMode")) {
                    ((GuiShareToLanAccessor)((Object)this)).setGameMode(customSettings.func_74779_i("GameMode"));
                }
                if (customSettings.func_74764_b("AllowCheats")) {
                    ((GuiShareToLanAccessor)((Object)this)).setAllowCheats(customSettings.func_74767_n("AllowCheats"));
                }
                if (customSettings.func_74764_b("OnlineMode")) {
                    this.onlineMode = customSettings.func_74767_n("OnlineMode");
                }
                if (customSettings.func_74764_b("SpawnAnimals")) {
                    this.spawnAnimals = customSettings.func_74767_n("SpawnAnimals");
                }
                if (customSettings.func_74764_b("SpawnNPCs")) {
                    this.spawnNpcs = customSettings.func_74767_n("SpawnNPCs");
                }
                if (customSettings.func_74764_b("AllowPvP")) {
                    this.allowPvp = customSettings.func_74767_n("AllowPvP");
                }
                if (customSettings.func_74764_b("AllowFlight")) {
                    this.allowFlight = customSettings.func_74767_n("AllowFlight");
                }
                if (customSettings.func_74764_b("Port")) {
                    this.port = customSettings.func_74762_e("Port");
                }
                if (customSettings.func_74764_b("MaxPlayers")) {
                    this.maxPlayers = customSettings.func_74762_e("MaxPlayers");
                }
                UniversalTweaks.LOGGER.info("LAN Server Properties ::: Loaded LAN server settings from level.dat");
            } else {
                ((GuiShareToLanAccessor)((Object)this)).setGameMode(worldInfo.func_76077_q().func_77149_b());
                ((GuiShareToLanAccessor)((Object)this)).setAllowCheats(worldInfo.func_76086_u());
                UniversalTweaks.LOGGER.info("LAN Server Properties ::: No saved LAN settings found, using defaults");
            }
        } else {
            UniversalTweaks.LOGGER.error("LAN Server Properties ::: Failed to access WorldServer for loading settings, using defaults");
        }
    }

    private void serverStartButtonClick(GuiButton button) throws IOException {
        TextComponentString textComponent;
        this.field_146297_k.func_147108_a(null);
        String portStr = this.portTextField.func_146179_b();
        int parsedPort = !portStr.isEmpty() ? this.validateInt(portStr) : this.port;
        String maxPlayersStr = this.maxPlayersTextField.func_146179_b();
        int parsedMaxPlayers = !maxPlayersStr.isEmpty() ? this.validateInt(maxPlayersStr) : this.maxPlayers;
        String gameMode = ((GuiShareToLanAccessor)((Object)this)).getGameMode();
        boolean allowCheats = ((GuiShareToLanAccessor)((Object)this)).getAllowCheats();
        String newPort = this.field_146297_k.func_71401_C().func_71206_a(GameType.func_77142_a((String)gameMode), allowCheats);
        if (newPort != null) {
            this.field_146297_k.func_71401_C().func_147137_ag().func_151265_a(null, parsedPort);
            textComponent = new TextComponentTranslation("commands.publish.started", new Object[]{newPort + ", " + parsedPort});
            this.field_146297_k.func_71401_C().func_71229_d(this.onlineMode);
            this.field_146297_k.func_71401_C().func_71251_e(this.spawnAnimals);
            this.field_146297_k.func_71401_C().func_71257_f(this.spawnNpcs);
            this.field_146297_k.func_71401_C().func_71188_g(this.allowPvp);
            this.field_146297_k.func_71401_C().func_71245_h(this.allowFlight);
            ((PlayerListAccessor)this.field_146297_k.func_71401_C().func_184103_al()).setMaxPlayers(parsedMaxPlayers);
            WorldServer worldServer = this.field_146297_k.func_71401_C().func_71218_a(0);
            if (worldServer != null) {
                WorldInfo worldInfo = worldServer.func_72912_H();
                NBTTagCompound nbt = worldInfo.getDimensionData(worldServer.field_73011_w.getDimension());
                NBTTagCompound customSettings = nbt.func_74775_l(NBT_TAG);
                if (customSettings.func_82582_d()) {
                    customSettings = new NBTTagCompound();
                    nbt.func_74782_a(NBT_TAG, (NBTBase)customSettings);
                }
                customSettings.func_74778_a("GameMode", gameMode);
                customSettings.func_74757_a("AllowCheats", allowCheats);
                customSettings.func_74757_a("OnlineMode", this.onlineMode);
                customSettings.func_74757_a("SpawnAnimals", this.spawnAnimals);
                customSettings.func_74757_a("SpawnNPCs", this.spawnNpcs);
                customSettings.func_74757_a("AllowPvP", this.allowPvp);
                customSettings.func_74757_a("AllowFlight", this.allowFlight);
                customSettings.func_74768_a("Port", parsedPort);
                customSettings.func_74768_a("MaxPlayers", parsedMaxPlayers);
                worldInfo.setDimensionData(worldServer.field_73011_w.getDimension(), nbt);
                UniversalTweaks.LOGGER.info("LAN Server Properties ::: Saved LAN server settings to level.dat");
            } else {
                UniversalTweaks.LOGGER.error("LAN Server Properties ::: Failed to access WorldServer for saving settings");
            }
        } else {
            textComponent = new TextComponentString("commands.publish.failed");
        }
        this.field_146297_k.field_71456_v.func_146158_b().func_146227_a((ITextComponent)textComponent);
    }

    private String getOnlineButtonText() {
        return I18n.func_135052_a((String)ONLINE_MODE_LANG_KEY, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.onlineMode ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String getSpawnAnimalsButtonText() {
        return I18n.func_135052_a((String)SPAWN_ANIMALS_LANG_KEY, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.spawnAnimals ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String getSpawnNpcsButtonText() {
        return I18n.func_135052_a((String)SPAWN_NPCS_LANG_KEY, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.spawnNpcs ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String getAllowPvpButtonText() {
        return I18n.func_135052_a((String)ALLOW_PVP_LANG_KEY, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.allowPvp ? "options.on" : "options.off"), (Object[])new Object[0]);
    }

    private String getAllowFlightButtonText() {
        return I18n.func_135052_a((String)ALLOW_FLIGHT_LANG_KEY, (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.allowFlight ? "options.on" : "options.off"), (Object[])new Object[0]);
    }
}

