/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.misc.music;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum UTMusicType {
    MENU,
    OVERWORLD,
    CREATIVE,
    NETHER,
    END,
    END_BOSS,
    CREDITS;

    @Nullable
    @SideOnly(value=Side.CLIENT)
    private Supplier<MusicTicker.MusicType> musicTypeSupplier;

    @SideOnly(value=Side.CLIENT)
    public void setMusicTypeSupplier(@Nonnull Supplier<MusicTicker.MusicType> musicTypeSupplier) {
        this.musicTypeSupplier = musicTypeSupplier;
    }

    @SideOnly(value=Side.CLIENT)
    public static void init() {
        MENU.setMusicTypeSupplier(() -> MusicTicker.MusicType.MENU);
        OVERWORLD.setMusicTypeSupplier(() -> MusicTicker.MusicType.GAME);
        CREATIVE.setMusicTypeSupplier(() -> MusicTicker.MusicType.CREATIVE);
        NETHER.setMusicTypeSupplier(() -> MusicTicker.MusicType.NETHER);
        END.setMusicTypeSupplier(() -> MusicTicker.MusicType.END);
        END_BOSS.setMusicTypeSupplier(() -> MusicTicker.MusicType.END_BOSS);
        CREDITS.setMusicTypeSupplier(() -> MusicTicker.MusicType.CREDITS);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Supplier<MusicTicker.MusicType> getMusicTickerType() {
        return Objects.requireNonNull(this.musicTypeSupplier);
    }
}

