/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.inventory;

import de.teamlapen.lib.lib.inventory.InventorySlot;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class InventoryHelper {
    public static ItemStack checkItems(InventorySlot.IInventorySlotInventory inventory, Item[] items, int[] amounts, int[] meta) {
        if (inventory.func_70302_i_() != amounts.length || amounts.length != meta.length || items.length != amounts.length) {
            throw new IllegalArgumentException("There has to be one amount and meta value for each slot");
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int actual;
            ItemStack stack = inventory.func_70301_a(i);
            int n = stack.func_190926_b() ? 0 : (!stack.func_77973_b().equals(items[i]) ? 0 : (actual = meta[i] == Short.MAX_VALUE || stack.func_77960_j() == meta[i] || meta[i] < 0 && stack.func_77960_j() >= -meta[i] ? stack.func_190916_E() : 0));
            if (actual >= amounts[i]) continue;
            return new ItemStack(items[i], amounts[i] - actual, meta[i] == Short.MAX_VALUE ? 0 : (meta[i] < 0 ? -meta[i] : meta[i]));
        }
        return ItemStack.field_190927_a;
    }

    public static void removeItems(InventorySlot.IInventorySlotInventory inventory, int[] amounts) {
        if (inventory.func_70302_i_() != amounts.length) {
            throw new IllegalArgumentException("There has to be one amount and meta value for each slot");
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || amounts[i] <= 0) continue;
            stack.func_190917_f(-amounts[i]);
            if (!stack.func_190926_b()) continue;
            inventory.func_70304_b(i);
        }
    }

    @Nullable
    public static IItemHandler tryGetItemHandler(IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        TileEntity tile;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().hasTileEntity(state) && (tile = world.func_175625_s(pos)) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        return null;
    }
}

