/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidLib {
    public static boolean areFluidStacksEqual(@Nullable FluidStack stackA, @Nullable FluidStack stackB) {
        return stackA == null && stackB == null || stackA != null && stackB != null && stackA.isFluidEqual(stackB);
    }

    public static boolean areFluidStacksIdentical(@Nullable FluidStack stackA, @Nullable FluidStack stackB) {
        return stackA == null && stackB == null || stackA != null && stackB != null && stackA.isFluidStackIdentical(stackB);
    }

    public static boolean hasFluidItemCap(@Nonnull ItemStack stack) {
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    public static IFluidHandler getFluidItemCap(@Nonnull ItemStack stack) {
        return (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    public static int getFluidAmount(@Nonnull IFluidHandler handler, @Nullable Fluid f) {
        FluidStack s;
        FluidStack fluidStack = s = f == null ? handler.drain(Integer.MAX_VALUE, false) : handler.drain(new FluidStack(f, Integer.MAX_VALUE), false);
        if (s != null) {
            return s.amount;
        }
        return 0;
    }
}

