/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractCriterionTrigger<T extends ICriterionInstance>
implements ICriterionTrigger<T> {
    protected final Map<PlayerAdvancements, GenericListeners<T>> listenersForPlayers = Maps.newHashMap();
    private final ResourceLocation id;
    private final Function<PlayerAdvancements, GenericListeners<T>> listenerConstructor;

    public AbstractCriterionTrigger(ResourceLocation id, Function<PlayerAdvancements, GenericListeners<T>> listenerConstructor) {
        this.id = id;
        this.listenerConstructor = listenerConstructor;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<T> listener) {
        GenericListeners<T> listeners = this.listenersForPlayers.get(playerAdvancementsIn);
        if (listeners == null) {
            listeners = this.listenerConstructor.apply(playerAdvancementsIn);
            this.listenersForPlayers.put(playerAdvancementsIn, listeners);
        }
        listeners.add(listener);
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listenersForPlayers.remove(playerAdvancementsIn);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<T> listener) {
        GenericListeners<T> listeners = this.listenersForPlayers.get(playerAdvancementsIn);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listenersForPlayers.remove(playerAdvancementsIn);
            }
        }
    }

    protected static abstract class GenericListeners<T extends ICriterionInstance> {
        protected final PlayerAdvancements playerAdvancements;
        protected final Set<ICriterionTrigger.Listener<T>> playerListeners = Sets.newHashSet();

        public GenericListeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public void add(ICriterionTrigger.Listener<T> listener) {
            this.playerListeners.add(listener);
        }

        public boolean isEmpty() {
            return this.playerListeners.isEmpty();
        }

        public void remove(ICriterionTrigger.Listener<T> listener) {
            this.playerListeners.remove(listener);
        }
    }
}

