/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.skills;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class SkillNode {
    private final SkillNode parent;
    private final List<SkillNode> children;
    private final ISkill[] elements;
    private final int depth;
    private final IPlayableFaction faction;

    private SkillNode(IPlayableFaction faction, SkillNode parent, int depth, ISkill ... elements) {
        this.parent = parent;
        this.faction = faction;
        this.depth = depth;
        this.children = new ArrayList<SkillNode>();
        this.elements = elements;
    }

    @Deprecated
    public SkillNode(IPlayableFaction faction, ISkill element) {
        this(faction, null, 0, element);
    }

    @Deprecated
    public SkillNode(SkillNode parent, ISkill ... elements) {
        this(parent.getFaction(), parent, parent.depth + 1, elements);
        parent.children.add(this);
    }

    public boolean containsSkill(ISkill skill) {
        return ArrayUtils.contains((Object[])this.elements, (Object)skill);
    }

    public List<SkillNode> getChildren() {
        return this.children;
    }

    public int getDepth() {
        return this.depth;
    }

    public ISkill[] getElements() {
        return this.elements;
    }

    public IPlayableFaction getFaction() {
        return this.faction;
    }

    public SkillNode getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String toString() {
        return "SkillNode{faction=" + this.faction + ", depth=" + this.depth + ", elements=" + Arrays.toString(this.elements) + '}';
    }
}

