/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.GuiSkills;
import de.teamlapen.vampirism.client.gui.GuiSleepCoffin;
import de.teamlapen.vampirism.client.model.blocks.BakedAltarInspirationModel;
import de.teamlapen.vampirism.client.model.blocks.BakedBloodContainerModel;
import de.teamlapen.vampirism.client.model.blocks.BakedWeaponTableModel;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    private static final int SKILLBUTTONID = 27496;
    private static final ResourceLocation INVENTORY_SKILLS = new ResourceLocation("vampirism", "textures/gui/inventory_skills.png");

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null && mc.field_71441_e != null) {
                if ((mc.field_71462_r == null || mc.field_71462_r instanceof GuiSleepMP) && mc.field_71439_g.func_70608_bn()) {
                    IBlockState state = mc.field_71439_g.func_130014_f_().func_180495_p(mc.field_71439_g.field_71081_bT);
                    if (state.func_177230_c().equals((Object)ModBlocks.block_coffin)) {
                        mc.func_147108_a((GuiScreen)new GuiSleepCoffin());
                    }
                } else if (mc.field_71462_r != null && mc.field_71462_r instanceof GuiSleepCoffin && !mc.field_71439_g.func_70608_bn()) {
                    mc.func_147108_a(null);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onActionPerformedPre(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (Configs.gui_skill_button_enable && event.getGui() instanceof GuiInventory) {
            if (event.getButton().field_146127_k == 27496) {
                event.getGui().field_146297_k.func_147108_a((GuiScreen)new GuiSkills());
            } else if (event.getButton().field_146127_k == 10) {
                for (GuiButton e : event.getButtonList()) {
                    if (e.field_146127_k != 27496) continue;
                    ((GuiButtonImage)e).func_191746_c(((GuiInventory)event.getGui()).getGuiLeft() + 125, event.getGui().field_146295_m / 2 - 22);
                    break;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onInitGuiEventPost(GuiScreenEvent.InitGuiEvent.Post event) {
        if (Configs.gui_skill_button_enable && event.getGui() instanceof GuiInventory && FactionPlayerHandler.get((EntityPlayer)event.getGui().field_146297_k.field_71439_g).getCurrentFactionPlayer() != null) {
            List buttonList = event.getButtonList();
            GuiButtonImage button = new GuiButtonImage(27496, ((GuiInventory)event.getGui()).getGuiLeft() + 125, event.getGui().field_146295_m / 2 - 22, 20, 18, 178, 0, 19, INVENTORY_SKILLS);
            buttonList.add(button);
            event.setButtonList(buttonList);
        }
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        Object newModel;
        IBakedModel registeredModel;
        ArrayList modelLocations;
        IModel model;
        Function<ResourceLocation, TextureAtlasSprite> textureGetter;
        IModel[] containerFluidModels = new IModel[14];
        try {
            for (int x = 0; x < 14; ++x) {
                containerFluidModels[x] = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("vampirism:block/blood_container/fluid_" + (x + 1)));
            }
            textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            for (Map.Entry entry : FluidRegistry.getRegisteredFluids().entrySet()) {
                for (int x = 0; x < containerFluidModels.length; ++x) {
                    IModel retexturedModel = containerFluidModels[x].retexture(new ImmutableMap.Builder().put((Object)"fluid", (Object)((Fluid)entry.getValue()).getStill().toString()).build());
                    BakedBloodContainerModel.FLUID_MODELS[x].put((String)entry.getKey(), retexturedModel.bake(retexturedModel.getDefaultState(), Attributes.DEFAULT_BAKED_FORMAT, textureGetter));
                }
            }
            RegistrySimple registry = (RegistrySimple)event.getModelRegistry();
            ArrayList modelLocations2 = Lists.newArrayList();
            for (ModelResourceLocation modelLoc : registry.func_148742_b()) {
                if (!modelLoc.func_110624_b().equals("vampirism") || !modelLoc.func_110623_a().equals("blood_container")) continue;
                modelLocations2.add(modelLoc);
            }
            Iterator iterator = modelLocations2.iterator();
            while (iterator.hasNext()) {
                ModelResourceLocation loc = (ModelResourceLocation)iterator.next();
                IBakedModel registeredModel2 = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
                BakedBloodContainerModel newModel2 = new BakedBloodContainerModel(registeredModel2);
                event.getModelRegistry().func_82595_a((Object)loc, (Object)newModel2);
            }
        }
        catch (Exception e) {
            VampirismMod.log.e("ModelBake", e, "Failed to load fluid models for blood container", new Object[0]);
            return;
        }
        try {
            textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            for (int x = 0; x < 10; ++x) {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("vampirism:block/altar_inspiration/blood" + (x + 1)));
                BakedAltarInspirationModel.FLUID_MODELS[x] = model.bake(model.getDefaultState(), Attributes.DEFAULT_BAKED_FORMAT, textureGetter);
            }
            RegistrySimple registry = (RegistrySimple)event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ModelResourceLocation modelLoc : registry.func_148742_b()) {
                if (!modelLoc.func_110624_b().equals("vampirism") || !modelLoc.func_110623_a().equals("altar_inspiration") || modelLoc.func_177518_c().equals("inventory")) continue;
                modelLocations.add(modelLoc);
            }
            for (ModelResourceLocation loc : modelLocations) {
                registeredModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
                newModel = new BakedAltarInspirationModel(registeredModel);
                event.getModelRegistry().func_82595_a((Object)loc, newModel);
            }
        }
        catch (Exception e) {
            VampirismMod.log.e("ModelBake", e, "Failed to load fluid models for altar inspiration", new Object[0]);
        }
        try {
            textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            for (int x = 0; x < 5; ++x) {
                model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("vampirism:block/weapon_table/weapon_table_lava" + (x + 1)));
                BakedWeaponTableModel.FLUID_MODELS[x] = model.bake(model.getDefaultState(), Attributes.DEFAULT_BAKED_FORMAT, textureGetter);
            }
            RegistrySimple registry = (RegistrySimple)event.getModelRegistry();
            modelLocations = Lists.newArrayList();
            for (ModelResourceLocation modelLoc : registry.func_148742_b()) {
                if (!modelLoc.func_110624_b().equals("vampirism") || !modelLoc.func_110623_a().equals("weapon_table") || modelLoc.func_177518_c().equals("inventory")) continue;
                modelLocations.add(modelLoc);
            }
            for (ModelResourceLocation loc : modelLocations) {
                registeredModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)loc);
                newModel = new BakedWeaponTableModel(registeredModel);
                event.getModelRegistry().func_82595_a((Object)loc, newModel);
            }
        }
        catch (Exception e) {
            VampirismMod.log.e("ModelBake", e, "Failed to load fluid models for weapon crafting table", new Object[0]);
        }
    }

    @SubscribeEvent
    public void onFovOffsetUpdate(FOVUpdateEvent event) {
        if (Configs.disable_fov_changes && Helper.isVampire((Entity)event.getEntity())) {
            IAttributeInstance speed = event.getEntity().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
            AttributeModifier vampirespeed = speed.func_111127_a(LevelAttributeModifier.getUUID(SharedMonsterAttributes.field_111263_d));
            if (vampirespeed == null) {
                return;
            }
            event.setNewfov((float)((double)event.getFov() * ((vampirespeed.func_111164_d() + 1.0) * (double)event.getEntity().field_71075_bZ.func_75094_b() + speed.func_111126_e()) / ((vampirespeed.func_111164_d() + 1.0) * ((double)event.getEntity().field_71075_bZ.func_75094_b() + speed.func_111126_e()))));
        }
    }
}

