/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.blocks.VampirismFlower;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModVillages;
import de.teamlapen.vampirism.entity.converted.VampirismEntityRegistry;
import de.teamlapen.vampirism.modcompat.IntegrationsNotifier;
import de.teamlapen.vampirism.network.SyncConfigPacket;
import de.teamlapen.vampirism.tileentity.TileTotem;
import de.teamlapen.vampirism.util.DaySleepHelper;
import de.teamlapen.vampirism.util.REFERENCE;
import de.teamlapen.vampirism.world.ModWorldEventListener;
import de.teamlapen.vampirism.world.villages.VampirismVillage;
import de.teamlapen.vampirism.world.villages.VampirismVillageHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.village.Village;
import net.minecraft.world.IWorldEventListener;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.commons.lang3.StringUtils;

public class ModEventHandler {
    private static final String TAG = "EventHandler";
    private boolean warnedVillageGen = false;

    @SubscribeEvent
    public void onAttachCapabilitiesVillage(AttachCapabilitiesEvent<Village> event) {
        event.addCapability(REFERENCE.VAMPIRISM_VILLAGE_KEY_NEW, VampirismVillage.createNewCapability((Village)event.getObject()));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!UtilLib.isSameInstanceAsServer()) {
            VampirismEntityRegistry.getBiteableEntryManager().initDynamic();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (!UtilLib.isSameInstanceAsServer()) {
            Configs.onDisconnectedFromServer();
            VampirismEntityRegistry.getBiteableEntryManager().resetDynamic();
        }
    }

    @SubscribeEvent
    public void onConfigurationChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equalsIgnoreCase("vampirism")) {
            VampirismMod.log.i(TAG, "Configuration (%s) changed", e.getConfigID());
            Configs.onConfigurationChanged();
            Balance.onConfigurationChanged();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInitMapGen(InitMapGenEvent event) {
        if (event.getType().equals((Object)InitMapGenEvent.EventType.VILLAGE) && Configs.village_modify) {
            if (event.getNewGen() != event.getOriginalGen() && !this.warnedVillageGen) {
                this.warnedVillageGen = true;
                VampirismMod.log.w(TAG, "The village map generator was overwritten by another mod. There might be a problem! \n The new generator class is " + event.getNewGen().getClass().getCanonicalName(), new Object[0]);
            }
            ModVillages.modifyVillageSize(event.getNewGen());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        List<String> mods;
        String template;
        boolean isAdminLikePlayer;
        VersionChecker.VersionInfo versionInfo = VampirismMod.instance.getVersionInfo();
        if (!versionInfo.isChecked()) {
            VampirismMod.log.w(TAG, "Version check is not finished yet", new Object[0]);
        }
        boolean bl = isAdminLikePlayer = !FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() || UtilLib.isPlayerOp(event.player);
        if (!Configs.disable_versionCheck && versionInfo.isNewVersionAvailable() && (isAdminLikePlayer || event.player.func_70681_au().nextInt(5) == 0) && event.player.func_70681_au().nextInt(4) == 0) {
            VersionChecker.Version newVersion = versionInfo.getNewVersion();
            event.player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.outdated", new Object[]{versionInfo.getCurrentVersion().name, newVersion.name}));
            template = UtilLib.translate("text.vampirism.update_message");
            template = template.replaceAll("@download@", newVersion.getUrl() == null ? versionInfo.getHomePage() : newVersion.getUrl()).replaceAll("@forum@", versionInfo.getHomePage());
            ITextComponent component = ITextComponent.Serializer.func_150699_a((String)template);
            event.player.func_145747_a(component);
        }
        if (isAdminLikePlayer && !(mods = IntegrationsNotifier.shouldNotifyAboutIntegrations()).isEmpty()) {
            event.player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.integrations_available.first", new Object[0]));
            event.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.BLUE + TextFormatting.ITALIC.toString() + StringUtils.join(mods, (String)", ") + TextFormatting.RESET));
            template = UtilLib.translate("text.vampirism.integrations_available.second");
            template = template.replaceAll("@download@", "https://minecraft.curseforge.com/projects/vampirism-integrations");
            event.player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)template));
        }
        if (Configs.updated_vampirism && (!FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() || UtilLib.isPlayerOp(event.player))) {
            event.player.func_145747_a((ITextComponent)new TextComponentString("It looks like you have updated Vampirism"));
            event.player.func_145747_a((ITextComponent)new TextComponentString("Please consider resetting the balance values to the updated ones, using " + TextFormatting.DARK_GREEN + "'/vampirism resetBalance all'" + TextFormatting.RESET));
            event.player.func_145747_a((ITextComponent)new TextComponentString("For more information use " + TextFormatting.DARK_GREEN + "'/vampirism resetBalance help'" + TextFormatting.RESET));
        }
        if (!PermissionAPI.hasPermission((EntityPlayer)event.player, (String)"vampirism.check")) {
            event.player.func_145747_a((ITextComponent)new TextComponentString("[" + TextFormatting.DARK_PURPLE + "Vampirism" + TextFormatting.RESET + "] It seems like the permission plugin used is not properly set up. Make sure all players have 'vampirism.*' for the mod to work (or at least '" + "vampirism.check" + "' to suppress this warning)."));
        }
        if (!Configs.disable_config_sync && event.player != null && event.player instanceof EntityPlayerMP) {
            VampirismMod.log.d(TAG, "Sending configuration to client (%s)", event.player);
            VampirismMod.dispatcher.sendTo(SyncConfigPacket.createSyncConfigPacket(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)new ModWorldEventListener(event.getWorld().field_73011_w.getDimension()));
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            DaySleepHelper.checkSleepWorld(event.world);
            VampirismVillageHelper.tick(event.world);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        VampirismAPI.getGarlicChunkHandler(event.getWorld()).clear();
        TileTotem.clearCacheForDimension(event.getWorld().field_73011_w.getDimension());
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer p;
        if (event.getState().func_177230_c() == Blocks.field_150362_t && event.getState().func_177229_b((IProperty)BlockOldLeaf.field_176239_P) == BlockPlanks.EnumType.OAK && ((Object)((Object)ModBiomes.vampireForest)).equals(event.getWorld().func_180494_b(event.getPos())) && (p = event.getHarvester()) != null && p.func_70681_au().nextInt(Balance.general.DROP_ORCHID_FROM_LEAVES_CHANCE) == 0) {
            event.getDrops().add(new ItemStack((Block)ModBlocks.vampirism_flower, 1, VampirismFlower.EnumFlowerType.ORCHID.getMeta()));
        }
    }
}

